/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model;

import com.atlassian.crowd.integration.directory.RemoteDirectory;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.RemotePrincipal;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryInstantiationException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryContainer
extends DirectoryEntity
implements Group,
Serializable {
    private static final Logger logger = Logger.getLogger(DirectoryContainer.class);
    protected Set<RemotePrincipal> principalMembers = null;
    protected Set<? extends DirectoryContainer> containerMembers = null;
    protected Collection<String> memberDNs;
    protected Directory directory;

    protected DirectoryContainer() {
    }

    protected DirectoryContainer(DirectoryContainer directoryContainer) {
        super(directoryContainer);
        if (directoryContainer.getMemberDNs() != null) {
            this.memberDNs = new ArrayList<String>(directoryContainer.getMemberDNs().size());
            for (String memberDN : directoryContainer.getMemberDNs()) {
                this.memberDNs.add(memberDN);
            }
        }
    }

    public boolean addMember(Principal user) {
        return this.getPrincipalMembers().add(user);
    }

    public boolean isMember(Principal member) {
        return this.getPrincipalMembers().contains(member);
    }

    public boolean removeMember(Principal user) {
        return this.getPrincipalMembers().remove(user);
    }

    public Enumeration members() {
        class IteratorEnumeration
        implements Enumeration {
            private Iterator iterator;

            public IteratorEnumeration(Iterator iterator) {
                this.iterator = iterator;
            }

            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() throws NoSuchElementException {
                return this.iterator.next();
            }
        }
        return new IteratorEnumeration(this.getPrincipalMembers().iterator());
    }

    public Set getPrincipalMembers() {
        if (this.principalMembers == null && this.directory != null) {
            try {
                this.principalMembers = this.loadMembers(this.directory.getImplementation());
            }
            catch (RemoteException e) {
                logger.error((Object)("Failed to load members of container: " + this.getName() + " in directoryID: " + this.getDirectoryID()), (Throwable)e);
            }
            catch (DirectoryInstantiationException e) {
                logger.error((Object)("Failed to load members of container: " + this.getName() + " in directoryID: " + this.getDirectoryID()), (Throwable)e);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (this.principalMembers == null) {
            this.principalMembers = new HashSet<RemotePrincipal>(0);
        }
        return this.principalMembers;
    }

    public Set getContainerMembers() {
        if (this.containerMembers == null) {
            this.containerMembers = new HashSet<DirectoryContainer>(0);
        }
        return this.containerMembers;
    }

    public void setContainerMembers(Set<? extends DirectoryContainer> containerMembers) {
        this.containerMembers = containerMembers;
    }

    public Collection<String> getMemberDNs() {
        return this.memberDNs;
    }

    public void setMemberDNs(Collection<String> memberDNs) {
        this.memberDNs = memberDNs;
    }

    protected abstract Set loadMembers(RemoteDirectory var1) throws RemoteException;

    public void setPrincipalMembers(Set<RemotePrincipal> principalMembers) {
        this.principalMembers = principalMembers;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }
}

