/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class AcceptanceTestHelper {
    private static final String IT_TEST_RESOURCES = "target/it-classes";

    protected static File loadFileFromClasspath(String source) throws Exception {
        File testFile = AcceptanceTestHelper.getResource(source);
        if (!testFile.exists()) {
            throw new Exception("Could not find an existing file on filesystem to match:" + source);
        }
        return testFile;
    }

    public static String getTestResourcesLocation() {
        return IT_TEST_RESOURCES;
    }

    public static InputStream getResourceAsStream(String fileName) throws Exception {
        File resource = new File(AcceptanceTestHelper.getTestResourcesLocation(), fileName);
        if (resource.exists()) {
            return new FileInputStream(resource);
        }
        URL classpathResource = AcceptanceTestHelper.class.getResource("/" + fileName);
        return classpathResource.openStream();
    }

    public static File getResource(String fileName) {
        File fileResource = new File(AcceptanceTestHelper.getTestResourcesLocation(), fileName);
        if (fileResource.exists()) {
            return fileResource;
        }
        URL classpathResource = AcceptanceTestHelper.class.getResource("/" + fileName);
        if (classpathResource != null) {
            try {
                return new File(classpathResource.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("File does not exist: " + fileName);
    }

    public static String getResourcePath(String fileName) {
        return AcceptanceTestHelper.getResource(fileName).getAbsolutePath();
    }

    public static Properties loadProperties(String fileName) {
        Preconditions.checkNotNull((Object)fileName);
        Properties props = new Properties();
        InputStream inputStream = AcceptanceTestHelper.class.getResourceAsStream("/" + fileName);
        if (inputStream == null) {
            throw new RuntimeException("Unable to load properties file: " + fileName);
        }
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties file: " + fileName, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return props;
    }
}

