/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.WebhookNotFoundException;
import com.atlassian.crowd.integration.rest.service.RestCrowdClient;
import com.atlassian.crowd.model.authentication.Session;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.test.matchers.CrowdMatchers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;

public class RestCrowdClientTest
extends CrowdAcceptanceTestCase {
    private static final String APPLICATION_NAME = "crowd";
    private static final String APPLICATION_PASSWORD = "qybhDMZh";
    private static final ValidationFactor[] NO_VALIDATION_FACTORS = new ValidationFactor[0];
    private static final String NON_EXISTENT_TOKEN = "this-token-key-does-not-exist";
    private static final long NON_EXISTENT_WEBHOOKID = 999L;
    private CrowdClient crowdClient;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        this.crowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        this.restoreCrowdFromXML("remotecrowddirectory.xml");
    }

    public void testGetUser() throws Exception {
        User user = this.crowdClient.getUser("admin");
        RestCrowdClientTest.assertEquals((String)"admin", (String)user.getName());
        RestCrowdClientTest.assertEquals((String)"bob", (String)user.getFirstName());
        RestCrowdClientTest.assertEquals((String)"the builder", (String)user.getLastName());
        RestCrowdClientTest.assertEquals((String)"bob@example.net", (String)user.getEmailAddress());
        RestCrowdClientTest.assertTrue((boolean)user.isActive());
        RestCrowdClientTest.assertEquals((String)"2:externalId", (String)user.getExternalId());
    }

    public void testGetUserByKey() throws Exception {
        User user = this.crowdClient.getUserByKey("2:externalId");
        RestCrowdClientTest.assertEquals((String)"admin", (String)user.getName());
        RestCrowdClientTest.assertEquals((String)"bob", (String)user.getFirstName());
        RestCrowdClientTest.assertEquals((String)"the builder", (String)user.getLastName());
        RestCrowdClientTest.assertEquals((String)"bob@example.net", (String)user.getEmailAddress());
        RestCrowdClientTest.assertTrue((boolean)user.isActive());
        RestCrowdClientTest.assertEquals((String)"2:externalId", (String)user.getExternalId());
    }

    public void testGetGroupNameMembershipsForGroup() throws Exception {
        List<String> expectedGroupNames = Arrays.asList("crowd-testers", "crowd-users");
        List groupNames = this.crowdClient.getNamesOfParentGroupsForGroup("badgers", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groupNames);
        RestCrowdClientTest.assertEquals((int)expectedGroupNames.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroupNames));
    }

    public void testGetGroupNameMembershipsForGroup_InvalidStartIndex() throws Exception {
        try {
            this.crowdClient.getNamesOfParentGroupsForGroup("badgers", -1, 50);
            RestCrowdClientTest.fail((String)"Expected OperationFailedException");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public void testGetGroupNameMembershipsForGroup_NonExistentGroup() throws Exception {
        List groupNames = this.crowdClient.getNamesOfParentGroupsForGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groupNames);
        RestCrowdClientTest.assertTrue((boolean)groupNames.isEmpty());
    }

    public void testGetNestedUserNameMembersOfGroup() throws Exception {
        List<String> expectedUsernames = Arrays.asList("secondadmin", "penny", "admin", "eeeep");
        List usernames = this.crowdClient.getNamesOfNestedUsersOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)usernames);
        RestCrowdClientTest.assertEquals((int)expectedUsernames.size(), (int)usernames.size());
        RestCrowdClientTest.assertTrue((boolean)usernames.containsAll(expectedUsernames));
    }

    public void testGetNestedUserNameMembersOfGroup_NonExistentGroup() throws Exception {
        List usernames = this.crowdClient.getNamesOfNestedUsersOfGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)usernames);
        RestCrowdClientTest.assertTrue((boolean)usernames.isEmpty());
    }

    public void testGetNestedGroupMembersOfGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-testers", "badgers");
        List groups = this.crowdClient.getNestedChildGroupsOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        ArrayList<String> groupNames = new ArrayList<String>(groups.size());
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembersOfGroup_NonExistentGroup() throws Exception {
        List groups = this.crowdClient.getNestedChildGroupsOfGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupNameMembersOfGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-testers", "badgers");
        List groups = this.crowdClient.getNamesOfNestedChildGroupsOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groups.size());
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupNameMembersOfGroup_NonExistent() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-testers", "badgers");
        List groups = this.crowdClient.getNamesOfNestedChildGroupsOfGroup("crowd-administrators", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groups.size());
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembershipsForUser() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "badgers", "crowd-users");
        List groups = this.crowdClient.getGroupsForNestedUser("admin", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembershipsForUser_NonExistent() throws Exception {
        List groups = this.crowdClient.getGroupsForNestedUser("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupNameMembershipsForUser() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "badgers", "crowd-users");
        List groups = this.crowdClient.getNamesOfGroupsForNestedUser("admin", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupNameMembershipsForUser_NonExistent() throws Exception {
        List groups = this.crowdClient.getNamesOfGroupsForNestedUser("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupMembershipsForGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "crowd-users");
        List groups = this.crowdClient.getParentGroupsForNestedGroup("badgers", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groupNames.size());
        RestCrowdClientTest.assertTrue((boolean)groupNames.containsAll(expectedGroups));
    }

    public void testGetNestedGroupMembershipsForGroup_NonExistent() throws Exception {
        List groups = this.crowdClient.getParentGroupsForNestedGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testGetNestedGroupNameMembershipsForGroup() throws Exception {
        List<String> expectedGroups = Arrays.asList("crowd-administrators", "crowd-testers", "crowd-users");
        List groups = this.crowdClient.getNamesOfParentGroupsForNestedGroup("badgers", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertEquals((int)expectedGroups.size(), (int)groups.size());
        RestCrowdClientTest.assertTrue((boolean)groups.containsAll(expectedGroups));
    }

    public void testGetNestedGroupNameMembershipsForGroup_NonExistent() throws Exception {
        List groups = this.crowdClient.getNamesOfParentGroupsForNestedGroup("non-existent", 0, 50);
        RestCrowdClientTest.assertNotNull((Object)groups);
        RestCrowdClientTest.assertTrue((boolean)groups.isEmpty());
    }

    public void testAddUser() throws Exception {
        this.intendToModifyData();
        UserTemplate userTemplate = new UserTemplate("newuser", "fname", "lname", "dname");
        this.crowdClient.addUser((User)userTemplate, PasswordCredential.unencrypted((String)"newpassword"));
        User foundUser = this.crowdClient.getUser("newuser");
        RestCrowdClientTest.assertNotNull((String)"An identifier should be generated for the user", (Object)foundUser.getExternalId());
    }

    public void testAddUserWithEncryptedPassword() throws Exception {
        this.intendToModifyData();
        String username = "newuser";
        String password = "encoded-password";
        String encodedPassword = new AtlassianSHA1PasswordEncoder().encodePassword(password, null);
        UserTemplate userTemplate = new UserTemplate(username, "fname", "lname", "dname");
        userTemplate.setActive(true);
        this.crowdClient.addUser((User)userTemplate, PasswordCredential.encrypted((String)encodedPassword));
        this.crowdClient.addUserToGroup(username, "crowd-administrators");
        User authenticatedUser = this.crowdClient.authenticateUser(username, password);
        RestCrowdClientTest.assertNotNull((String)"An identifier should be generated for the user", (Object)authenticatedUser.getExternalId());
    }

    public void testRenameUser() throws Exception {
        this.intendToModifyData();
        String user = "eeeep";
        String newUsername = "abc123";
        User renamedUser = this.crowdClient.renameUser("eeeep", "abc123");
        Assert.assertThat((Object)renamedUser.getName(), (Matcher)Matchers.is((Object)"abc123"));
    }

    public void testUpdateUserCredential() throws Exception {
        this.intendToModifyData();
        String user = "eeeep";
        String oldPassword = "abc123";
        String newPassword = "newpassword";
        this.crowdClient.authenticateUser("eeeep", "abc123");
        this.crowdClient.updateUserCredential("eeeep", "newpassword");
        try {
            this.crowdClient.authenticateUser("eeeep", "abc123");
            RestCrowdClientTest.fail((String)"User should no longer be able to authenticate with the old password");
        }
        catch (InvalidAuthenticationException e) {
            // empty catch block
        }
        this.crowdClient.authenticateUser("eeeep", "newpassword");
    }

    public void testUpdateUserCredentialToNone() throws Exception {
        this.intendToModifyData();
        String user = "eeeep";
        String oldPassword = "abc123";
        this.crowdClient.authenticateUser("eeeep", "abc123");
        this.crowdClient.updateUserCredential("eeeep", null);
        try {
            this.crowdClient.authenticateUser("eeeep", "abc123");
            RestCrowdClientTest.fail((String)"User should no longer be able to authenticate with the old password");
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            // empty catch block
        }
    }

    public void testUpdateUserCredentialPasswordDoesNotMatchDirectoryComplexityRequirement() throws Exception {
        this.intendToModifyData();
        String user = "eeeep";
        String oldPassword = "abc123";
        this.crowdClient.authenticateUser("eeeep", "abc123");
        try {
            this.crowdClient.updateUserCredential("eeeep", "PASSWORD-WITHOUT-LOWERCASE");
            RestCrowdClientTest.fail((String)"The password shouldn't be changed if it does not match the directory complexity requirements");
        }
        catch (InvalidCredentialException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Passwords must contain at least one lowercase character"));
        }
        this.crowdClient.authenticateUser("eeeep", "abc123");
    }

    public void testConnectToInvalidRestService() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH + "/badservice");
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        RestCrowdClient badCrowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        try {
            badCrowdClient.testConnection();
            RestCrowdClientTest.fail((String)"OperationFailedException expected.");
        }
        catch (OperationFailedException e) {
            // empty catch block
        }
    }

    public void testConnectToRestService_WrongPassword() throws Exception {
        String APPLICATION_AUTHENTICATION_ERROR_MSG = "Application failed to authenticate";
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", "blah");
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        RestCrowdClient badCrowdClient = new RestCrowdClient((ClientProperties)clientProperties);
        try {
            badCrowdClient.testConnection();
            RestCrowdClientTest.fail((String)"OperationFailedException expected.");
        }
        catch (InvalidAuthenticationException e) {
            RestCrowdClientTest.assertEquals((String)"Application failed to authenticate", (String)e.getMessage());
        }
    }

    public void testGetMemberships() throws Exception {
        Iterable groups = this.crowdClient.getMemberships();
        RestCrowdClientTest.assertNotNull((Object)groups);
        Iterator i = groups.iterator();
        RestCrowdClientTest.assertTrue((boolean)i.hasNext());
        RestCrowdClientTest.assertNotNull(i.next());
    }

    public void testQueryForNullFirstNames() throws Exception {
        PropertyRestriction restriction = Restriction.on((Property)UserTermKeys.FIRST_NAME).isNull();
        List users = this.crowdClient.searchUsers((SearchRestriction)restriction, 0, -1);
        RestCrowdClientTest.assertEquals(Collections.emptyList(), (Object)users);
    }

    public void testSearchGroupsWithAttributes() throws Exception {
        PropertyRestriction restriction = Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)"badgers");
        List groupWithAttributes = this.crowdClient.searchGroupsWithAttributes((SearchRestriction)restriction, 0, -1);
        Assert.assertThat((Object)groupWithAttributes, (Matcher)Matchers.contains((Matcher)CrowdMatchers.entityWithAttributes(GroupWithAttributes.class).hasEntry("secret-location", "hollow")));
    }

    public void testMailUsernamesFailsWithUnknownAddress() throws Exception {
        try {
            this.crowdClient.requestUsernames("no-user-with@this-email-address.invalid");
            RestCrowdClientTest.fail((String)"Request for usernames should fail for unused email address.");
        }
        catch (OperationFailedException ofe) {
            RestCrowdClientTest.assertEquals((String)"Not Found", (String)ofe.getMessage());
        }
    }

    public void testUpdateGroupWithAttributes() throws Exception {
        this.intendToModifyData();
        this.crowdClient.storeGroupAttributes("badgers", (Map)ImmutableMap.of((Object)"favourite-colour", (Object)ImmutableSet.of((Object)"green")));
        GroupWithAttributes badgers = this.crowdClient.getGroupWithAttributes("badgers");
        Assert.assertThat((Object)badgers, (Matcher)CrowdMatchers.entityWithAttributes(UserWithAttributes.class).hasEntry("favourite-colour", "green"));
    }

    public void testSSOUserWithDefaultTokenDuration() throws Exception {
        this.intendToModifyData();
        this._invalidateExistingSessions("admin");
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext("admin", new PasswordCredential("admin"), NO_VALIDATION_FACTORS, APPLICATION_NAME);
        String token = this.crowdClient.authenticateSSOUser(userAuthenticationContext);
        this.crowdClient.validateSSOAuthentication(token, Arrays.asList(NO_VALIDATION_FACTORS));
        Session session = this.crowdClient.validateSSOAuthenticationAndGetSession(token, Arrays.asList(NO_VALIDATION_FACTORS));
        RestCrowdClientTest.assertNotNull((String)"Session should have a token key", (Object)session.getToken());
        RestCrowdClientTest.assertNotNull((String)"Session should have a creation date", (Object)session.getCreatedDate());
        RestCrowdClientTest.assertNotNull((String)"Session should have a expiry date", (Object)session.getExpiryDate());
        Assert.assertThat((String)"Session should have some duration", (Object)session.getCreatedDate(), (Matcher)OrderingComparison.lessThan((Comparable)session.getExpiryDate()));
        this.crowdClient.invalidateSSOToken(token);
        try {
            this.crowdClient.validateSSOAuthentication(token, Arrays.asList(NO_VALIDATION_FACTORS));
            RestCrowdClientTest.fail((String)"Token should no longer be valid");
        }
        catch (InvalidTokenException e) {
            // empty catch block
        }
    }

    public void testSSOUserWithZeroLivedToken() throws Exception {
        this.intendToModifyData();
        this._invalidateExistingSessions("admin");
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext("admin", new PasswordCredential("admin"), NO_VALIDATION_FACTORS, APPLICATION_NAME);
        String token = this.crowdClient.authenticateSSOUser(userAuthenticationContext, 0L);
        try {
            this.crowdClient.validateSSOAuthentication(token, Arrays.asList(NO_VALIDATION_FACTORS));
            RestCrowdClientTest.fail((String)"Token should have expired already");
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
    }

    public void testInvalidateAllSSOTokensForUser() throws Exception {
        this.intendToModifyData();
        this._invalidateExistingSessions("admin");
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext("admin", new PasswordCredential("admin"), NO_VALIDATION_FACTORS, APPLICATION_NAME);
        String token = this.crowdClient.authenticateSSOUser(userAuthenticationContext);
        this.crowdClient.validateSSOAuthentication(token, Arrays.asList(NO_VALIDATION_FACTORS));
        this.crowdClient.invalidateSSOTokensForUser("admin");
        try {
            this.crowdClient.validateSSOAuthentication(token, Arrays.asList(NO_VALIDATION_FACTORS));
            RestCrowdClientTest.fail((String)"Token should no longer be valid");
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
    }

    public void testInvalidateAllOtherSSOTokensForUser() throws Exception {
        this.intendToModifyData();
        this._invalidateExistingSessions("admin");
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext("admin", new PasswordCredential("admin"), NO_VALIDATION_FACTORS, APPLICATION_NAME);
        String token = this.crowdClient.authenticateSSOUser(userAuthenticationContext);
        this.crowdClient.validateSSOAuthentication(token, Arrays.asList(NO_VALIDATION_FACTORS));
        this.crowdClient.invalidateSSOTokensForUser("admin", token);
        this.crowdClient.validateSSOAuthentication(token, Arrays.asList(NO_VALIDATION_FACTORS));
    }

    public void testFindUserFromValidSSOToken() throws Exception {
        this.intendToModifyData();
        this._invalidateExistingSessions("admin");
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext("admin", new PasswordCredential("admin"), NO_VALIDATION_FACTORS, APPLICATION_NAME);
        String token = this.crowdClient.authenticateSSOUser(userAuthenticationContext);
        User user = this.crowdClient.findUserFromSSOToken(token);
        RestCrowdClientTest.assertEquals((String)"admin", (String)user.getName());
        RestCrowdClientTest.assertEquals((String)"bob the builder", (String)user.getDisplayName());
        RestCrowdClientTest.assertEquals((String)"bob", (String)user.getFirstName());
        RestCrowdClientTest.assertEquals((String)"the builder", (String)user.getLastName());
        RestCrowdClientTest.assertEquals((String)"bob@example.net", (String)user.getEmailAddress());
        RestCrowdClientTest.assertTrue((String)"User should be active", (boolean)user.isActive());
    }

    public void testFindUserFromInvalidSSOToken() throws Exception {
        this.intendToModifyData();
        this._invalidateExistingSessions("admin");
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext("admin", new PasswordCredential("admin"), NO_VALIDATION_FACTORS, APPLICATION_NAME);
        String token = this.crowdClient.authenticateSSOUser(userAuthenticationContext);
        this.crowdClient.invalidateSSOToken(token);
        try {
            this.crowdClient.findUserFromSSOToken(token);
            RestCrowdClientTest.fail((String)"Should fail for an invalid token");
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
    }

    public void testFindUserFromNonExistentSSOToken() throws Exception {
        try {
            this.crowdClient.findUserFromSSOToken(NON_EXISTENT_TOKEN);
            RestCrowdClientTest.fail((String)"Should fail for a non existent token");
        }
        catch (InvalidTokenException invalidTokenException) {
            // empty catch block
        }
    }

    public void testGetNonExistingWebhook() throws Exception {
        try {
            this.crowdClient.getWebhook(999L);
            RestCrowdClientTest.fail((String)"Should fail for a non existent Webhook");
        }
        catch (WebhookNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Webhook <999> not found"));
        }
    }

    public void testUnregisterNonExistingWebhook() throws Exception {
        try {
            this.crowdClient.unregisterWebhook(999L);
            RestCrowdClientTest.fail((String)"Should fail for a non existent Webhook");
        }
        catch (WebhookNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Webhook <999> not found"));
        }
    }

    public void testAddUserToGroup() throws Exception {
        RestCrowdClientTest.assertFalse((boolean)this.crowdClient.isUserDirectGroupMember("eeeep", "crowd-users"));
        this.crowdClient.addUserToGroup("eeeep", "crowd-users");
        RestCrowdClientTest.assertTrue((boolean)this.crowdClient.isUserDirectGroupMember("eeeep", "crowd-users"));
    }

    public void testAddUserToGroupWhenMembershipAlreadyExists() throws Exception {
        RestCrowdClientTest.assertTrue((boolean)this.crowdClient.isUserDirectGroupMember("eeeep", "badgers"));
        try {
            this.crowdClient.addUserToGroup("eeeep", "badgers");
            RestCrowdClientTest.fail((String)"Should fail for already existing membership");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    public void testAddGroupToGroup() throws Exception {
        RestCrowdClientTest.assertFalse((boolean)this.crowdClient.isGroupDirectGroupMember("badgers", "crowd-administrators"));
        this.crowdClient.addGroupToGroup("badgers", "crowd-administrators");
        RestCrowdClientTest.assertTrue((boolean)this.crowdClient.isGroupDirectGroupMember("badgers", "crowd-administrators"));
    }

    public void testAddGroupToGroupWhenMembershipAlreadyExists() throws Exception {
        RestCrowdClientTest.assertTrue((boolean)this.crowdClient.isGroupDirectGroupMember("badgers", "crowd-users"));
        try {
            this.crowdClient.addGroupToGroup("badgers", "crowd-users");
            RestCrowdClientTest.fail((String)"Should fail for already existing membership");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    private void _invalidateExistingSessions(String username) throws OperationFailedException, ApplicationPermissionException, InvalidAuthenticationException {
        this.crowdClient.invalidateSSOTokensForUser(username);
    }
}

