/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.RestServerImpl;
import com.atlassian.crowd.acceptance.tests.soap.InformationLeakingTestBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class RestXmlParsingTest
extends InformationLeakingTestBase {
    private final RestServer restServer;

    public RestXmlParsingTest() {
        this(RestServerImpl.INSTANCE);
    }

    public RestXmlParsingTest(RestServer restServer) {
        this.restServer = restServer;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restServer.before();
    }

    @Override
    public void tearDown() throws Exception {
        this.restServer.after();
        super.tearDown();
    }

    @Override
    public String getCrowdApplicationPassword() {
        return "qybhDMZh";
    }

    HttpResponse postToRestEndpoint(String content) throws HttpException, UnsupportedEncodingException, IOException {
        StringEntity re = new StringEntity(content, ContentType.APPLICATION_XML.withCharset("us-ascii"));
        String endpoint = this.getBaseUrl() + "/rest/usermanagement/1/search?entity-type=user";
        CloseableHttpClient client = HttpClients.createDefault();
        URI base = URI.create(HOST_PATH);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(base.getHost(), base.getPort(), AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials("crowd", this.getCrowdApplicationPassword()));
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpPost post = new HttpPost(endpoint);
        post.setHeader("Accept", "application/xml");
        post.setEntity((HttpEntity)re);
        return client.execute((HttpUriRequest)post, (HttpContext)context);
    }

    public void testEntityExpansionDoesNotIncludeFileContents() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("RestXmlParsingTest-rest-include-external-entity.xml");
        RestXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        contents = contents.replace("/etc/passwd", this.createSecretFile().toURI().toString());
        HttpResponse m = this.postToRestEndpoint(contents);
        String resp = EntityUtils.toString((HttpEntity)m.getEntity(), (String)"us-ascii");
        MediaType mt = MediaType.valueOf((String)m.getFirstHeader("content-type").getValue());
        RestXmlParsingTest.assertEquals((String)"The response should be XML", (String)"application/xml", (String)(mt.getType() + '/' + mt.getSubtype()));
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.secret)));
    }

    public void testValidEntitiesAreExpanded() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("RestXmlParsingTest-rest-with-amp-entity.xml");
        RestXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        HttpResponse m = this.postToRestEndpoint(contents);
        String resp = EntityUtils.toString((HttpEntity)m.getEntity(), (String)"us-ascii");
        MediaType mt = MediaType.valueOf((String)m.getFirstHeader("content-type").getValue());
        RestXmlParsingTest.assertEquals((String)"The response should be XML", (String)"application/xml", (String)(mt.getType() + '/' + mt.getSubtype()));
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"No enum const class com.atlassian.crowd.search.query.entity.restriction.MatchMode.&amp;"), (Matcher)CoreMatchers.containsString((String)"No enum constant com.atlassian.crowd.search.query.entity.restriction.MatchMode.&amp;")));
    }

    public void testEntityExpansionDoesNotCauseDenialOfService() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("RestXmlParsingTest-rest-billion-laughs.xml");
        RestXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        HttpResponse m = this.postToRestEndpoint(contents);
        String resp = EntityUtils.toString((HttpEntity)m.getEntity(), (String)"us-ascii");
        Assert.assertThat((String)"The response should indicate a parsing error", (Object)resp, (Matcher)CoreMatchers.containsString((String)"The request sent by the client was syntactically incorrect"));
        Assert.assertThat((String)"The response should not indicate a server memory error", (Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"java.lang.OutOfMemoryError")));
    }
}

