/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.token;

import com.atlassian.crowd.acceptance.tests.persistence.dao.token.TokenDAOMemoryTest;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.TokenTermKeys;
import com.atlassian.crowd.util.persistence.PersistenceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class TokenDAOTester {
    protected static final String TOKEN_KEY = "oFpXcZ2lfvtc0YQBgE1EeA00";
    protected static final long DIRECTORY_ID = 1L;
    protected static final long RANDOM_NUMBER = 123456L;
    protected static final Long TOKEN_ID = 491522L;
    protected static final String TOKEN1_ID_HASH = "blah";
    protected static final String TOKEN2_ID_HASH = "bleh";
    protected static final String TOKEN3_ID_HASH = "bloh";
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    private static void waitAtLeastAMillisecond() throws InterruptedException {
        long until = System.currentTimeMillis() + 1L;
        while (until > System.currentTimeMillis()) {
            Thread.sleep(1L);
        }
    }

    @Test
    public void testAdd() throws Exception {
        Token token = new Token.Builder(1L, "admin", "hash", 123456L, TOKEN_KEY).create();
        Token returnedToken = this.getTokenDAO().add(token);
        Assert.assertNotNull((Object)returnedToken);
    }

    @Test(expected=ObjectAlreadyExistsException.class)
    public void testAddWithDuplicateIdentifierHash() throws Exception {
        Token token = new Token.Builder(1L, "admin", TOKEN1_ID_HASH, 123456L, TOKEN_KEY).create();
        this.getTokenDAO().add(token);
    }

    @Test
    public void testUpdate() throws Exception {
        Token token = this.getTokenDAO().findByRandomHash(TOKEN_KEY);
        long originalTime = token.getLastAccessedTime();
        TokenDAOTester.waitAtLeastAMillisecond();
        Token returnedToken = this.getTokenDAO().update(token);
        Assert.assertNotNull((Object)returnedToken);
        long nextMillisecondFromNow = System.currentTimeMillis() + 1L;
        Assert.assertThat((Object)returnedToken.getLastAccessedTime(), (Matcher)OrderingComparison.lessThan((Comparable)Long.valueOf(nextMillisecondFromNow)));
        Assert.assertThat((Object)returnedToken.getLastAccessedTime(), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(originalTime)));
    }

    @Test
    public void testRemove() throws Exception {
        Token token = null;
        try {
            token = this.getTokenDAO().findByRandomHash(TOKEN_KEY);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        this.getTokenDAO().remove(token);
        this.expectedException.expect(ObjectNotFoundException.class);
        this.getTokenDAO().findByRandomHash(TOKEN_KEY);
    }

    @Test
    public void testRemoveByName() {
        this.getTokenDAO().remove(1L, "admin");
        List list = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.NAME).exactlyMatching((Object)"admin")).returningAtMost(10));
        Assert.assertThat((Object)list, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testSearch() throws PersistenceException {
        List tokens = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(10));
        Assert.assertNotNull((Object)tokens);
        Assert.assertThat((Object)tokens, (Matcher)CoreMatchers.not((Matcher)IsEmptyCollection.empty()));
    }

    private static Collection<String> principalNames(Iterable<? extends Token> tokens) {
        ArrayList<String> names = new ArrayList<String>();
        for (Token token : tokens) {
            names.add(token.getName());
        }
        return names;
    }

    @Test
    public void testSearchForPrincipalTokensByDirectoryId() throws Exception {
        List list = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)1L)).returningAtMost(10));
        Assert.assertThat((Object)list, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Token[]{this.getToken1(), this.getToken2()}));
        Assert.assertThat(TokenDAOTester.principalNames(list), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"admin", "user"}));
    }

    @Test
    public void testSearchForApplicationTokens() throws Exception {
        List list = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)-1L)).returningAtMost(10));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.getToken3()), (Object)list);
        Assert.assertEquals((Object)"crowd", (Object)((Token)Iterables.getOnlyElement((Iterable)list)).getName());
    }

    @Test
    public void testSearchForPrincipalTokenByName() throws Exception {
        EntityQuery query = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)TokenTermKeys.NAME).exactlyMatching((Object)"admin"), Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).greaterThan((Object)-1L)})).returningAtMost(10);
        List list = this.getTokenDAO().search(query);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.getToken1()), (Object)list);
        Assert.assertEquals((Object)"admin", (Object)((Token)Iterables.getOnlyElement((Iterable)list)).getName());
    }

    @Test
    public void testSearchByLastAccessedTime() throws Exception {
        EntityQuery query = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.LAST_ACCESSED_TIME).lessThan((Object)TimeUnit.MINUTES.toMillis(15L))).returningAtMost(10);
        List list = this.getTokenDAO().search(query);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.getToken1()), (Object)list);
    }

    @Test
    public void testSearchWithIndexConstraints() {
        List tokenList = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1));
        Assert.assertThat((Object)tokenList, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void testSearchWithIndexConstraintsSkippingTheFirstResult() {
        List tokenList = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).startingAt(1).returningAtMost(20));
        Assert.assertThat((Object)tokenList, (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void testSearchForTokenBySecretNumber() {
        List tokenList = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.RANDOM_NUMBER).exactlyMatching((Object)1234567890L)).returningAtMost(10));
        Assert.assertThat((Object)tokenList, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertEquals((long)1234567890L, (long)((Token)Iterables.getOnlyElement((Iterable)tokenList)).getRandomNumber());
    }

    @Test
    public void testSearchForSecretNumberWhereSecretNumberIsEmpty() throws Exception {
        List tokenList = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.RANDOM_NUMBER).exactlyMatching((Object)0L)).returningAtMost(10));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.getToken2()), (Object)tokenList);
    }

    @Test
    public void testRemoveAllByDirectory() {
        this.getTokenDAO().removeAll(1L);
        List tokenList = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)1L)).returningAtMost(10));
        Assert.assertThat((Object)tokenList, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testRemoveAllExpiredTokens() throws Exception {
        Date currentDate = new Date(TimeUnit.MINUTES.toMillis(180L));
        long maxLifeInSeconds = TimeUnit.HOURS.toSeconds(1L);
        this.getTokenDAO().removeExpiredTokens(currentDate, maxLifeInSeconds);
        EntityQuery allTokensQuery = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(-1);
        List tokenList = this.getTokenDAO().search(allTokensQuery);
        Assert.assertThat((Object)tokenList, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testRemoveExpiredTokensWithSpecificDurationLessThanSessionMaxLife() throws Exception {
        Date currentDate = new Date(TimeUnit.MINUTES.toMillis(70L));
        long maxLifeInSeconds = TimeUnit.HOURS.toSeconds(1L);
        this.getTokenDAO().removeExpiredTokens(currentDate, maxLifeInSeconds);
        EntityQuery allTokensQuery = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(-1);
        List tokenList = this.getTokenDAO().search(allTokensQuery);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.getToken2()), (Object)tokenList);
        Assert.assertNotNull((String)"Token has survived", (Object)this.getTokenDAO().findByIdentifierHash(TOKEN2_ID_HASH));
    }

    @Test
    public void testRemoveExpiredTokensWithSpecificDurationGreaterThanSessionMaxLife() throws Exception {
        Date currentDate = new Date(TimeUnit.MINUTES.toMillis(32L));
        long maxLifeInSeconds = 1L;
        this.getTokenDAO().removeExpiredTokens(currentDate, maxLifeInSeconds);
        EntityQuery allTokensQuery = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(-1);
        List tokenList = this.getTokenDAO().search(allTokensQuery);
        Assert.assertThat((Object)tokenList, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testFindByKey() throws Exception {
        Token token = this.getTokenDAO().findByRandomHash(TOKEN_KEY);
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)TOKEN_KEY, (Object)token.getRandomHash());
    }

    @Test
    public void testFindByIdentifierHash() throws Exception {
        Token newToken = new Token.Builder(1L, "admin", TOKEN1_ID_HASH, 123457L, "xxx-not-a-random-hash-xxx").create();
        Token token = this.getTokenDAO().findByIdentifierHash(newToken.getIdentifierHash());
        Assert.assertEquals((Object)newToken.getIdentifierHash(), (Object)token.getIdentifierHash());
    }

    @Test
    public void testRemoveAll() {
        this.getTokenDAO().removeAll();
        List tokenList = this.getTokenDAO().search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)1L)).returningAtMost(10));
        Assert.assertThat((Object)tokenList, (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testLoadAll() throws Exception {
        Assert.assertThat(TokenDAOTester.principalNames(this.getTokenDAO().loadAll()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"admin", "user", "crowd"}));
    }

    @Test
    public void testSaveAllWithNoTokens() throws Exception {
        this.getTokenDAO().removeAll();
        Assert.assertThat((Object)this.getTokenDAO().loadAll(), (Matcher)IsEmptyCollection.empty());
        this.getTokenDAO().saveAll(Collections.emptyList());
        Assert.assertThat((Object)this.getTokenDAO().loadAll(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testSaveAllWithTestTokens() throws Exception {
        this.getTokenDAO().removeAll();
        Assert.assertThat((Object)this.getTokenDAO().loadAll(), (Matcher)IsEmptyCollection.empty());
        this.getTokenDAO().saveAll((Collection)ImmutableList.copyOf(TokenDAOMemoryTest.getTestTokens()));
        Assert.assertThat(TokenDAOTester.principalNames(this.getTokenDAO().loadAll()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"admin", "user", "crowd"}));
    }

    protected abstract TokenDAO getTokenDAO();

    private Token getToken1() throws ObjectNotFoundException {
        Token token1 = this.getTokenDAO().findByIdentifierHash(TOKEN1_ID_HASH);
        Assert.assertEquals((long)1L, (long)token1.getLastAccessedTime());
        Assert.assertTrue((boolean)token1.getLifetime().isDefault());
        return token1;
    }

    private Token getToken2() throws ObjectNotFoundException {
        Token token2 = this.getTokenDAO().findByIdentifierHash(TOKEN2_ID_HASH);
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(30L), (long)token2.getLastAccessedTime());
        Assert.assertTrue((boolean)token2.getLifetime().isDefault());
        return token2;
    }

    private Token getToken3() throws ObjectNotFoundException {
        Token token3 = this.getTokenDAO().findByIdentifierHash(TOKEN3_ID_HASH);
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(30L), (long)token3.getLastAccessedTime());
        Assert.assertEquals((long)TimeUnit.MINUTES.toSeconds(15L), (long)token3.getLifetime().getSeconds());
        return token3;
    }
}

