/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.token;

import com.atlassian.crowd.acceptance.tests.persistence.dao.token.TokenDAOTester;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.dao.token.TokenDAOMemory;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerEhcache;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-CrowdEncryption.xml"})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class})
public class TokenDAOMemoryTest
extends TokenDAOTester {
    private TokenDAOMemory tokenDAO;
    @Inject
    private net.sf.ehcache.CacheManager cacheManager;

    public static Iterable<Token> getTestTokens() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        Token token1 = new Token.Builder(1L, "admin", "blah", 1234567890L, "oFpXcZ2lfvtc0YQBgE1EeA00").setCreatedDate(sdf.parse("25-01-2009 11:00:30")).setLastAccessedTime(1L).create();
        Token token2 = new Token.Builder(1L, "user", "bleh", 0L, "oFpScZ2lfvtc0YQBgE1EeA00").setCreatedDate(sdf.parse("25-01-2009 11:22:30")).setLastAccessedTime(TimeUnit.MINUTES.toMillis(30L)).create();
        long directoryId = -1L;
        TokenLifetime validFor15Minutes = TokenLifetime.inSeconds((long)TimeUnit.MINUTES.toSeconds(15L));
        Token token3 = new Token.Builder(directoryId, "crowd", "bloh", 123456789012345L, "dHFiDosttLVTLlTKc08BEw00").setCreatedDate(sdf.parse("25-01-2009 11:50:30")).setLastAccessedTime(TimeUnit.MINUTES.toMillis(30L)).setLifetime(validFor15Minutes).create();
        return ImmutableList.of((Object)token1, (Object)token2, (Object)token3);
    }

    @Before
    public void createObjectUnderTest() throws Exception {
        CacheManagerEhcache cacheManagerEhcache = new CacheManagerEhcache(this.cacheManager);
        for (Token t : TokenDAOMemoryTest.getTestTokens()) {
            cacheManagerEhcache.put(TokenDAOMemory.RANDOM_HASH_CACHE, (Serializable)((Object)t.getRandomHash()), (Serializable)t);
            cacheManagerEhcache.put(TokenDAOMemory.IDENTIFIER_HASH_CACHE, (Serializable)((Object)t.getIdentifierHash()), (Serializable)t);
        }
        this.tokenDAO = new TokenDAOMemory((CacheManager)cacheManagerEhcache);
    }

    @After
    public void clearCache() throws Exception {
        this.cacheManager.clearAll();
    }

    @Override
    protected TokenDAO getTokenDAO() {
        return this.tokenDAO;
    }
}

