/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence;

import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class PersistenceTestHelper {
    public static final String TEST_DATA_XML = "sample-data.xml";
    private final String dataTypeFactoryClassName;

    public PersistenceTestHelper(String dataTypeFactoryClassName) {
        Preconditions.checkNotNull((Object)dataTypeFactoryClassName, (Object)"Name of IDataTypeFactory-implementing class must be provided");
        this.dataTypeFactoryClassName = dataTypeFactoryClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateDatabase(String dataFileName, JdbcTemplate jdbcTemplate) throws DatabaseUnitException, IOException, SQLException {
        DataSource ds = jdbcTemplate.getDataSource();
        Connection con = DataSourceUtils.getConnection((DataSource)ds);
        DatabaseConnection dbUnitCon = new DatabaseConnection(con);
        DatabaseConfig config = dbUnitCon.getConfig();
        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)this.createDataTypeFactory());
        InputStream datasetStream = PersistenceTestHelper.class.getResourceAsStream("/" + dataFileName);
        FlatXmlDataSet dataSet = new FlatXmlDataSetBuilder().build(datasetStream);
        try {
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)dbUnitCon, (IDataSet)dataSet);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
    }

    private IDataTypeFactory createDataTypeFactory() {
        try {
            return (IDataTypeFactory)Class.forName(this.dataTypeFactoryClassName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate IDataTypeFactory from " + this.dataTypeFactoryClassName, e);
        }
    }

    public void fixHiLo(ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper) {
        ArrayList errors = new ArrayList();
        resetableHiLoGeneratorHelper.setNextHiValue(errors);
        Assert.assertThat(errors, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
    }
}

