/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.BeforeGroupRemoval;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryManagerGeneric;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.event.api.EventPublisher;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockito.Mockito;

public class MockDirectoryManager
implements DirectoryManager {
    private final DirectoryManager delegated;
    private Directory directory;

    public MockDirectoryManager(PermissionManager permissionManager, EventPublisher eventPublisher, DirectoryInstanceLoader directoryInstanceLoader, DirectorySynchroniser directorySynchroniser, DirectoryPollerManager directoryPollerManager, ClusterLockService lockService, BeforeGroupRemoval beforeGroupRemoval) {
        this.delegated = new DirectoryManagerGeneric((DirectoryDao)Mockito.mock(DirectoryDao.class), (ApplicationDAO)Mockito.mock(ApplicationDAO.class), eventPublisher, permissionManager, directoryInstanceLoader, directorySynchroniser, directoryPollerManager, lockService, new MockSynchronisationStatusManager(), beforeGroupRemoval){

            public Directory findDirectoryById(long directoryID) throws DirectoryNotFoundException {
                return MockDirectoryManager.this.directory;
            }

            public List<Directory> findAllDirectories() {
                return Arrays.asList(MockDirectoryManager.this.directory);
            }

            public List<Directory> searchDirectories(EntityQuery query) {
                return Arrays.asList(MockDirectoryManager.this.directory);
            }

            public Directory findDirectoryByName(String name) throws DirectoryNotFoundException {
                return MockDirectoryManager.this.directory;
            }

            public Directory addDirectory(Directory directory) throws DirectoryInstantiationException {
                throw new UnsupportedOperationException();
            }

            public Directory updateDirectory(Directory directory) throws DirectoryNotFoundException {
                throw new UnsupportedOperationException();
            }

            public void removeDirectory(Directory directory) throws DirectoryNotFoundException, DirectoryCurrentlySynchronisingException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public Directory addDirectory(Directory directory) throws DirectoryInstantiationException {
        return this.delegated.addDirectory(directory);
    }

    public Directory findDirectoryById(long directoryID) throws DirectoryNotFoundException {
        return this.delegated.findDirectoryById(directoryID);
    }

    public List<Directory> findAllDirectories() {
        return this.delegated.findAllDirectories();
    }

    public List<Directory> searchDirectories(EntityQuery<Directory> query) {
        return this.delegated.searchDirectories(query);
    }

    public Directory findDirectoryByName(String name) throws DirectoryNotFoundException {
        return this.delegated.findDirectoryByName(name);
    }

    public Directory updateDirectory(Directory directory) throws DirectoryNotFoundException {
        return this.delegated.updateDirectory(directory);
    }

    public void removeDirectory(Directory directory) throws DirectoryNotFoundException, DirectoryCurrentlySynchronisingException {
        this.delegated.removeDirectory(directory);
    }

    public User authenticateUser(long directoryId, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, DirectoryNotFoundException, UserNotFoundException {
        return this.delegated.authenticateUser(directoryId, username, passwordCredential);
    }

    public User findUserByName(long directoryId, String username) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.delegated.findUserByName(directoryId, username);
    }

    public UserWithAttributes findUserWithAttributesByName(long directoryId, String username) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.delegated.findUserWithAttributesByName(directoryId, username);
    }

    public <T> List<T> searchUsers(long directoryId, EntityQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.searchUsers(directoryId, query);
    }

    public User addUser(long directoryId, UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, UserAlreadyExistsException {
        return this.delegated.addUser(directoryId, user, credential);
    }

    public User updateUser(long directoryId, UserTemplate user) throws DirectoryNotFoundException, UserNotFoundException, DirectoryPermissionException, InvalidUserException, OperationFailedException {
        return this.delegated.updateUser(directoryId, user);
    }

    public User renameUser(long directoryId, String oldUsername, String newUsername) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException, InvalidUserException, UserAlreadyExistsException {
        return this.delegated.renameUser(directoryId, oldUsername, newUsername);
    }

    public void storeUserAttributes(long directoryId, String username, Map<String, Set<String>> attributes) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        this.delegated.storeUserAttributes(directoryId, username, attributes);
    }

    public void removeUserAttributes(long directoryId, String username, String attributeName) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        this.delegated.removeUserAttributes(directoryId, username, attributeName);
    }

    public void updateUserCredential(long directoryId, String username, PasswordCredential credential) throws DirectoryPermissionException, InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        this.delegated.updateUserCredential(directoryId, username, credential);
    }

    public void removeUser(long directoryId, String username) throws DirectoryNotFoundException, UserNotFoundException, DirectoryPermissionException, OperationFailedException {
        this.delegated.removeUser(directoryId, username);
    }

    public Group findGroupByName(long directoryId, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.delegated.findGroupByName(directoryId, groupName);
    }

    public GroupWithAttributes findGroupWithAttributesByName(long directoryId, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.delegated.findGroupWithAttributesByName(directoryId, groupName);
    }

    public <T> List<T> searchGroups(long directoryId, EntityQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.searchGroups(directoryId, query);
    }

    public Group addGroup(long directoryId, GroupTemplate group) throws InvalidGroupException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException {
        return this.delegated.addGroup(directoryId, group);
    }

    public Group updateGroup(long directoryId, GroupTemplate group) throws GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, InvalidGroupException, OperationFailedException, ReadOnlyGroupException {
        return this.delegated.updateGroup(directoryId, group);
    }

    public Group renameGroup(long directoryId, String oldGroupname, String newGroupname) throws GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, InvalidGroupException, OperationFailedException {
        return this.delegated.renameGroup(directoryId, oldGroupname, newGroupname);
    }

    public void storeGroupAttributes(long directoryId, String groupName, Map<String, Set<String>> attributes) throws DirectoryPermissionException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        this.delegated.storeGroupAttributes(directoryId, groupName, attributes);
    }

    public void removeGroupAttributes(long directoryId, String groupName, String attributeName) throws DirectoryPermissionException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        this.delegated.removeGroupAttributes(directoryId, groupName, attributeName);
    }

    public void removeGroup(long directoryId, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, ReadOnlyGroupException {
        this.delegated.removeGroup(directoryId, groupName);
    }

    public boolean isUserDirectGroupMember(long directoryId, String username, String groupName) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.isUserDirectGroupMember(directoryId, username, groupName);
    }

    public boolean isGroupDirectGroupMember(long directoryId, String childGroup, String parentGroup) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.isGroupDirectGroupMember(directoryId, childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        this.delegated.addUserToGroup(directoryId, username, groupName);
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException, InvalidMembershipException, NestedGroupsNotSupportedException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        this.delegated.addGroupToGroup(directoryId, childGroup, parentGroup);
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.delegated.removeUserFromGroup(directoryId, username, groupName);
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, GroupNotFoundException, DirectoryNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.delegated.removeGroupFromGroup(directoryId, childGroup, parentGroup);
    }

    public <T> List<T> searchDirectGroupRelationships(long directoryId, MembershipQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.searchDirectGroupRelationships(directoryId, query);
    }

    public boolean isUserNestedGroupMember(long directoryId, String username, String groupName) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.isUserNestedGroupMember(directoryId, username, groupName);
    }

    public boolean isGroupNestedGroupMember(long directoryId, String childGroup, String parentGroup) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.isGroupNestedGroupMember(directoryId, childGroup, parentGroup);
    }

    public BoundedCount countDirectMembersOfGroup(long directoryId, String groupName, int querySizeHint) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.countDirectMembersOfGroup(directoryId, groupName, querySizeHint);
    }

    public <T> List<T> searchNestedGroupRelationships(long directoryId, MembershipQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        return this.delegated.searchNestedGroupRelationships(directoryId, query);
    }

    public BulkAddResult<User> addAllUsers(long directoryId, Collection<UserTemplateWithCredentialAndAttributes> users, boolean overwrite) throws DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException {
        return this.delegated.addAllUsers(directoryId, users, overwrite);
    }

    public BulkAddResult<Group> addAllGroups(long directoryId, Collection<GroupTemplate> groups, boolean overwrite) throws DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, InvalidGroupException {
        return this.delegated.addAllGroups(directoryId, groups, overwrite);
    }

    public BulkAddResult<String> addAllUsersToGroup(long directoryID, Collection<String> userNames, String groupName) throws DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException, OperationFailedException {
        return this.delegated.addAllUsersToGroup(directoryID, userNames, groupName);
    }

    public boolean supportsNestedGroups(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.delegated.supportsNestedGroups(directoryId);
    }

    public boolean supportsExpireAllPasswords(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.delegated.supportsExpireAllPasswords(directoryId);
    }

    public boolean isSynchronisable(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.delegated.isSynchronisable(directoryId);
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode) throws OperationFailedException, DirectoryNotFoundException {
        this.delegated.synchroniseCache(directoryId, mode);
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode, boolean runInBackground) throws OperationFailedException, DirectoryNotFoundException {
        this.delegated.synchroniseCache(directoryId, mode, runInBackground);
    }

    public boolean isSynchronising(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.delegated.isSynchronising(directoryId);
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.delegated.getDirectorySynchronisationInformation(directoryId);
    }

    public void expireAllPasswords(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        throw new UnsupportedOperationException("Unable to invalidate all passwords");
    }

    public User findUserByExternalId(long directoryId, String externalId) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.delegated.findUserByExternalId(directoryId, externalId);
    }

    public UserWithAttributes findUserWithAttributesByExternalId(long directoryId, String externalId) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.delegated.findUserWithAttributesByExternalId(directoryId, externalId);
    }
}

