/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid.server.spray;

import com.atlassian.crowd.acceptance.tests.applications.crowdid.server.CrowdIDServerAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class SprayOpenIDServerIntegrationTest
extends CrowdIDServerAcceptanceTestCase {
    private static final String CLIENT_NAME = "crowdidclient";
    private static final String WHITELISTED_REALM = "?openidRealm=http://localhost:8097/openidclient/login.openid";
    private static final String OPENID_SERVER_LOGIN_PAGE_TITLE = "Atlassian CrowdID - Login";
    private String openidClientLoginUrl;
    private String openidServerLoginUrlForIdentifierSelect;
    private String openidServerLoginUrlForAdminExternalIdIdentifier;
    private String openidServerLoginUrlForUserTagExternalIdIdentifier;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loginToCrowd();
        this.restoreCrowdFromXML("openidauthtest.xml");
        this.logoutFromCrowd();
        this.specProperties = AcceptanceTestHelper.loadProperties("localtest.properties");
        String client_port = this.getTestProperty("crowdidclient.port");
        String client_context = this.getTestProperty("crowdidclient.context");
        String client_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + client_port;
        String server_port = this.getTestProperty(this.getApplicationName() + ".port");
        String server_context = this.getTestProperty(this.getApplicationName() + ".context");
        String server_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + server_port;
        this.openidClientLoginUrl = client_rootUrl + client_context + WHITELISTED_REALM;
        String openidServerBaseUrl = server_rootUrl + server_context;
        this.openidServerLoginUrlForIdentifierSelect = openidServerBaseUrl + "/v2/op";
        this.openidServerLoginUrlForAdminExternalIdIdentifier = openidServerBaseUrl + "/v2/u/23:admin-external-id";
        this.openidServerLoginUrlForUserTagExternalIdIdentifier = openidServerBaseUrl + "/v2/u/23:user-tag-external-id";
    }

    public void testShouldBeAbleToAuthenticateUserWhenUserIsNotLoggedInUsingIdentifierSelect() {
        this.tryShouldBeAbleToAuthenticateUserWhenUserIsNotLoggedIn(this.openidServerLoginUrlForIdentifierSelect);
    }

    public void testShouldBeAbleToAuthenticateUserWhenUserIsNotLoggedInUsingExternalIdIdentifier() {
        this.tryShouldBeAbleToAuthenticateUserWhenUserIsNotLoggedIn(this.openidServerLoginUrlForAdminExternalIdIdentifier);
    }

    private void tryShouldBeAbleToAuthenticateUserWhenUserIsNotLoggedIn(String openidIdentifier) {
        this.gotoPage(this.openidClientLoginUrl);
        this.setTextField("openid_identifier", openidIdentifier);
        this.submit();
        this.assertOnOpenIDServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertOpenIdClientAuthenticationSucceededAndAdminUserAttributesWereReturned();
    }

    public void testShouldNotBeAbleToAuthenticateUserWhenUserIsNotLoggedInAndTriesToLogInWithOtherUsersCredentials() {
        this.gotoPage(this.openidClientLoginUrl);
        this.setTextField("openid_identifier", this.openidServerLoginUrlForUserTagExternalIdIdentifier);
        this.submit();
        this.assertOnOpenIDServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertOpenIdClientAuthenticationFailed();
    }

    public void testShouldBeAbleToAuthenticateUserWhenUserIsLoggedInUsingIdentifierSelect() {
        this.tryShouldBeAbleToAuthenticateUserWhenUserIsLoggedIn(this.openidServerLoginUrlForIdentifierSelect);
    }

    public void testShouldBeAbleToAuthenticateUserWhenUserIsLoggedInUsingExternalIdIdentifier() {
        this.tryShouldBeAbleToAuthenticateUserWhenUserIsLoggedIn(this.openidServerLoginUrlForAdminExternalIdIdentifier);
    }

    private void tryShouldBeAbleToAuthenticateUserWhenUserIsLoggedIn(String openidIdentifier) {
        this.loginToCrowd();
        this.gotoPage(this.openidClientLoginUrl);
        this.setTextField("openid_identifier", openidIdentifier);
        this.submit();
        this.assertNotOnOpenIDServerLoginPage();
        this.assertOpenIdClientAuthenticationSucceededAndAdminUserAttributesWereReturned();
    }

    public void testShouldBeAbleToAuthenticateUserInImmediateModeWhenUserIsLoggedInUsingIdentifierSelect() {
        this.tryShouldBeAbleToAuthenticateUserInImmediateModeWhenUserIsLoggedIn(this.openidServerLoginUrlForIdentifierSelect);
    }

    public void testShouldBeAbleToAuthenticateUserInImmediateModeWhenUserIsLoggedInUsingExternalIdIdentifier() {
        this.tryShouldBeAbleToAuthenticateUserInImmediateModeWhenUserIsLoggedIn(this.openidServerLoginUrlForAdminExternalIdIdentifier);
    }

    private void tryShouldBeAbleToAuthenticateUserInImmediateModeWhenUserIsLoggedIn(String openidIdentifier) {
        this.loginToCrowd();
        this.gotoPage(this.openidClientLoginUrl);
        this.setTextField("openid_identifier", openidIdentifier);
        this.checkCheckbox("checkImmediate");
        this.submit();
        this.assertOpenIdClientAuthenticationSucceededAndAdminUserAttributesWereReturned();
    }

    public void testShouldNotBeAbleToAuthenticateUserInImmediateModeWhenUserIsNotLoggedIn() {
        this.gotoPage(this.openidClientLoginUrl);
        this.setTextField("openid_identifier", this.openidServerLoginUrlForIdentifierSelect);
        this.checkCheckbox("checkImmediate");
        this.submit();
        this.assertOpenIdClientAuthenticationFailed();
    }

    private void assertOnOpenIDServerLoginPage() {
        this.assertTitleEquals(OPENID_SERVER_LOGIN_PAGE_TITLE);
    }

    private void assertNotOnOpenIDServerLoginPage() {
        this.assertTitleNotEquals(OPENID_SERVER_LOGIN_PAGE_TITLE);
    }

    private void assertOpenIdClientAuthenticationSucceededAndAdminUserAttributesWereReturned() {
        String pageText = this.getPageText();
        Assert.assertThat((String)"Should be on the openid client page after authenticating", (Object)pageText, (Matcher)Matchers.containsString((String)"The attribute values displayed on this page are those which were sent back from your OpenID provider via the SREG protocol."));
        Assert.assertThat((String)"Admin's email from Crowd should be on page", (Object)pageText, (Matcher)Matchers.containsString((String)"email \t admin@example.com"));
        Assert.assertThat((String)"Admin's name from Crowd should be on page", (Object)pageText, (Matcher)Matchers.containsString((String)"fullname \t Super User"));
    }

    private void assertOpenIdClientAuthenticationFailed() {
        Assert.assertThat((Object)this.getPageText(), (Matcher)Matchers.containsString((String)"Authentication Failed: Your OpenID provider was unable to authenticate the OpenID URL. Log in to your OpenID provider and try again."));
    }
}

