/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid.client;

import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.atlassian.crowd.acceptance.tests.applications.crowdid.client.CrowdIDClientAcceptanceTestCase;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CrowdIDClientTest
extends CrowdIDClientAcceptanceTestCase {
    String opUrl;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        BaseUrlFromProperties props = BaseUrlFromProperties.withLocalTestProperties();
        this.opUrl = props.baseUrlFor("crowdid") + "/op";
    }

    public void testRedirectionUsesHttpRedirect() throws IOException {
        String requestParams = "openid_identifier=" + this.opUrl;
        URL url = new URL(this.baseUrl + "/login!login.action?" + requestParams);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(false);
        CrowdIDClientTest.assertEquals((int)302, (int)conn.getResponseCode());
        Assert.assertThat((Object)conn.getHeaderField("Location"), (Matcher)Matchers.startsWith((String)(this.opUrl + "?")));
    }

    public void testRedirectionForLongerUrlUsesFormRedirection() throws IOException {
        String padding = StringUtils.repeat((char)'x', (int)2048);
        String requestParams = "openid_identifier=" + this.opUrl + "&requiredAttribs=" + padding;
        URL url = new URL(this.baseUrl + "/login!login.action?" + requestParams);
        WebClient webClient = new WebClient();
        webClient.getOptions().setRedirectEnabled(false);
        webClient.getOptions().setJavaScriptEnabled(false);
        HtmlPage htmlPage = (HtmlPage)webClient.getPage(url);
        CrowdIDClientTest.assertEquals((int)200, (int)htmlPage.getWebResponse().getStatusCode());
        CrowdIDClientTest.assertEquals((String)this.opUrl, (String)htmlPage.getFormByName("openid-form-redirection").getAttribute("action"));
        CrowdIDClientTest.assertEquals((String)padding, (String)htmlPage.getFormByName("openid-form-redirection").getInputByName("openid.sreg.required").getValueAttribute());
    }

    public void testProvidingAnInvalidIdentifierCausesAClearError() throws IOException {
        String invalidOpUrl = "http://no-such-host.invalid/";
        String requestParams = "openid_identifier=" + invalidOpUrl;
        URL url = new URL(this.baseUrl + "/login!login.action?" + requestParams);
        WebClient webClient = new WebClient();
        webClient.getOptions().setRedirectEnabled(false);
        webClient.getOptions().setJavaScriptEnabled(false);
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        HtmlPage htmlPage = (HtmlPage)webClient.getPage(new WebRequest(url, HttpMethod.POST));
        Assert.assertThat((Object)htmlPage.getWebResponse().getContentAsString(), (Matcher)Matchers.containsString((String)"Could not make an authentication request to your OpenID provider."));
        CrowdIDClientTest.assertEquals((int)200, (int)htmlPage.getWebResponse().getStatusCode());
    }
}

