/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import java.io.InputStream;

public class ViewGroupLDAPTest
extends CrowdAcceptanceTestCase {
    private static final String DIRECTORY_NAME = "ApacheDS154";
    private static final long MAX_WAIT_FOR_SYNC_MS = 10000L;
    private static final String USER_NAME = "myUser";
    private static final String GROUP_NAME = "myGroup";
    private static final String SUB_GROUP_NAME = "mySubGroup";
    private static final String SUB_USER_NAME = "mySubUser";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
    }

    @Override
    public void tearDown() throws Exception {
        ViewGroupLDAPTest.loadData("/com/atlassian/crowd/acceptance/tests/default-entries.ldif");
        super.tearDown();
    }

    private static void loadData(String name) throws Exception {
        InputStream in = ViewGroupLDAPTest.class.getResourceAsStream(name);
        ViewGroupLDAPTest.assertNotNull((Object)in);
        new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).setLdif(in);
    }

    public void testViewNestedGroupMembers() throws Exception {
        ViewGroupLDAPTest.loadData("ViewGroupLDAPTest-entries.ldif");
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupMembers");
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-users", USER_NAME);
        this.assertTextNotInTable("view-group-users", SUB_USER_NAME);
        this.assertTextInTable("view-group-groups", SUB_GROUP_NAME);
        this.assertKeyPresent("group.nestedmembers.label");
    }

    private void synchroniseDirectory() {
        DbCachingTestHelper.synchroniseDirectory(this.tester, DIRECTORY_NAME, 10000L);
    }

    public void testViewNestedGroupAllUsers() throws Exception {
        ViewGroupLDAPTest.loadData("ViewGroupLDAPTest-entries.ldif");
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupAllUsers");
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-nested-principals");
        this.assertTextInTable("view-group-nested-principals", USER_NAME);
        this.assertTextInTable("view-group-nested-principals", SUB_USER_NAME);
        this.assertTableNotPresent("view-group-groups");
        this.assertTextNotInTable("view-group-nested-principals", SUB_GROUP_NAME);
    }

    public void testViewNestedGroupMembersOnlyGroupsAssigned() throws Exception {
        ViewGroupLDAPTest.loadData("ViewGroupLDAPTest-empty-myGroup-entries.ldif");
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupMembersOnlyGroupsAssigned");
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-groups", SUB_GROUP_NAME);
        this.assertKeyPresent("group.nestedmembers.label");
    }

    public void testViewNestedGroupAllMembersOnlyGroupsAssigned() throws Exception {
        ViewGroupLDAPTest.loadData("ViewGroupLDAPTest-empty-myGroup-entries.ldif");
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupAllMembersOnlyGroupsAssigned");
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-nested-principals");
        this.assertTextInTable("view-group-nested-principals", SUB_USER_NAME);
        this.assertTableNotPresent("view-group-groups");
        this.assertTextNotInTable("view-group-nested-principals", SUB_GROUP_NAME);
    }
}

