/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class UpdateConnectionPoolTest
extends CrowdAcceptanceTestCase {
    private static final String TIMEOUT_IN_SECONDS = String.valueOf(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)"30000"), TimeUnit.MILLISECONDS));

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.resetToDefaults();
    }

    public void testNoChange() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.submit();
        this.assertErrorNotPresent();
        this.checkDefaultValues();
    }

    public void testInvalidChange() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("initialSize", "blahblah");
        this.submit();
        this.assertErrorPresentWithKey("connectionpool.integer.invalid");
        this.assertErrorPresentWithKey("connectionpool.update.error");
        this.gotoLdapConnectionPool();
        this.checkDefaultValues();
    }

    public void testInvalidAuthenticationType() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("supportedAuthentication", "simple rhubarb");
        this.submit();
        this.assertErrorPresentWithKey("connectionpool.supportedAuthentication.error");
        this.assertErrorPresentWithKey("connectionpool.update.error");
        this.gotoLdapConnectionPool();
        this.checkDefaultValues();
    }

    public void testInvalidProtocolType() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("supportedProtocol", "ssl plane");
        this.submit();
        this.assertErrorPresentWithKey("connectionpool.supportedProtocol.error");
        this.assertErrorPresentWithKey("connectionpool.update.error");
        this.gotoLdapConnectionPool();
        this.checkDefaultValues();
    }

    public void testValidChange() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("initialSize", "5");
        this.setTextField("maximumSize", "20");
        this.setTextField("timeoutInSec", "420");
        this.setTextField("supportedProtocol", "ssl");
        this.submit();
        this.assertErrorNotPresent();
        this.assertInfoPresent();
        this.assertInputWithValue("initialSize", "5");
        this.assertInputWithValue("preferredSize", "10");
        this.assertInputWithValue("maximumSize", "20");
        this.assertInputWithValue("timeoutInSec", "420");
        this.assertInputWithValue("supportedProtocol", "ssl");
        this.assertInputWithValue("supportedAuthentication", "simple");
        this.resetToDefaults();
    }

    private void checkDefaultValues() {
        this.assertKeyPresent("connectionpool.initialSize.label");
        this.assertKeyPresent("connectionpool.initialSize.description");
        this.assertKeyPresent("connectionpool.preferredSize.label");
        this.assertKeyPresent("connectionpool.preferredSize.description");
        this.assertKeyPresent("connectionpool.maximumSize.label");
        this.assertKeyPresent("connectionpool.maximumSize.description");
        this.assertKeyPresent("connectionpool.timeout.label");
        this.assertKeyPresent("connectionpool.timeout.description");
        this.assertKeyPresent("connectionpool.supportedProtocol.label");
        this.assertKeyPresent("connectionpool.supportedProtocol.description");
        this.assertKeyPresent("connectionpool.supportedAuthentication.label");
        this.assertKeyPresent("connectionpool.supportedAuthentication.description");
        this.assertInputWithValue("initialSize", "1");
        this.assertInputWithValue("preferredSize", "10");
        this.assertInputWithValue("maximumSize", "0");
        this.assertInputWithValue("timeoutInSec", TIMEOUT_IN_SECONDS);
        this.assertInputWithValue("supportedProtocol", "plain ssl");
        this.assertInputWithValue("supportedAuthentication", "simple");
    }

    private void resetToDefaults() {
        this.setTextField("initialSize", "1");
        this.setTextField("preferredSize", "10");
        this.setTextField("maximumSize", "0");
        this.setTextField("timeoutInSec", TIMEOUT_IN_SECONDS);
        this.setTextField("supportedProtocol", "plain ssl");
        this.setTextField("supportedAuthentication", "simple");
        this.submit();
    }

    private void assertInputWithValue(String elementId, String expectedValue) {
        MatcherAssert.assertThat((Object)this.getElementValueByID(elementId), (Matcher)Matchers.is((Object)expectedValue));
    }
}

