/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class UpdateApplicationDirectoryGroupTest
extends CrowdAcceptanceTestCase {
    private static final String CROWD_ADMINISTRATORS = "crowd-administrators";
    private static final String GROUPA = "groupA";
    private static final String GROUPB = "groupB";
    private static final String GROUPC = "groupC";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
        this.restoreCrowdFromXML("updateapplication_directorygroup.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testRemoveGroupsFromDemoAllowAllAuthenticateTrue() {
        this.log("Running: testRemoveGroupsAllowAllAuthenticateTrue");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-groups");
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", GROUPA);
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", GROUPB);
    }

    public void testRemoveGroupsFromDemoAllowAllAuthenticateFalse() {
        this.log("Running: testRemoveGroupsAllowAllAuthenticateFalse");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.setAllowAllToAuthenticateToFalse();
        this.clickLink("application-groups");
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", GROUPA);
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTableBody("groupsTable", GROUPB);
    }

    private void setAllowAllToAuthenticateToFalse() {
        this.clickLink("application-directories");
        this.selectOptionByValue("directory1-allowAll", "false");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
    }
}

