/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.api.IElement;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEmptyString;
import org.junit.Assert;

public class SetupCrowdWithDatabase
extends CrowdAcceptanceTestCase {
    private static final String UNSPECIFIED_DATABASE_TYPE = "${database.type}";
    private static final String DATABASE_TYPE = System.getProperty("database.type", "");
    private static final String DATABASE_USERNAME = System.getProperty("database.username");
    private static final String DATABASE_PASSWORD = System.getProperty("database.password");
    private static final String DATABASE_DIALECT = System.getProperty("database.dialect");
    private static final String DATABASE_DRIVER = System.getProperty("database.driver");
    private static final String DATABASE_URL = System.getProperty("database.url");
    private static final String HSQLDB_USERNAME = "sa";
    private static final String HSQLDB_DRIVER = "org.hsqldb.jdbcDriver";
    private static final String HSQLDB_DIALECT = "org.hibernate.dialect.HSQLDialect";
    private static final String HSQLDB_URL_PREFIX = "jdbc:hsqldb:";
    private static final String HSQLDB_URL_SUFFIX = "/database/defaultdb";

    public void testSetup() throws Exception {
        this._testLicenseScreen();
        this._testLicenseSuccess();
        this._testInstallScreen();
        this._testInstallNew();
        this.setScriptingEnabled(true);
        this._testDatabaseScreen();
        this._testDatabaseSelectJDBC();
        this.setScriptingEnabled(false);
        this._testOptionsScreen();
        this._testOptionsSuccess();
        this._testMailServerScreen();
        this._testMailServerSuccess();
        this._testInternalDirectoryScreen();
        this._testInternalDirectorySuccess();
        this._testDefaultAdminScreen();
        this._testDefaultAdminSuccess();
        this._testConfigureIntegratedApps();
        this._testCompleteSetup();
        this._testDatabaseSystemInfo();
    }

    private void _testLicenseScreen() {
        this.log("Running _testLicenseScreen");
        this.assertKeyPresent("license.title");
        this.assertKeyPresent("license.serverid.label");
    }

    private void _testLicenseSuccess() {
        this.log("Running _testLicenseSuccess");
        this.setTextField("key", "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm");
        this.submit();
        this.assertKeyNotPresent("license.title");
    }

    private void _testInstallScreen() {
        this.log("Running _testInstallScreen");
        this.assertKeyPresent("install.title");
        this.assertKeyPresent("install.new.label");
        this.assertKeyPresent("install.upgrade.xml.label");
        this.assertKeyNotPresent("install.upgrade.db.label");
    }

    private void _testInstallNew() {
        this.log("Running _testInstallNew");
        this.clickRadioOption("installOption", "install.new");
        this.submit();
        this.assertKeyNotPresent("install.title");
    }

    private void _testDatabaseScreen() {
        this.log("Running _testDatabaseScreen");
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.embedded.label");
        this.assertKeyPresent("database.jdbc.label");
        this.assertKeyPresent("database.datasource.label");
    }

    private void _testDatabaseSelectJDBC() {
        this.log("Running _testDatabaseSelectJDBC");
        this.logger.info("Database properties to be used in setup:");
        this.logger.info("   database.type: <" + DATABASE_TYPE + ">");
        this.logger.info("   database.username: <" + DATABASE_USERNAME + ">");
        this.logger.info("   database.password: <" + DATABASE_PASSWORD + ">");
        this.logger.info("   database.driver: <" + DATABASE_DRIVER + ">");
        this.logger.info("   database.dialect: <" + DATABASE_DIALECT + ">");
        this.logger.info("   database.url: <" + DATABASE_URL + ">");
        if (!this.isDatabaseSpecified()) {
            this.logger.warn("Falling back to HSQLDB since system properties to specify which database to use were not found");
            this.logger.warn("Please set the above system properties to specify a real database!");
            this.clickRadioOption("databaseOption", "db.embedded");
            this.submit();
        } else {
            this.clickRadioOption("databaseOption", "db.jdbc");
            this.selectOptionByValue("jdbcDatabaseType", DATABASE_TYPE);
            this.setTextField("jdbcDriverClassName", "");
            this.setTextField("jdbcUsername", DATABASE_USERNAME);
            this.setTextField("jdbcPassword", DATABASE_PASSWORD);
            this.setTextField("jdbcDriverClassName", DATABASE_DRIVER);
            this.setTextField("jdbcUrl", DATABASE_URL);
            this.setTextField("jdbcHibernateDialect", DATABASE_DIALECT);
            this.checkCheckbox("jdbcOverwriteData");
            this.submit();
        }
        Assert.assertThat((Object)this.getWarningIfPresent(), (Matcher)IsEmptyString.isEmptyOrNullString());
        Assert.assertThat((Object)this.getErrorBoxIfPresent(), (Matcher)IsEmptyString.isEmptyOrNullString());
        this.assertKeyNotPresent("database.title");
    }

    private String getWarningIfPresent() {
        try {
            return this.getElementTextByXPath("//p[@class='warningBox']").trim();
        }
        catch (AssertionFailedError e) {
            return null;
        }
    }

    private String getErrorBoxIfPresent() {
        try {
            return this.getElementTextByXPath("//div[@class='errorBox']").trim();
        }
        catch (AssertionFailedError e) {
            return null;
        }
    }

    private void _testOptionsScreen() {
        this.log("Running _testOptionsScreen");
        this.assertKeyPresent("options.title");
        this.assertKeyPresent("options.title.label");
        this.assertKeyPresent("session.sessiontime.label");
    }

    private void _testOptionsSuccess() {
        this.log("Running _testOptionsSuccess");
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "20");
        this.setTextField("baseURL", HOST_PATH);
        this.submit();
        this.assertKeyNotPresent("options.title");
    }

    private void _testMailServerScreen() {
        this.log("Running _testMailServerScreen");
        this.assertKeyPresent("mailserver.title");
        this.assertKeyPresent("mailserver.notification.label");
        this.assertKeyPresent("mailserver.from.label");
        this.assertKeyPresent("mailserver.prefix.label");
        this.assertKeyPresent("mailserver.host.label");
        this.assertKeyPresent("mailserver.username.label");
        this.assertKeyPresent("mailserver.password.label");
    }

    private void _testMailServerSuccess() {
        this.log("Running _testMailServerSuccess");
        this.clickRadioOption("jndiMailActive", "false");
        this.setTextField("notificationEmail", "user@example.com");
        this.setTextField("host", "localhost");
        this.setTextField("from", "security@example.com");
        this.submit();
        this.assertKeyNotPresent("mailserver.notification.label");
    }

    private void _testInternalDirectoryScreen() {
        this.log("Running _testInternalDirectoryScreen");
        this.assertKeyPresent("directoryinternal.title");
        this.assertKeyPresent("directoryinternal.name.label");
        this.assertKeyPresent("directoryinternal.description.label");
        this.assertKeyPresent("directoryinternal.passwordmaxchangetime.label");
        this.assertKeyPresent("directoryinternal.passwordmaxattempts.label");
        this.assertKeyPresent("directoryinternal.passwordhistorycount.label");
        this.assertKeyPresent("directoryinternal.passwordregex.label");
        this.assertKeyPresent("directoryconnector.userencryptionmethod.label");
    }

    private void _testInternalDirectorySuccess() {
        this.log("Running _testInternalDirectorySuccess");
        this.setTextField("name", "Test Internal Directory");
        this.setTextField("description", "");
        this.setTextField("passwordRegex", "");
        this.setTextField("passwordMaxAttempts", "");
        this.setTextField("passwordMaxChangeTime", "");
        this.setTextField("passwordHistoryCount", "");
        this.selectOptionByValue("userEncryptionMethod", "atlassian-security");
        this.submit();
        this.assertKeyNotPresent("directoryinternal.title");
    }

    private void _testDefaultAdminScreen() {
        this.log("Running _testDefaultAdminScreen");
        this.assertKeyPresent("defaultadmin.title");
        this.assertKeyPresent("principal.name.label");
        this.assertKeyPresent("principal.password.label");
        this.assertKeyPresent("principal.passwordconfirm.label");
        this.assertKeyPresent("principal.firstname.label");
        this.assertKeyPresent("principal.lastname.label");
        this.assertKeyPresent("principal.email.label");
    }

    private void _testDefaultAdminSuccess() {
        this.log("Running _testDefaultAdminSuccess");
        this.setTextField("email", "admin@example.com");
        this.setTextField("name", "admin");
        this.setTextField("password", "admin");
        this.setTextField("passwordConfirm", "admin");
        this.setTextField("firstname", "Super");
        this.setTextField("lastname", "User");
        this.submit();
        this.assertKeyNotPresent("defaultadmin.title");
    }

    private void _testConfigureIntegratedApps() {
        this.log("Running _testConfigureIntegratedApps");
        this.assertKeyPresent("integration.title");
        this.checkCheckbox("configureOpenIDServer");
        this.uncheckCheckbox("configureDemoApp");
        this.submit();
    }

    private void _testCompleteSetup() {
        this.log("Running _testCompleteSetup");
        try {
            this.assertAtLoginForm();
        }
        catch (AssertionFailedError e) {
            this.logger.error("Crowd setup has completed. However for some yet-to-be-found reason, clickElementByXPath for the 'continueButton' has failed. We can ignore this, so proceed with the tests.");
        }
    }

    Map<String, String> getDatabaseInformation(Set<String> databaseFields) {
        this.gotoSystemInfo();
        HashMap<String, String> information = new HashMap<String, String>();
        for (IElement e : this.getElementsByXPath("//div[@class='field-group']")) {
            String label = e.getElement("label").getTextContent().trim();
            IElement elem = (IElement)Iterables.getFirst((Iterable)e.getElements("span"), null);
            String value = elem != null ? elem.getTextContent().trim() : null;
            information.put(label, value);
        }
        return Maps.filterKeys(information, (Predicate)Predicates.in(databaseFields));
    }

    private void _testDatabaseSystemInfo() {
        this.log("Running _testDatabaseSystemInfo");
        this._loginAdminUser();
        HashMap<String, String> expected = new HashMap<String, String>();
        if (this.isDatabaseSpecified()) {
            expected.put(this.i18n.getString("database.jdbc.url.label"), DATABASE_URL);
            expected.put(this.i18n.getString("systeminfo.jdbc.username.label"), DATABASE_USERNAME);
            expected.put(this.i18n.getString("systeminfo.jdbc.driver.label"), DATABASE_DRIVER);
            expected.put(this.i18n.getString("database.dialect.label"), DATABASE_DIALECT);
        } else {
            expected.put(this.i18n.getString("systeminfo.jdbc.driver.label"), HSQLDB_URL_PREFIX + this.getCrowdHome() + HSQLDB_URL_SUFFIX);
            expected.put(this.i18n.getString("systeminfo.jdbc.username.label"), HSQLDB_USERNAME);
            expected.put(this.i18n.getString("systeminfo.jdbc.driver.label"), HSQLDB_DRIVER);
            expected.put(this.i18n.getString("database.dialect.label"), HSQLDB_DIALECT);
        }
        SetupCrowdWithDatabase.assertEquals(expected, this.getDatabaseInformation(expected.keySet()));
    }

    private boolean isDatabaseSpecified() {
        return !DATABASE_TYPE.equals(UNSPECIFIED_DATABASE_TYPE) && !StringUtils.isBlank((CharSequence)DATABASE_TYPE);
    }
}

