/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCaseWithEmailServer;
import javax.mail.internet.MimeMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ResetPrincipalPasswordTest
extends CrowdAcceptanceTestCaseWithEmailServer {
    private static final String EMAIL_TEMPLATE_JAPANESE = "\u3053\u3093\u306b\u3061\u306f";
    private static final String EMAIL_TEMPLATE_GREEK = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03c2";
    private static final String USERNAME = "TestUser";
    private static final String USER_FIRSTNAME = "\u00d8ring";
    private static final String USER_LASTNAME = "N\u00fa\u00f1ez";
    private static final String DIRECTORY_NAME = "Test Internal Directory";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("authenticationtest.xml");
        this._loginAdminUser();
        this._configureMailServer();
    }

    public void testResetEmailWithNonAsciiBody() throws Exception {
        this.log("Running testResetEmailWithNonAsciiBody");
        this.gotoAddPrincipal();
        this.setTextField("email", this.getEmailAddress());
        this.setTextField("name", USERNAME);
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", USER_FIRSTNAME);
        this.setTextField("lastname", USER_LASTNAME);
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.gotoMailTemplate();
        this.setTextField("forgottenPasswordTemplate", "\u3053\u3093\u306b\u3061\u306f\u03b1\u03b2\u03b3\u03b4\u03b5\u03c2");
        this.submit();
        this.gotoViewPrincipal(USERNAME, DIRECTORY_NAME);
        this.clickLink("reset-password-principal");
        this.submit();
        MimeMessage message = this.waitForExactlyOneMessage();
        ResetPrincipalPasswordTest.assertEquals((String)"Reset password email contains incorrect content", (String)"\u3053\u3093\u306b\u3061\u306f\u03b1\u03b2\u03b3\u03b4\u03b5\u03c2", (String)message.getContent().toString());
    }

    public void testResetEmailWithNonAsciiUsername() throws Exception {
        this.log("Running testResetEmailWithNonAsciiUsername");
        this.gotoAddPrincipal();
        this.setTextField("email", this.getEmailAddress());
        this.setTextField("name", USERNAME);
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", USER_FIRSTNAME);
        this.setTextField("lastname", USER_LASTNAME);
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.gotoMailTemplate();
        this.setTextField("forgottenPasswordTemplate", "$firstname $lastname");
        this.submit();
        this.gotoViewPrincipal(USERNAME, DIRECTORY_NAME);
        this.clickLink("reset-password-principal");
        this.submit();
        MimeMessage message = this.waitForExactlyOneMessage();
        Assert.assertThat((Object)message.getContent().toString(), (Matcher)CoreMatchers.containsString((String)"\u00d8ring N\u00fa\u00f1ez"));
    }

    public void testResetEmailForInactiveStatusMessage() throws Exception {
        this.log("Running testResetEmailForInactiveStatusMessage");
        this.gotoMailTemplate();
        this.setTextField("forgottenPasswordTemplate", this.getText("mailtemplate.template.forgotten.password.text"));
        this.submit();
        this._logout();
        this.clickLink("forgottenlogindetails");
        this.clickRadioOption("forgottenDetail", "password");
        this.setTextField("username", "inactive");
        this.submit();
        MimeMessage message = this.waitForExactlyOneMessage();
        ResetPrincipalPasswordTest.assertTrue((String)"Reset password email does not acknowledge inactive user message", (boolean)message.getContent().toString().contains(this.getText("mailtemplate.template.user.inactive")));
    }

    public void testResetEmailForActiveStatusMessage() throws Exception {
        this.log("Running testResetEmailForActiveStatusMessage");
        this.gotoMailTemplate();
        this.setTextField("forgottenPasswordTemplate", this.getText("mailtemplate.template.forgotten.password.text"));
        this.submit();
        this._logout();
        this.clickLink("forgottenlogindetails");
        this.clickRadioOption("forgottenDetail", "password");
        this.setTextField("username", "user");
        this.submit();
        MimeMessage message = this.waitForExactlyOneMessage();
        ResetPrincipalPasswordTest.assertTrue((String)"Reset password email does not acknowledge active user message", (boolean)message.getContent().toString().contains(this.getText("mailtemplate.template.user.active")));
    }
}

