/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.Arrays;

public class RemoveDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String ADMIN_INTERNAL_DIRECTORY_NAME = "Test Internal Directory";
    private static final String INTERNAL_DIRECTORY_NAME = "Second Directory";
    private static final String CROWD_DIRECTORY_NAME = "Remote Crowd Directory";
    private static final String CONNECTOR_DIRECTORY_NAME = "ApacheDS Directory";
    private static final String CUSTOM_DIRECTORY_NAME = "Custom Directory";
    private static final String DELEGATED_DIRECTORY_NAME = "Delegated Directory";
    private static final String VIEW_INTERNAL_DIRECTORY_PATH = "/crowd/console/secure/directory/viewinternal!default.action";
    private static final String VIEW_CROWD_DIRECTORY_PATH = "/crowd/console/secure/directory/viewremotecrowd!default.action";
    private static final String VIEW_DELEGATED_DIRECTORY_PATH = "/crowd/console/secure/directory/viewdelegated!default.action";
    private static final String VIEW_CUSTOM_DIRECTORY_PATH = "/crowd/console/secure/directory/viewcustom!default.action";
    private static final String VIEW_CONNECTOR_DIRECTORY_PATH = "/crowd/console/secure/directory/viewconnector!default.action";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("removedirectory.xml");
    }

    public void testRemoveInternalDirectoryFromConsole() {
        this.intendToModifyData();
        this.log("Running: testRemoveInternalDirectoryFromConsole");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(ADMIN_INTERNAL_DIRECTORY_NAME);
        this.assertTextPresent(ADMIN_INTERNAL_DIRECTORY_NAME);
        this.clickLink("remove-directory");
        this.assertKeyPresent("directory.remove.text");
        this.assertTextPresent(ADMIN_INTERNAL_DIRECTORY_NAME);
        this.assertTextPresent("Crowd Internal Directory");
        this.submit();
        this.assertKeyNotPresent("updatesuccessful.label");
        this.assertKeyPresent("preventlockout.removedirectory.label", Arrays.asList(ADMIN_INTERNAL_DIRECTORY_NAME));
    }

    public void testRemoveRemoteCrowdDirectoryFromConsole() {
        this.intendToModifyData();
        this.log("Running: testRemoveRemoteCrowdDirectoryFromConsole");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertTextPresent(CROWD_DIRECTORY_NAME);
        this.clickLink("remove-directory");
        this.assertKeyPresent("directory.remove.text");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("directory-table", CROWD_DIRECTORY_NAME);
    }

    public void testRemoveSecondInternalDirectoryFromConsole() {
        this.intendToModifyData();
        this.log("Running: testRemoveSecondInternalDirectoryFromConsole");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertTextPresent(INTERNAL_DIRECTORY_NAME);
        this.clickLink("remove-directory");
        this.assertKeyPresent("directory.remove.text");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("directory-table", INTERNAL_DIRECTORY_NAME);
    }

    public void testRemoveConnectorDirectoryFromConsole() {
        this.intendToModifyData();
        this.log("Running: testRemoveConnectorDirectoryFromConsole");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME);
        this.assertTextPresent(CONNECTOR_DIRECTORY_NAME);
        this.clickLink("remove-directory");
        this.assertKeyPresent("directory.remove.text");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("directory-table", CONNECTOR_DIRECTORY_NAME);
    }

    public void testRemoveCustomDirectoryFromConsole() {
        this.intendToModifyData();
        this.log("Running: testRemoveCustomDirectoryFromConsole");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertTextPresent(CUSTOM_DIRECTORY_NAME);
        this.clickLink("remove-directory");
        this.assertKeyPresent("directory.remove.text");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("directory-table", CUSTOM_DIRECTORY_NAME);
    }

    public void testRemoveDelegatedDirectoryFromConsole() {
        this.intendToModifyData();
        this.log("Running: testRemoveDelegatedDirectoryFromConsole");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME);
        this.assertTextPresent(DELEGATED_DIRECTORY_NAME);
        this.clickLink("remove-directory");
        this.assertKeyPresent("directory.remove.text");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("directory-table", DELEGATED_DIRECTORY_NAME);
    }

    public void testCancelRemoveInternalDirectory() {
        this.log("Running: testCancelRemoveInternalDirectory");
        this.doCancelRemoveDirectoryTest(INTERNAL_DIRECTORY_NAME, VIEW_INTERNAL_DIRECTORY_PATH);
    }

    public void testCancelRemoveRemoteCrowdDirectory() {
        this.log("Running: testCancelRemoveRemoteCrowdDirectory");
        this.doCancelRemoveDirectoryTest(CROWD_DIRECTORY_NAME, VIEW_CROWD_DIRECTORY_PATH);
    }

    public void testCancelRemoveDelegatedDirectory() {
        this.log("Running: testCancelRemoveDelegatedDirectory");
        this.doCancelRemoveDirectoryTest(DELEGATED_DIRECTORY_NAME, VIEW_DELEGATED_DIRECTORY_PATH);
    }

    public void testCancelRemoveConnectorDirectory() {
        this.log("Running: testCancelRemoveConnectorDirectory");
        this.doCancelRemoveDirectoryTest(CONNECTOR_DIRECTORY_NAME, VIEW_CONNECTOR_DIRECTORY_PATH);
    }

    public void testCancelRemoveCustomDirectory() {
        this.log("Running: testCancelRemoveCustomDirectory");
        this.doCancelRemoveDirectoryTest(CUSTOM_DIRECTORY_NAME, VIEW_CUSTOM_DIRECTORY_PATH);
    }

    private void doCancelRemoveDirectoryTest(String directoryName, String expectedPathOnCancel) {
        this.tester.setScriptingEnabled(true);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(directoryName);
        this.assertTextPresent(directoryName);
        this.clickLink("remove-directory");
        this.assertKeyPresent("directory.remove.text");
        this.clickLinkWithText("Cancel");
        this.assertTextPresent(directoryName);
        RemoveDirectoryTest.assertEquals((String)expectedPathOnCancel, (String)this.tester.getTestingEngine().getPageURL().getPath());
        this.tester.setScriptingEnabled(false);
    }
}

