/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.google.common.base.Function;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ModifyApplicationRemoteAddressesTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreBaseSetup();
        this._loginAdminUser();
        this.gotoBrowseApplications();
        this.clickLinkWithText("crowd");
        this.clickLink("application-remoteaddress");
    }

    private List<String> getAddresses() {
        return this.scrapeTable("addressesTable", (List<String>)this.getTextForList("browser.address.label", "browser.action.label"), new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        }, true);
    }

    public void testShowsExpectedAddresses() {
        Assert.assertThat(this.getAddresses(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"192.168.0.72", "moonlight.sydney.atlassian.com", "localhost", "127.0.0.1"}));
    }

    public void testAddAddressShowsUpdateSuccessful() {
        this.intendToModifyData();
        this.setWorkingForm("addressForm");
        this.setTextField("address", "example.test");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        Assert.assertThat(this.getAddresses(), (Matcher)Matchers.hasItem((Object)"example.test"));
    }

    public void testAddAddressDoesNotShowUpdateSuccessfulForEmptyString() {
        this.setWorkingForm("addressForm");
        this.setTextField("address", "");
        this.submit();
        this.assertKeyNotPresent("updatesuccessful.label");
        Assert.assertThat(this.getAddresses(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"192.168.0.72", "moonlight.sydney.atlassian.com", "localhost", "127.0.0.1"}));
    }

    public void testAddAddressDoesNotShowUpdateSuccessfulForWhitespace() {
        this.setWorkingForm("addressForm");
        this.setTextField("address", " ");
        this.submit();
        this.assertKeyNotPresent("updatesuccessful.label");
        Assert.assertThat(this.getAddresses(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"192.168.0.72", "moonlight.sydney.atlassian.com", "localhost", "127.0.0.1"}));
    }

    public void testRemoveShowsUpdateSuccessful() {
        this.intendToModifyData();
        this.clickElementByXPath("//tr[td='192.168.0.72']/td/a");
        this.assertKeyPresent("updatesuccessful.label");
        Assert.assertThat(this.getAddresses(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"moonlight.sydney.atlassian.com", "localhost", "127.0.0.1"}));
    }
}

