/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Assert;

public class LdifLoaderForTesting {
    private final String baseUrl;

    public LdifLoaderForTesting(String baseUrl) {
        this.baseUrl = baseUrl;
        Assert.assertTrue((boolean)baseUrl.endsWith("/crowd"));
    }

    public void setLdif(InputStream in) throws IOException {
        String contentUrl = this.baseUrl.replaceAll("/crowd$", "/apacheds15/content");
        HttpPost pm = new HttpPost(contentUrl);
        InputStreamEntity entity = new InputStreamEntity(in, ContentType.APPLICATION_OCTET_STREAM);
        pm.setEntity((HttpEntity)entity);
        CloseableHttpClient hc = HttpClients.createMinimal();
        HttpResponse response = hc.execute((HttpUriRequest)pm);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    public Test createRestoreTest(final InputStream in) {
        return new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult result) {
                result.startTest((Test)this);
                try {
                    LdifLoaderForTesting.this.setLdif(in);
                    result.endTest((Test)this);
                }
                catch (IOException e) {
                    result.addError((Test)this, (Throwable)e);
                }
            }
        };
    }

    public static Test createRestoreTest(Class<?> testClass, String resourceName) {
        InputStream in = testClass.getResourceAsStream(resourceName);
        Assert.assertNotNull((Object)in);
        return new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).createRestoreTest(in);
    }
}

