/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class GzipFilterOptionTest
extends CrowdAcceptanceTestCase {
    private CloseableHttpClient client;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.addRequestHeader("Accept-Encoding", "gzip");
        this.closeBrowser();
        this.beginAt(URL_HOME);
        this._loginAdminUser();
        this.client = HttpClients.custom().disableContentCompression().build();
    }

    @Override
    public void tearDown() throws Exception {
        this.client.close();
        super.tearDown();
    }

    private HttpResponse responseFromRequestWithoutAcceptGzip() throws IOException {
        return this.client.execute((HttpUriRequest)new HttpGet(this.getBaseUrl() + "/console/login.action"));
    }

    private HttpResponse responseFromRequestWithAcceptGzip() throws IOException {
        HttpGet get = new HttpGet(this.getBaseUrl() + "/console/login.action");
        get.addHeader("Accept-Encoding", "gzip");
        return this.client.execute((HttpUriRequest)get);
    }

    private static void assertUncompressedResponse(HttpResponse resp) throws ParseException, IOException {
        GzipFilterOptionTest.assertEquals((int)200, (int)resp.getStatusLine().getStatusCode());
        Assert.assertThat((Object)resp.getHeaders("Content-Encoding"), (Matcher)Matchers.emptyArray());
        Assert.assertThat((Object)EntityUtils.toString((HttpEntity)resp.getEntity()), (Matcher)Matchers.containsString((String)"Atlassian Crowd"));
    }

    private static void assertCompressedResponse(HttpResponse resp) throws ParseException, IOException {
        GzipFilterOptionTest.assertEquals((int)200, (int)resp.getStatusLine().getStatusCode());
        Assert.assertThat((Object)resp.getFirstHeader("Content-Encoding").getValue(), (Matcher)Matchers.is((Object)"gzip"));
        String uncompressed = IOUtils.toString((InputStream)new GZIPInputStream(resp.getEntity().getContent()), (String)"us-ascii");
        Assert.assertThat((Object)uncompressed, (Matcher)Matchers.containsString((String)"Atlassian Crowd"));
    }

    public void testGzipOptionOn() throws ClientProtocolException, IOException {
        this.log("Running testGzipOptionOn");
        this.gotoGeneral();
        this.checkCheckbox("gzip");
        this.submit();
        this.gotoGeneral();
        this.assertCheckboxSelected("gzip");
        GzipFilterOptionTest.assertCompressedResponse(this.responseFromRequestWithAcceptGzip());
        GzipFilterOptionTest.assertUncompressedResponse(this.responseFromRequestWithoutAcceptGzip());
    }

    public void testGzipOptionOff() throws ClientProtocolException, IOException {
        this.log("Running testGzipOptionOff");
        this.gotoGeneral();
        this.uncheckCheckbox("gzip");
        this.submit();
        this.gotoGeneral();
        this.assertCheckboxNotSelected("gzip");
        GzipFilterOptionTest.assertUncompressedResponse(this.responseFromRequestWithAcceptGzip());
        GzipFilterOptionTest.assertUncompressedResponse(this.responseFromRequestWithoutAcceptGzip());
    }
}

