/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.integration.rest.service.RestCrowdClient;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ExpireSessionTest
extends CrowdAcceptanceTestCase {
    private static final String APPLICATION_NAME = "demo";
    private static final String APPLICATION_PASSWORD = "password";
    private ImmutableList<String> applicationSessionTableHeaders;
    private static Function<String, Date> parseDate = new Function<String, Date>(){

        public Date apply(@Nullable String input) {
            SimpleDateFormat df = new SimpleDateFormat("dd/M/yyyy HH:mm:ss");
            try {
                return df.parse(input);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.applicationSessionTableHeaders = this.getTextForList("application.name.label", "session.initialization.label", "session.lastaccessed.label", "browser.action.label");
        this.restoreBaseSetup();
    }

    protected void switchToInMemorySessions() {
        this.gotoSessionConfig();
        this.clickRadioOption("storageType", "memory");
        this.submit();
    }

    public void testExpireApplicationInMemorySession() {
        this.log("Running testExpireApplicationInMemorySession");
        this.switchToInMemorySessions();
        this.doTestExpireApplication();
    }

    public void testExpirePrincipalInMemorySession() {
        this.log("Running testExpirePrincipalInMemorySession");
        this.switchToInMemorySessions();
        this.doTestExpirePrincipal();
    }

    public void testExpireApplicationDatabaseSession() {
        this.log("Running testExpireApplicationDatabaseSession");
        this.doTestExpireApplication();
    }

    public void testExpirePrincipalDatabaseSession() {
        this.log("Running testExpirePrincipalDatabaseSession");
        this.doTestExpirePrincipal();
    }

    public void testRestClientsAreListedInApplicationSessions() throws Exception {
        this.log("Running testRestClientsAreListedInApplicationSessions");
        this.gotoCurrentApplicationSessions();
        List<String> beforeSessions = this.scrapeTable("application-session-results", (List<String>)this.applicationSessionTableHeaders, new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
        Assert.assertThat(beforeSessions, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)APPLICATION_NAME)));
        this.getCrowdClient().getUser("admin");
        this.gotoCurrentApplicationSessions();
        List<String> afterSessions = this.scrapeTable("application-session-results", (List<String>)this.applicationSessionTableHeaders, new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
        Assert.assertThat(afterSessions, (Matcher)Matchers.hasItem((Object)APPLICATION_NAME));
    }

    public void testRestClientApplicationSessionsCanBeExpired() throws Exception {
        this.log("Running testRestClientApplicationSessionsCanBeExpired");
        this.getCrowdClient().getUser("admin");
        this.gotoCurrentApplicationSessions();
        List<String> afterSessions = this.scrapeTable("application-session-results", (List<String>)this.applicationSessionTableHeaders, new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
        Assert.assertThat(afterSessions, (Matcher)Matchers.hasItem((Object)APPLICATION_NAME));
        this.clickElementByXPath("//tr[.//a[normalize-space(.) = 'demo']]//a[normalize-space(.)='Expire']");
        this.gotoCurrentApplicationSessions();
        List<String> beforeSessions = this.scrapeTable("application-session-results", (List<String>)this.applicationSessionTableHeaders, new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
        Assert.assertThat(beforeSessions, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)APPLICATION_NAME)));
    }

    protected void doTestExpireApplication() {
        this.gotoCurrentApplicationSessions();
        this.assertKeyPresent("session.application.title");
        this.assertLinkPresentWithExactText("crowd");
        this.clickLinkWithExactText("Expire");
        this.assertLinkPresentWithExactText("crowd");
    }

    protected void doTestExpirePrincipal() {
        this.gotoCurrentPrincipalSessions();
        this.assertKeyPresent("session.principal.title");
        this.assertLinkPresentWithExactText("admin");
        this.clickLinkWithExactText("Expire");
        this.assertAtLoginForm();
    }

    private static Matcher<Date> inLastFiveMinutes(long now) {
        return Matchers.both((Matcher)Matchers.greaterThan((Comparable)new Date(now - TimeUnit.MINUTES.toMillis(5L)))).and(Matchers.lessThan((Comparable)new Date(now)));
    }

    public void testApplicationSessionsShowLastAccessTime() {
        this.gotoCurrentApplicationSessions();
        this.assertKeyPresent("session.application.title");
        List<String> sessions = this.scrapeTable("application-session-results", (List<String>)this.applicationSessionTableHeaders, new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(2);
            }
        });
        Assert.assertThat(sessions, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThat(sessions, (Matcher)Matchers.everyItem((Matcher)Matchers.not(ExpireSessionTest.equalToIgnoringWhiteSpace(""))));
        Assert.assertThat((Object)Iterables.transform(sessions, parseDate), (Matcher)Matchers.everyItem(ExpireSessionTest.inLastFiveMinutes(System.currentTimeMillis())));
    }

    public void testUserSessionsShowLastAccessTime() {
        this.gotoCurrentPrincipalSessions();
        this.assertKeyPresent("session.principal.title");
        List<String> sessions = this.scrapeTable("principal-session-results", (List<String>)this.getTextForList("principal.name.label", "browser.directory.label", "session.initialization.label", "session.lastaccessed.label", "browser.action.label"), new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(3);
            }
        });
        Assert.assertThat(sessions, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        Assert.assertThat(sessions, (Matcher)Matchers.everyItem((Matcher)Matchers.not(ExpireSessionTest.equalToIgnoringWhiteSpace(""))));
        Assert.assertThat((Object)Iterables.transform(sessions, parseDate), (Matcher)Matchers.everyItem(ExpireSessionTest.inLastFiveMinutes(System.currentTimeMillis())));
    }

    private CrowdClient getCrowdClient() {
        Properties properties = new Properties();
        properties.setProperty("crowd.base.url", HOST_PATH);
        properties.setProperty("application.name", APPLICATION_NAME);
        properties.setProperty("application.password", APPLICATION_PASSWORD);
        ClientPropertiesImpl clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        return new RestCrowdClient((ClientProperties)clientProperties);
    }
}

