/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.embedded.api.User;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;

public class EscapedDnTest
extends CrowdAcceptanceTestCase {
    private static final String CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING = "ApacheDS Caching Directory";
    private static final long MAX_SYNC_WAIT_TIME_MS = 60000L;
    private static boolean ldifSetup = false;
    private DbCachingTestHelper dbCachingTestHelper;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this._loginAdminUser();
        this.restoreCrowdFromXML("viewdirectory.xml");
        if (!ldifSetup) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("EscapedDnTest-entries.ldif");
            EscapedDnTest.assertNotNull((Object)in);
            new LdifLoaderForTesting(this.getBaseUrl()).setLdif(in);
            ldifSetup = true;
        }
        this.dbCachingTestHelper = new DbCachingTestHelper(this.tester);
    }

    private void searchAllPrincipals() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit();
    }

    private void synchroniseDirectory() {
        this.dbCachingTestHelper.synchroniseDirectory(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING, 60000L);
    }

    public void testSynchronisationPicksUpUsersAndGroupsWithDnsThatRequireEscaping() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "");
        this.submit();
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        ImmutableList expectedUsers = ImmutableList.of(this.userWithDetails("User \"with\" Quotes", "user-with-quotes"), this.userWithDetails("User with Spaces", "user-with-spaces"), this.userWithDetails("User,with,Commas", "user-with-commas"), this.userWithDetails("User/with/Slashes", "u/s/e/r"), this.userWithDetails("User\\with\\Backslashes", "u\\s\\e\\r"));
        List<User> users = this.getUserDetailsTableContents();
        Assert.assertThat(users, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Collection)expectedUsers));
    }

    public void testEmptyOUWithSlashesInDnWarnsOnlyAboutMissingEntries() throws InterruptedException {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("connectordetails");
        this.setTextField("baseDN", "ou=escaping,dc=example,dc=com");
        this.submit();
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "ou=unit/with/slashes");
        this.submit();
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
        String warning = this.getElementTextByXPath("//div[@class='aui-message error']").trim();
        EscapedDnTest.assertEquals((String)"The warning should not include any exception", (String)this.getMessage("directoryconnector.testsearch.invalid"), (String)warning);
    }
}

