/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import org.junit.Assert;

public class DirectoryImporterTest
extends CrowdAcceptanceTestCase {
    private static final String SOURCE_DIRECTORY_NAME = "Test Internal Directory";
    private static final String TARGET_DIRECTORY_NAME = "Blank Internal Directory";
    private static final String DIFFERENT_ENCRYPTION_DIRECTORY_NAME = "Third Directory";
    private static final String SOURCE_DIRECTORY_NAME_WITH_NESTED_GROUPS = "nested group";
    private static final String DESTINATION_DIRECTORY_NAME_WITH_NESTED_GROUPS = "another blank directory with nested group";
    private static final String DESTINATION_DIRECTORY_NAME_WITHOUT_NESTED_GROUPS = "another blank directory without nested group";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("directoryimportertest.xml");
        this._loginAdminUser();
        this.gotoImporters();
        this.setRadioButton("importType", "DIRECTORY");
        this.submit();
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testBothDirectoriesCannotBeTheSame() {
        this.log("Running testBothDirectoriesCannotBeTheSame");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", TARGET_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.sourcetargetsame.error");
    }

    public void testUserEncryptionMustBeTheSame() {
        this.log("Running testUserEncryptionMustBeTheSame");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", TARGET_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", DIFFERENT_ENCRYPTION_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.same.encryption.error");
    }

    public void testPerformDirectoryMigration() {
        this.log("Running testPerformDirectoryMigration");
        this.intendToModifyData();
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.source.confirmation.directory.text", SOURCE_DIRECTORY_NAME);
        this.assertKeyPresent("dataimport.directory.target.confirmation.directory.text", TARGET_DIRECTORY_NAME);
        this.assertKeyPresent("dataimport.directory.overwrite.confirmation.directory.text", "False");
        this.setWorkingForm("dataimport");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        Assert.assertThat((Object)this.getElementTextById("users-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("groups-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("memberships-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("3"));
    }

    public void testGoingBackAStepRetainsOverwriteSetting() {
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.assertCheckboxNotSelected("overwriteTarget");
        this.checkCheckbox("overwriteTarget");
        this.submit();
        this.assertKeyPresent("dataimport.directory.source.confirmation.directory.text", SOURCE_DIRECTORY_NAME);
        this.assertKeyPresent("dataimport.directory.target.confirmation.directory.text", TARGET_DIRECTORY_NAME);
        this.assertKeyPresent("dataimport.directory.overwrite.confirmation.directory.text", "True");
        this.clickLinkWithExactText(this.getText("dataimport.options.label"));
        this.assertKeyPresent("dataimport.importdirectory.text");
        this.assertCheckboxSelected("overwriteTarget");
    }

    public void testPerformDirectoryImportWithNestedGroups() {
        this.log("Running testPerformDirectoryImportWithNestedGroups");
        this.intendToModifyData();
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME_WITH_NESTED_GROUPS);
        this.selectOption("targetDirectoryID", DESTINATION_DIRECTORY_NAME_WITH_NESTED_GROUPS);
        this.submit();
        this.assertKeyPresent("dataimport.importnestedgroup.text");
        this.setWorkingForm("dataimport");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        Assert.assertThat((Object)this.getElementTextById("users-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("1"));
        Assert.assertThat((Object)this.getElementTextById("groups-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("memberships-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
    }

    public void testPerformDirectoryImportWithoutNestedGroups() {
        this.log("Running testPerformDirectoryImportWithoutNestedGroups");
        this.intendToModifyData();
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME_WITH_NESTED_GROUPS);
        this.selectOption("targetDirectoryID", DESTINATION_DIRECTORY_NAME_WITHOUT_NESTED_GROUPS);
        this.submit();
        this.assertKeyPresent("dataimport.importnestedgroup.not.text");
        this.setWorkingForm("dataimport");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        Assert.assertThat((Object)this.getElementTextById("users-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("1"));
        Assert.assertThat((Object)this.getElementTextById("groups-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("memberships-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("1"));
    }

    public void testPerformDirectoryImportWithOverwrite() {
        this.log("Running testPerformDirectoryImportWithOverwrite");
        this.intendToModifyData();
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.checkCheckbox("overwriteTarget");
        this.submit();
        this.assertTextPresent("Overwriting destination directory: True");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        Assert.assertThat((Object)this.getElementTextById("users-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("groups-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("memberships-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("3"));
    }

    public void testPerformDirectoryImportThenRepeatWithOverwrite() {
        this.log("Running testPerformDirectoryImportWithOverwrite");
        this.intendToModifyData();
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.submit();
        this.assertTextNotPresent("Overwriting destination directory: True");
        this.submit();
        Assert.assertThat((Object)this.getElementTextById("users-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("groups-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("memberships-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("3"));
        this.gotoImporters();
        this.setRadioButton("importType", "DIRECTORY");
        this.submit();
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.checkCheckbox("overwriteTarget");
        this.submit();
        this.assertTextPresent("Overwriting destination directory: True");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        Assert.assertThat((Object)this.getElementTextById("users-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("groups-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("2"));
        Assert.assertThat((Object)this.getElementTextById("memberships-imported"), DirectoryImporterTest.equalToIgnoringWhiteSpace("3"));
    }
}

