/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.harness.CrowdWebAppConsoleAcceptanceTestHarness;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import java.io.IOException;
import java.io.InputStream;

public class DelegatedDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String DELEGATED_DIRECTORY_NAME = "ApacheDS Delegated Directory";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("delegatedtest.xml");
    }

    private static void restoreLdif() throws IOException {
        InputStream in = CrowdWebAppConsoleAcceptanceTestHarness.class.getResourceAsStream("/com/atlassian/crowd/acceptance/tests/default-entries.ldif");
        DelegatedDirectoryTest.assertNotNull((Object)in);
        new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).setLdif(in);
    }

    public void testDelegatedDirectoryAuthenticateCreatesUserInUnderlyingInternalDirectory() throws IOException {
        this.log("Running testDelegatedDirectoryAuthenticateCreatesUserInUnderlyingInternalDirectory");
        DelegatedDirectoryTest.restoreLdif();
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        this.assertElementNotPresent("user-details");
        this.gotoViewApplication("crowd");
        this.clickLink("application-authtest");
        this.setWorkingForm("app-auth-test-form");
        this.setTextField("testUsername", "aeinstein");
        this.setTextField("testPassword", "secret");
        this.submit();
        this.assertTextPresent("Successful verification");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        this.assertTableRowCountEquals("user-details", 2);
        this.assertUserInTable("aeinstein", "Albert Einstein", "aeinstein@example.com");
    }

    public void testDelegatedDirectoryImportLocalGroup() {
        this.log("Running testDelegatedDirectoryImportLocalGroup");
        this.gotoViewGroup("imported_group", DELEGATED_DIRECTORY_NAME);
        this.assertTextInElement("groupName", "imported_group");
        this.assertKeyInElement("groupLocation", "group.location.local");
        this.assertTextInElement("groupDirectory", DELEGATED_DIRECTORY_NAME);
        this.assertKeyInElement("groupDirectory", "directory.delegating.type.name");
    }

    public void testDelegatedDirectoryAddLocalGroup() {
        this.log("Running testDelegatedDirectoryAddLocalGroup");
        this.gotoAddGroup();
        this.setWorkingForm("addGroupForm");
        this.setTextField("name", "test_local_group");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        this.assertTextInElement("groupName", "test_local_group");
        this.assertKeyInElement("groupLocation", "group.location.local");
        this.assertTextInElement("groupDirectory", DELEGATED_DIRECTORY_NAME);
        this.assertKeyInElement("groupDirectory", "directory.delegating.type.name");
    }
}

