/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ConsoleLoginTest
extends CrowdAcceptanceTestCase {
    private String user = "user";
    private String noauth = "demo";
    private String nonexistent = "nonexistent";
    private String inactive = "inactive";
    private String password = "password";
    private String bogusPassword = "bogus";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("authenticationtest.xml");
        this.gotoPage("/console/logoff.action");
    }

    public void testSystemAdminMenuNotVisibleInitially() {
        this.gotoPage("/console/login.action");
        this.assertElementNotPresent("system-admin-menu");
    }

    public void testConsoleAdminLoginSuccessful() {
        this.log("Running testConsoleAdminLoginSuccessful");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", "admin");
        this.setTextField("j_password", "admin");
        this.submit();
        this.assertKeyPresent("console.welcome");
        this.assertIsLoggedIn();
        this.assertElementPresent("system-admin-menu");
    }

    public void testConsoleUserLoginSuccessful() {
        this.log("Running testConsoleUserLoginSuccessful");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", this.user);
        this.setTextField("j_password", this.password);
        this.submit();
        this.assertIsLoggedIn();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertTextFieldEquals("firstname", "Test");
        this.assertTextFieldEquals("lastname", "User");
        this.assertTextFieldEquals("email", "user@example.com");
        this.assertElementNotPresent("system-admin-menu");
    }

    public void testConsoleLoginWithBadCredentials() {
        this.log("Running testConsoleLoginWithBadCredentials");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", "admin");
        this.setTextField("j_password", this.bogusPassword);
        this.submit();
        this.assertKeyPresent("login.failed.label");
    }

    public void testConsoleLoginWithNonExistentUser() {
        this.log("Running testConsoleLoginWithNonExistentUser");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", this.nonexistent);
        this.setTextField("j_password", this.password);
        this.submit();
        this.assertKeyPresent("login.failed.label");
        this.assertIsLoggedOut();
    }

    public void testConsoleLoginWithNoAuthenticationAccess() {
        this.log("Running testConsoleLoginWithNoAuthenticationAccess");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", this.noauth);
        this.setTextField("j_password", this.password);
        this.submit();
        this.assertKeyPresent("login.failed.label");
        this.assertIsLoggedOut();
    }

    public void testConsoleLoginWithInactiveUser() {
        this.log("Running testConsoleLoginWithInactiveUser");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", this.inactive);
        this.setTextField("j_password", this.password);
        this.submit();
        this.assertKeyPresent("login.failed.label");
        this.assertIsLoggedOut();
    }

    public void testConsoleLoginWhenAlreadyLoggedIn() {
        this.log("Running testConsoleLoginWhenAlreadyLoggedIn");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", this.user);
        this.setTextField("j_password", this.password);
        this.submit();
        this.assertIsLoggedIn();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertTextFieldEquals("firstname", "Test");
        this.assertTextFieldEquals("lastname", "User");
        this.assertTextFieldEquals("email", "user@example.com");
        this.gotoPage("/console/login.action");
        this.assertIsLoggedIn();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertTextFieldEquals("firstname", "Test");
        this.assertTextFieldEquals("lastname", "User");
        this.assertTextFieldEquals("email", "user@example.com");
    }

    public void testConsoleLogoutSuccessful() {
        this.log("Running testConsoleLogoutSuccessful");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", "admin");
        this.setTextField("j_password", "admin");
        this.submit();
        this.assertKeyPresent("console.welcome");
        this.assertIsLoggedIn();
        this.gotoPage("/console/logoff.action");
        this.assertAtLoginForm();
        this.assertIsLoggedOut();
    }

    public void testConsoleLogoutWhenNotLoggedIn() {
        this.log("Running testConsoleLogoutWhenNotLoggedIn");
        this.assertAtLoginForm();
        this.assertIsLoggedOut();
        this.gotoPage("/console/logoff.action");
        this.assertAtLoginForm();
        this.assertIsLoggedOut();
    }

    public void testConsoleLoginInterceptor() {
        this.log("Running testConsoleLoginInterceptor");
        this.assertAtLoginForm();
        this.assertIsLoggedOut();
        this.gotoPage("/console/secure/admin/systeminfo.action");
        this.assertAtLoginForm();
        this.assertIsLoggedOut();
        this.setTextField("j_username", "admin");
        this.setTextField("j_password", "admin");
        this.submit();
        this.assertKeyPresent("systeminfo.title");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConsoleAccessDenied() {
        this.log("Running testConsoleAccessDenied");
        this.assertAtLoginForm();
        this.assertIsLoggedOut();
        this.gotoPage("/console/secure/admin/systeminfo.action");
        this.assertAtLoginForm();
        this.assertIsLoggedOut();
        this.setTextField("j_username", this.user);
        this.setTextField("j_password", this.password);
        try {
            this.tester.setIgnoreFailingStatusCodes(true);
            this.submit();
        }
        finally {
            this.tester.setIgnoreFailingStatusCodes(false);
        }
        this.tester.assertResponseCode(403);
        this.assertKeyPresent("accessdenied.text");
    }
}

