/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.harness.CrowdWebAppConsoleAcceptanceTestHarness;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class BrowsePrincipalsTest
extends CrowdAcceptanceTestCase {
    private static final long MAX_WAIT_TIME_MS = 10000L;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("searchdirectories.xml");
        this.synchroniseDirectory();
    }

    private void synchroniseDirectory() {
        DbCachingTestHelper.synchroniseDirectory(this.tester, "Apache DS 1.5.4", 10000L);
    }

    private static void restoreLdif() throws IOException {
        InputStream in = CrowdWebAppConsoleAcceptanceTestHarness.class.getResourceAsStream("/com/atlassian/crowd/acceptance/tests/default-entries.ldif");
        BrowsePrincipalsTest.assertNotNull((Object)in);
        new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).setLdif(in);
    }

    public void testBrowseInternalDirectoryUsers() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertUserInTable("admin", "Justin Koke", "admin@test.org");
        this.assertUserInTable("justin", "Justin Koke", "justin@test.org");
    }

    public void testBrowseUsersSearchIncludesMinimalParametersInRequestUrl() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.setTextField("search", "xxx");
        this.selectOption("directoryID", "Test Internal Directory");
        this.selectOption("active", "Active");
        this.submit();
        URL url = this.getTestingEngine().getPageURL();
        Assert.assertThat((Object)Splitter.on((String)"&").split((CharSequence)url.getQuery()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"search=xxx", "directoryID=3", "active=true"}));
    }

    public void testBrowseApacheDSUsers() throws IOException {
        BrowsePrincipalsTest.restoreLdif();
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.submit();
        this.assertUserInTable("aeinstein", "Albert Einstein", "aeinstein@example.com");
        this.assertUserInTable("mborn", "Max Born", "mborn@example.com");
        this.assertUserInTable("mcurie", "Marie Curie", "mcurie@example.com");
        this.assertUserInTable("mplanck", "Max Planck", "mplanck@example.com");
        this.assertUserInTable("nbohr", "Neils Bohr", "nbohr@example.com");
        this.assertUserInTable("wpauli", "Wolfgang Pauli", "wpauli@example.com");
    }

    public void testSearchForSpecificUsersByUsernameInApacheDS154() throws IOException {
        BrowsePrincipalsTest.restoreLdif();
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.setTextField("search", "aeinstein");
        this.submit();
        this.assertUserInTable("aeinstein", "Albert Einstein", "aeinstein@example.com");
        this.assertUserNotInTable("mplanck", "Max Planck", "mplanck@example.com");
    }

    public void testSearchForSpecificUsersByEmailInApacheDS154() throws IOException {
        BrowsePrincipalsTest.restoreLdif();
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.setTextField("search", "@example.com");
        this.submit();
        this.assertUserInTable("aeinstein", "Albert Einstein", "aeinstein@example.com");
        this.assertUserInTable("mplanck", "Max Planck", "mplanck@example.com");
        this.assertUserInTable("nbohr", "Neils Bohr", "nbohr@example.com");
        this.assertUserInTable("mborn", "Max Born", "mborn@example.com");
        this.assertUserInTable("wpauli", "Wolfgang Pauli", "wpauli@example.com");
        this.assertUserInTable("mcurie", "Marie Curie", "mcurie@example.com");
    }

    public void testSearchForSpecificUsersByUsernameInInternalDirectory() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.setTextField("search", "admin");
        this.submit();
        this.assertUserInTable("admin", "Justin Koke", "admin@test.org");
        this.assertUserNotInTable("justin", "Justin Koke", "justin@test.org");
    }

    public void testSearchForSpecificUsersByEmailInInternalDirectory() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.setTextField("search", "admin@test.org");
        this.submit();
        this.assertUserInTable("admin", "Justin Koke", "admin@test.org");
        this.assertUserNotInTable("justin", "Justin Koke", "justin@test.org");
    }

    public void testSearchForInactiveUsersWithNoSearchText() {
        this.restoreCrowdFromXML("authenticationtest.xml");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.selectOption("active", "Inactive");
        this.submit();
        this.assertUserInTable("inactive", "Inactive User", "inactive@example.com");
        this.assertUserNotInTable("user", "Test User", "user@example.com");
        this.assertUserNotInTable("admin", "Shihab Hamid", "shihab@gmai.com");
    }

    public void testSearchForActiveUsersWithSearchText() {
        this.restoreCrowdFromXML("authenticationtest.xml");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.selectOption("active", "Active");
        this.setTextField("search", "user");
        this.submit();
        this.assertUserInTable("user", "Test User", "user@example.com");
        this.assertUserNotInTable("inactive", "Inactive User", "inactive@example.com");
        this.assertUserNotInTable("admin", "Shihab Hamid", "shihab@gmai.com");
    }

    public void testNoDirectoryIsSelectedByDefault() {
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
    }

    public void testDirectorySelectionIsSaved() {
        this.gotoBrowsePrincipals();
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", "Second Directory");
    }

    public void testNonExistingDirectorySelection() {
        this.intendToModifyData();
        this.gotoBrowsePrincipals();
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
        this.assertWarningAndErrorNotPresent();
    }

    public void testOnlyDirectoryIsSelected() {
        this.intendToModifyData();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Apache DS 1.5.4");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", "Test Internal Directory");
    }
}

