/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class BrowseApplicationsTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("googletest.xml");
    }

    public void testBrowseApplications() {
        this.log("Running testBrowseApplications");
        this.gotoBrowseApplications();
        this.assertTextInTable("application-table", new String[]{"crowd", "Crowd Console"});
        this.assertTextInTable("application-table", new String[]{"crowd-openid-server", "CrowdID OpenID Provider"});
        this.assertTextInTable("application-table", new String[]{"demo", "Crowd Demo Application"});
        this.assertTextInTable("application-table", new String[]{"google-apps", "Google Applications Connector"});
    }

    public void testBrowseApplicationsSearchIncludesMinimalParametersInRequestUrl() {
        this.gotoBrowseApplications();
        this.setTextField("name", "zzz");
        this.selectOption("active", "Active");
        this.selectOption("resultsPerPage", "50");
        this.submit();
        URL url = this.getTestingEngine().getPageURL();
        Assert.assertThat((Object)Splitter.on((String)"&").split((CharSequence)url.getQuery()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name=zzz", "active=true", "resultsPerPage=50"}));
    }

    public void testBrowseApplicationSearchUsersReturnsMappedUsers() {
        this.gotoBrowseApplications();
        this.clickLinkWithExactText("crowd");
        this.clickLink("application-users");
        this.submit();
        List<String> usernames = this.scrapeTable("user-details", (List<String>)ImmutableList.of((Object)"Name", (Object)"Details"), new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
        Assert.assertThat(usernames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Super User", "test user"}));
    }

    public void testBrowseApplicationSearchUsersIncludesMinimalParametersInRequestUrl() {
        this.gotoBrowseApplications();
        this.clickLinkWithExactText("crowd");
        this.clickLink("application-users");
        this.setTextField("search", "000");
        this.submit();
        URL url = this.getTestingEngine().getPageURL();
        Assert.assertThat((Object)Splitter.on((String)"&").split((CharSequence)url.getQuery()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"search=000", "ID=98305"}));
    }
}

