/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class BackupRestoreTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
    }

    public void testRestoreWithNoFileName() {
        this.gotoRestore();
        this.submit();
        this.assertFieldErrorPresentWithKey("administration.restore.filePath.error");
    }

    public void testRestoreUTF8BasedFile() {
        this.gotoRestore();
        this.restoreCrowdFromXML("utf8test.xml");
        this._loginAdminUser();
    }

    public void testRestoreValidationFailWithDuplicateMixedCaseGroups() {
        this.gotoRestore();
        this.restoreCrowdFromXMLWithoutReloggingIn("restorevalidationfail.xml", false);
        this.assertTextPresent("XML file failed validation: Could not add role with name 'cRoWd-aDminisTraTorS' as it matches another group name in the same directory");
    }

    public void testRestoreInvalidData() {
        this.gotoRestore();
        this.getTester().setIgnoreFailingStatusCodes(true);
        this.restoreCrowdFromXMLWithoutReloggingIn("invalidimportdata.xml", false);
        this.getTester().setIgnoreFailingStatusCodes(false);
        this.assertKeyPresent("error.import.remove");
        this.clickLink("remove-errors");
        this._loginAdminUser();
    }

    public void testRestoreMixedCaseData() {
        this.gotoRestore();
        this.restoreCrowdFromXML("mixedcase.xml");
        this._loginAdminUser();
        this.gotoViewPrincipal("mixedcase", "Test Internal Directory");
        this.assertTextPresent("MixedCase");
        this.assertLinkPresent("viewgroup-MixedGroup-Test Internal Directory");
        this.gotoViewGroup("MixedGroup", "Test Internal Directory");
        this.assertTextPresent("MixedGroup");
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-users", new String[]{"MixedCase", "mixed@atlassian.com", "true"});
    }

    public void testBackupWithNoFileName() {
        this.gotoBackup();
        this.setTextField("exportFileName", "");
        this.submit();
        this.assertFieldErrorPresentWithKey("administration.backup.fileName.error");
    }

    public void testBackupWithInvalidFileName() {
        this.gotoBackup();
        this.setTextField("exportFileName", "../blah.xml");
        this.submit();
        this.assertFieldErrorPresentWithKey("administration.backup.fileName.error");
        this.gotoBackup();
        this.setTextField("exportFileName", "\\blah.xml");
        this.submit();
        this.assertFieldErrorPresentWithKey("administration.backup.fileName.error");
    }

    public void testBackupPrepopulatesWithDefaultFileName() {
        this.gotoBackup();
        String backupFileName = this.getTester().getTestingEngine().getTextFieldValue("exportFileName");
        BackupRestoreTest.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)backupFileName));
        BackupRestoreTest.assertTrue((boolean)backupFileName.startsWith("atlassian-crowd-"));
    }

    public void testBackupSuccessful() {
        String backupFileName = "BackupRestoreTest_TempBackupFile.xml";
        String backupFilePath = this.getCrowdHome() + File.separator + "backups" + File.separator + backupFileName;
        this.gotoBackup();
        this.setTextField("exportFileName", backupFileName);
        this.submit();
        this.assertTextPresent("Crowd has successfully backed up to " + backupFilePath);
        File fileLocation = new File(backupFilePath);
        BackupRestoreTest.assertTrue((boolean)fileLocation.exists());
        BackupRestoreTest.assertTrue((boolean)fileLocation.delete());
    }
}

