/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.application.ApplicationType;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jwebunit.api.IElement;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class AddApplicationTest
extends CrowdAcceptanceTestCase {
    private static final String APPLICATION_NAME = "Acceptance Test Application";
    private static final String IP_ADDRESS = "127.0.0.1";
    private static final String CIDR_ADDRESS = "127.0.0.1/16";
    private static final String MEMBERSHIP_AGGREGATION_CHECKBOX = "membershipAggregationEnabled";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this._loginAdminUser();
        this.restoreBaseSetup();
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testAddApplicationWithNoDetails() {
        this.log("Running testAddApplicationWithNoDetails");
        this.gotoAddApplication();
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.setTextField("password", "");
        this.setTextField("passwordConfirmation", "");
        this.selectOptionByValue("applicationType", "");
        this.submit();
        this.assertKeyPresent("application.name.invalid");
        this.assertKeyPresent("invalid.mustsupplyapassword");
        this.assertKeyPresent("application.type.invalid");
    }

    public void testAddApplicationThatAlreadyExists() {
        this.log("Running testAddApplicationThatExists");
        this.gotoAddApplication();
        this.setTextField("name", "crowd");
        this.setTextField("description", "Duplicated Crowd web app");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirmation", "password");
        this.selectOption("applicationType", ApplicationType.JIRA.getDisplayName());
        this.submit();
        this.assertKeyPresent("invalid.namealreadyexist.application");
    }

    public void testPasswordMatchError() {
        this.log("Running testPasswordMatchError");
        this.gotoAddApplication();
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.setTextField("password", "password1");
        this.setTextField("passwordConfirmation", "password2");
        this.selectOption("applicationType", ApplicationType.JIRA.getDisplayName());
        this.submit();
        this.assertKeyPresent("invalid.passwordmismatch");
    }

    public void testAddApplicationIPNotation() {
        this.intendToModifyData();
        this._testAddApplicationDetails();
        this._testAddApplicationConnectionDetailsIPNotation();
        this._testAddApplicationDirectoryDetailsShowDescriptiveNames();
        this._testAddApplicationDirectoriesDetails();
        this._testAddApplicationAuthorisationDetails();
        this._testAddApplicationConfirmationDetails(IP_ADDRESS);
    }

    public void testAddApplicationCIDRNotation() {
        this.intendToModifyData();
        this._testAddApplicationDetails();
        this._testAddApplicationConnectionDetailsCIDRNotation();
        this._testAddApplicationDirectoryDetailsShowDescriptiveNames();
        this._testAddApplicationDirectoriesDetails();
        this._testAddApplicationAuthorisationDetails();
        this._testAddApplicationConfirmationDetails(CIDR_ADDRESS);
    }

    public void testMembershipAggregationDefaultIsFalse() {
        this.gotoCreateDirectory();
        this.submit();
        this.setTextField("name", "second");
        this.submit();
        this.testAddApplicationIPNotation();
        this.gotoViewApplicationDirectories("crowd");
        this.assertTextInElement("application-name", "crowd");
        this.assertCheckboxPresent(MEMBERSHIP_AGGREGATION_CHECKBOX);
        this.assertCheckboxNotSelected(MEMBERSHIP_AGGREGATION_CHECKBOX);
    }

    private void _testAddApplicationDetails() {
        this.log("Running testAddApplicationDetails");
        this.gotoAddApplication();
        this.setTextField("name", APPLICATION_NAME);
        this.setTextField("description", "Application for the Acceptance Test Harness");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirmation", "password");
        this.selectOption("applicationType", ApplicationType.GENERIC_APPLICATION.getDisplayName());
        this.submit();
        this.assertTextPresent(IdentifierUtils.toLowerCase((String)APPLICATION_NAME));
    }

    private void _testAddApplicationConnectionDetailsIPNotation() {
        this.log("Running testAddApplicationConnectionDetailsIPNotation");
        this.setTextField("applicationURL", "");
        this.setTextField("remoteIPAddress", "");
        this.submit();
        this.assertKeyPresent("application.url.invalid");
        this.assertKeyPresent("application.remoteipaddress.invalid");
        this.setTextField("applicationURL", "this is not a URL");
        this.setTextField("remoteIPAddress", "1234567895z");
        this.submit();
        this.assertKeyPresent("application.remoteipaddress.invalid");
        this.assertKeyPresent("application.url.invalid");
        this.setTextField("applicationURL", "http://crowd.atlassian.com");
        this.setTextField("remoteIPAddress", IP_ADDRESS);
        this.submit();
    }

    private void _testAddApplicationConnectionDetailsCIDRNotation() {
        this.log("Running testAddApplicationDetailsCIDRNotation");
        this.setTextField("applicationURL", "http://crowd.atlassian.com");
        this.setTextField("remoteIPAddress", CIDR_ADDRESS);
        this.submit();
    }

    private void _testAddApplicationDirectoryDetailsShowDescriptiveNames() {
        List fieldDescriptions = this.getElementsByXPath("//input[@type = 'checkbox' and @name = 'selecteddirectories']/following-sibling::div");
        Assert.assertThat((Object)fieldDescriptions, (Matcher)Matchers.hasItem(AddApplicationTest.elementWithTrimmedText("Crowd Internal Directory")));
    }

    private static Matcher<IElement> elementWithTrimmedText(String s) {
        return new FeatureMatcher<IElement, String>(Matchers.equalTo((Object)s), "IElement with trimmed text content", "trimmed text content"){

            protected String featureValueOf(IElement actual) {
                return actual.getTextContent().trim();
            }
        };
    }

    private void _testAddApplicationDirectoriesDetails() {
        this.log("Running testAddApplicationDirectoriesDetails");
        this.submit();
        this.assertKeyPresent("application.directories.invalid", Arrays.asList(IdentifierUtils.toLowerCase((String)APPLICATION_NAME)));
        this.checkCheckbox("selecteddirectories");
        this.submit();
    }

    private void _testAddApplicationAuthorisationDetails() {
        this.log("Running testAddApplicationAuthorisationDetails");
        this.selectOption("addgrouptodirectory-23", "crowd-administrators");
        this.clickButton("add-group-23");
        this.submit();
    }

    private void _testAddApplicationConfirmationDetails(String remoteAddress) {
        this.log("Running testAddApplicationConfirmationDetails");
        this.assertTextPresent(IdentifierUtils.toLowerCase((String)APPLICATION_NAME));
        this.assertTextPresent(ApplicationType.GENERIC_APPLICATION.getDisplayName());
        this.assertTextPresent("http://crowd.atlassian.com");
        this.assertTextPresent(remoteAddress);
        this.assertTextPresent("crowd-administrators");
        this.submit();
        this.assertTitleMatch(this.getMessage("menu.viewapplication.label"));
        this.assertTextPresent(IdentifierUtils.toLowerCase((String)APPLICATION_NAME));
    }
}

