/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.administration;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jwebunit.html.Cell;
import net.sourceforge.jwebunit.html.Row;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;

public class LoggingProfilingTest
extends CrowdAcceptanceTestCase {
    public void testRevertToDefaultReturnsLogLevelsToKnownState() {
        this.restoreBaseSetup();
        this.intendToModifyData();
        this._loginAdminUser();
        this.gotoLoggingProfiling();
        this.clickButton("revertToDefault");
        Map<String, String> initialLevels = this.getCurrentLevels();
        Assert.assertThat(initialLevels.keySet(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"root", "com.atlassian.crowd", "com.atlassian.crowd.startup", "com.atlassian.crowd.license"}));
        Assert.assertThat((String)"No default levels are FATAL", initialLevels.values(), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.not((Matcher)IsEqual.equalTo((Object)"FATAL"))));
        this.setWorkingForm("logging");
        for (int i = 0; i < initialLevels.size(); ++i) {
            this.selectOption("levelNames", i, "FATAL");
        }
        this.submit("updateLogging");
        Map<String, String> levels = this.getCurrentLevels();
        LoggingProfilingTest.assertEquals(initialLevels.keySet(), levels.keySet());
        Assert.assertThat(levels.values(), (Matcher)CoreMatchers.everyItem((Matcher)IsEqual.equalTo((Object)"FATAL")));
        this.clickButton("revertToDefault");
        LoggingProfilingTest.assertEquals((String)"Levels after Revert to Default match initial levels", initialLevels, this.getCurrentLevels());
    }

    Map<String, String> getCurrentLevels() {
        HashMap<String, String> levels = new HashMap<String, String>();
        List rows = this.getTable("loglevelTable").getRows();
        Row header = (Row)rows.get(0);
        LoggingProfilingTest.assertEquals((int)3, (int)header.getCells().size());
        LoggingProfilingTest.assertEquals((String)this.getText("loglevel.packageHeading"), (String)((Cell)header.getCells().get(0)).getValue());
        LoggingProfilingTest.assertEquals((String)this.getText("loglevel.currentLevelHeading"), (String)((Cell)header.getCells().get(1)).getValue());
        LoggingProfilingTest.assertEquals((String)this.getText("loglevel.newLevelHeading"), (String)((Cell)header.getCells().get(2)).getValue());
        for (Row r : rows.subList(1, rows.size())) {
            List cells = r.getCells();
            LoggingProfilingTest.assertNull((Object)levels.put(((Cell)cells.get(0)).getValue(), ((Cell)cells.get(1)).getValue()));
        }
        return levels;
    }
}

