/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests;

import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.CrowdWebTestCase;
import com.atlassian.crowd.acceptance.utils.PropertyUtils;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.CrowdClient;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import junit.framework.AssertionFailedError;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.text.IsEmptyString;
import org.junit.Assert;

public abstract class ApplicationAcceptanceTestCase
extends CrowdWebTestCase {
    protected static final String CROWD_ADMIN_USER = "admin";
    protected static final String CROWD_ADMIN_EMAIL_ADDRESS = "admin@example.com";
    protected static final String CROWD_ADMIN_FULLNAME = "Super User";
    protected static final String ADMIN_PW = "admin";
    protected String baseUrl;
    protected Properties specProperties;
    protected CrowdAcceptanceTestCase crowdConsole;
    protected String crowdBaseUrl;
    protected String crowdResourceBundle;
    protected static final String CROWD_ADMINISTRATORS_GROUP = "crowd-administrators";

    protected void setUp() throws Exception {
        super.setUp();
        this.i18n = ResourceBundle.getBundle(this.getResourceBundleName());
        this.specProperties = AcceptanceTestHelper.loadProperties(this.getLocalTestPropertiesFileName());
        BaseUrlFromProperties bufp = new BaseUrlFromProperties(this.specProperties);
        this.baseUrl = bufp.baseUrlFor(this.getApplicationName());
        this.getTestContext().setBaseUrl(this.baseUrl);
        this.setScriptingEnabled(false);
        this.beginAt(this.baseUrl);
        this.crowdBaseUrl = bufp.baseUrlFor("crowd");
        this.crowdConsole = new CrowdAcceptanceTestCase();
        this.crowdConsole.setTester(this.getTester());
        this.crowdConsole.setUp();
        this.crowdResourceBundle = "com.atlassian.crowd.console.action.BaseAction";
        this.useApp();
        this.log("Running: " + ((Object)((Object)this)).getClass().getSimpleName() + " - " + this.getName());
    }

    protected void tearDown() throws Exception {
        this.crowdConsole.tearDown();
        this.crowdConsole = null;
        super.tearDown();
    }

    protected String getTestProperty(String propName) {
        if (System.getProperty("acceptance.test." + propName) != null) {
            return System.getProperty("acceptance.test." + propName);
        }
        if (this.specProperties.getProperty(propName) != null) {
            return this.specProperties.getProperty(propName);
        }
        return "";
    }

    protected void useCrowd() {
        this.getTestContext().setBaseUrl(this.crowdBaseUrl);
        this.getTestContext().setResourceBundleName(this.crowdResourceBundle);
    }

    protected void useApp() {
        this.getTestContext().setBaseUrl(this.baseUrl);
        this.getTestContext().setResourceBundleName(this.getResourceBundleName());
    }

    public void restoreBaseSetup() {
        this.restoreCrowdFromXML("basesetup.xml");
    }

    public void intendToModifyData() {
        this.useCrowd();
        this.crowdConsole.intendToModifyData();
        this.useApp();
    }

    public void restoreCrowdFromXML(String xmlFilename) {
        this.useCrowd();
        this.crowdConsole.restoreCrowdFromXML(xmlFilename);
        this.useApp();
    }

    protected void logoutFromCrowd() {
        this.useCrowd();
        this.crowdConsole._logout();
        this.useApp();
    }

    protected void loginToCrowd() {
        this.useCrowd();
        this.crowdConsole._logout();
        this.crowdConsole.assertKeyPresent("login.verb");
        this.crowdConsole.setTextField("j_username", "admin");
        this.crowdConsole.setTextField("j_password", "admin");
        this.crowdConsole.submit();
        this.crowdConsole.assertIsLoggedIn();
        this.useApp();
    }

    public String getCrowdHome() {
        String crowdHome = System.getProperty("crowd.home");
        if (crowdHome == null) {
            return System.getProperty("java.io.tmp");
        }
        return crowdHome;
    }

    protected abstract String getResourceBundleName();

    protected abstract String getApplicationName();

    protected abstract String getLocalTestPropertiesFileName();

    protected void verifyUserExistsInCrowd(String username, String firstname, String lastname, String email, String ... groupNames) throws IOException, CrowdException, ApplicationPermissionException {
        CrowdClient client = this.getCrowdClient();
        User user = client.getUser(username);
        ApplicationAcceptanceTestCase.assertEquals((String)username, (String)user.getName());
        ApplicationAcceptanceTestCase.assertEquals((String)(firstname + " " + lastname), (String)user.getDisplayName());
        ApplicationAcceptanceTestCase.assertEquals((String)email, (String)user.getEmailAddress());
        ApplicationAcceptanceTestCase.assertTrue((boolean)user.isActive());
        List groups = client.getNamesOfGroupsForUser(username, 0, -1);
        Assert.assertThat((Object)groups, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])groupNames));
    }

    protected void verifyUserDoesNotExistInCrowd(String username, String firstname, String lastname, String email, String ... groupNames) throws IOException, CrowdException, ApplicationPermissionException {
        CrowdClient client = this.getCrowdClient();
        try {
            client.getUser(username);
            ApplicationAcceptanceTestCase.fail((String)("User '" + username + "' should not exist"));
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
    }

    protected void verifyGroupExistsInCrowd(String groupName, String ... memberNames) throws IOException, CrowdException, ApplicationPermissionException {
        CrowdClient client = this.getCrowdClient();
        Group group = client.getGroup(groupName);
        ApplicationAcceptanceTestCase.assertEquals((String)groupName, (String)group.getName());
        Assert.assertThat((Object)group.getDescription(), (Matcher)IsEmptyString.isEmptyOrNullString());
        ApplicationAcceptanceTestCase.assertTrue((boolean)group.isActive());
        Assert.assertThat((Object)client.getNamesOfUsersOfGroup(groupName, 0, -1), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])memberNames));
    }

    protected void verifyGroupDoesNotExistInCrowd(String groupName) throws IOException, CrowdException, ApplicationPermissionException {
        CrowdClient client = this.getCrowdClient();
        try {
            client.getGroup(groupName);
            ApplicationAcceptanceTestCase.fail((String)("Group '" + groupName + "' should not exist"));
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    protected void verifyGroupDoesNotExistInCrowdWithCaseSensitiveName(String groupName) throws IOException, CrowdException, ApplicationPermissionException {
        CrowdClient client = this.getCrowdClient();
        try {
            Group group = client.getGroup(groupName);
            Assert.assertThat((Object)group.getName(), (Matcher)CoreMatchers.not((Object)groupName));
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCurrentlyLoggedInCrowdUserFullName() {
        this.useCrowd();
        this.crowdConsole.gotoPage("/console");
        try {
            String string = this.crowdConsole.getElementTextById("userFullName");
            return string;
        }
        catch (AssertionFailedError e) {
            String string = null;
            return string;
        }
        finally {
            this.useApp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loginToCrowd(String username, String password) {
        this.useCrowd();
        this.crowdConsole._logout();
        this.crowdConsole.assertKeyPresent("login.verb");
        this.crowdConsole.setTextField("j_username", username);
        this.crowdConsole.setTextField("j_password", password);
        this.crowdConsole.submit();
        try {
            this.crowdConsole.assertIsLoggedIn();
            String string = this.crowdConsole.getElementTextById("userFullName");
            return string;
        }
        catch (AssertionFailedError e) {
            String string = null;
            return string;
        }
        finally {
            this.useApp();
        }
    }

    CrowdClient getCrowdClient() throws IOException {
        String home = System.getProperty("crowd.home");
        ApplicationAcceptanceTestCase.assertNotNull((Object)home);
        File propsFile = new File(home, "crowd.properties");
        return new RestCrowdClientFactory().newInstance((ClientProperties)ClientPropertiesImpl.newInstanceFromProperties((Properties)PropertyUtils.getPropertiesFromFile(propsFile)));
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

