/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.soap;

import com.atlassian.crowd.acceptance.tests.soap.InformationLeakingTestBase;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SoapXmlParsingTest
extends InformationLeakingTestBase {
    PostMethod postToSoapEndpoint(String content, String pathSuffix) throws HttpException, IOException {
        String endpoint = this.getBaseUrl() + "/services" + pathSuffix;
        HttpClient client = new HttpClient();
        PostMethod m = new PostMethod(endpoint);
        m.setRequestEntity((RequestEntity)new StringRequestEntity(content, "application/soap+xml", "us-ascii"));
        client.executeMethod((HttpMethod)m);
        return m;
    }

    PostMethod postToSoapEndpoint(String content) throws HttpException, IOException {
        return this.postToSoapEndpoint(content, "");
    }

    public void testEntityExpansionDoesNotIncludeFileContents() throws IOException {
        this.runEntityExpansionTestWithPathSuffix("");
    }

    private void runEntityExpansionTestWithPathSuffix(String pathSuffix) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("SoapXmlParsingTest-soap-include-external-entity.xml");
        SoapXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        contents = contents.replace("/etc/passwd", this.createSecretFile().toURI().toString());
        PostMethod m = this.postToSoapEndpoint(contents, pathSuffix);
        MediaType mt = MediaType.valueOf((String)m.getResponseHeader("content-type").getValue());
        Assert.assertThat((String)"The response should be XML", (Object)(mt.getType() + '/' + mt.getSubtype()), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)"text/xml"), (Matcher)CoreMatchers.is((Object)"application/xml"), (Matcher)CoreMatchers.is((Object)"application/soap+xml")));
        String resp = IOUtils.toString((InputStream)m.getResponseBodyAsStream(), (String)"us-ascii");
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.secret)));
    }

    public void testValidEntitiesAreExpanded() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("SoapXmlParsingTest-soap-with-amp-entity.xml");
        SoapXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        PostMethod m = this.postToSoapEndpoint(contents);
        MediaType mt = MediaType.valueOf((String)m.getResponseHeader("content-type").getValue());
        Assert.assertThat((String)"The response should be XML", (Object)(mt.getType() + '/' + mt.getSubtype()), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)"text/xml"), (Matcher)CoreMatchers.is((Object)"application/xml"), (Matcher)CoreMatchers.is((Object)"application/soap+xml")));
        String resp = IOUtils.toString((InputStream)m.getResponseBodyAsStream(), (String)"us-ascii");
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.containsString((String)"<faultstring>&amp;</faultstring>"));
    }

    public void testEntityExpansionDoesNotCauseDenialOfService() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("SoapXmlParsingTest-soap-billion-laughs.xml");
        SoapXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        PostMethod m = this.postToSoapEndpoint(contents);
        String resp = IOUtils.toString((InputStream)m.getResponseBodyAsStream(), (String)"us-ascii");
        Assert.assertThat((String)"The response should not indicate a server memory error", (Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"java.lang.OutOfMemoryError")));
        MediaType mt = MediaType.valueOf((String)m.getResponseHeader("content-type").getValue());
        Assert.assertThat((String)"The response should be XML, not HTML", (Object)(mt.getType() + '/' + mt.getSubtype()), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)"text/xml"), (Matcher)CoreMatchers.is((Object)"application/xml"), (Matcher)CoreMatchers.is((Object)"application/soap+xml")));
    }

    public void testVersionedEndpointsDoNotAllowExpansion() throws IOException {
        String[] versions;
        for (String v : versions = new String[]{"1", "2", "latest"}) {
            this.runEntityExpansionTestWithPathSuffix("/" + v + "/");
        }
    }
}

