/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.util.hibernate;

import com.atlassian.crowd.util.persistence.hibernate.MappingResources;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class MappingResourcesTest {
    private MappingResources mappingResources;

    @Before
    public void setUp() throws Exception {
        this.mappingResources = new MappingResources();
    }

    @Test
    public void testGetMappings() throws Exception {
        this.mappingResources.setConfigLocation((Resource)new ClassPathResource("hibernate.cfg.xml"));
        this.mappingResources.afterPropertiesSet();
        MatcherAssert.assertThat((Object)this.mappingResources.getMappings(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"com/atlassian/crowd/model/CustomTypes.hbm.xml", "com/atlassian/crowd/model/alias/Alias.hbm.xml", "com/atlassian/crowd/model/application/Application.hbm.xml", "com/atlassian/crowd/model/directory/Directory.hbm.xml", "com/atlassian/crowd/model/group/InternalGroup.hbm.xml", "com/atlassian/crowd/model/membership/InternalMembership.hbm.xml", "com/atlassian/crowd/model/property/Property.hbm.xml", "com/atlassian/crowd/model/token/Token.hbm.xml", "com/atlassian/crowd/model/user/InternalUser.hbm.xml", "com/atlassian/crowd/model/webhook/Webhook.hbm.xml"}));
    }

    @Test
    public void testGetMappingsAsArray() throws Exception {
        this.mappingResources.setConfigLocation((Resource)new ClassPathResource("hibernate.cfg.xml"));
        this.mappingResources.afterPropertiesSet();
        MatcherAssert.assertThat(Arrays.asList(this.mappingResources.getMappingsAsArray()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"com/atlassian/crowd/model/CustomTypes.hbm.xml", "com/atlassian/crowd/model/alias/Alias.hbm.xml", "com/atlassian/crowd/model/application/Application.hbm.xml", "com/atlassian/crowd/model/directory/Directory.hbm.xml", "com/atlassian/crowd/model/group/InternalGroup.hbm.xml", "com/atlassian/crowd/model/membership/InternalMembership.hbm.xml", "com/atlassian/crowd/model/property/Property.hbm.xml", "com/atlassian/crowd/model/token/Token.hbm.xml", "com/atlassian/crowd/model/user/InternalUser.hbm.xml", "com/atlassian/crowd/model/webhook/Webhook.hbm.xml"}));
    }

    @Test
    public void testGetTableNames() throws Exception {
        this.mappingResources.setConfigLocation((Resource)new ClassPathResource("hibernate.cfg.xml"));
        this.mappingResources.afterPropertiesSet();
        MatcherAssert.assertThat((Object)this.mappingResources.getTableNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"cwd_app_dir_group_mapping", "cwd_app_dir_mapping", "cwd_app_dir_operation", "cwd_application", "cwd_application_address", "cwd_application_alias", "cwd_application_attribute", "cwd_directory", "cwd_directory_attribute", "cwd_directory_operation", "cwd_group", "cwd_group_attribute", "cwd_membership", "cwd_property", "cwd_token", "cwd_user", "cwd_user_attribute", "cwd_user_credential_record", "cwd_webhook"}));
    }
}

