/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.migration;

import com.atlassian.crowd.acceptance.tests.persistence.migration.AbstractDaoIntegrationTest;
import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.dao.token.TokenDAOHibernate;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.persistence.hibernate.SchemaHelper;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-schemahelper-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class, DirtiesContextTestExecutionListener.class})
@TransactionConfiguration(defaultRollback=true)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class SchemaUpgradeIntegrationTest
extends AbstractDaoIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUpgradeIntegrationTest.class);
    private static final String REFERENCE_DATABASE_SCRIPT = "database-crowd-2.1.sql";
    private static final long EXISTING_APPLICATION_ID = 163841L;
    private static final long EXISTING_DIRECTORY_ID = 2L;
    private static final String EXISTING_GROUP_NAME = "badgers";
    private static final String EXISTING_USER_NAME = "penny";
    @Inject
    private SchemaHelper schemaHelper;
    @Inject
    private DataSource dataSource;
    @Inject
    private TokenDAOHibernate tokenDao;
    @Inject
    private ApplicationDAO applicationDao;
    @Inject
    private UserDao userDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private MembershipDao membershipDao;
    @Inject
    private AliasDAO aliasDao;
    @Inject
    private PropertyDAO propertyDao;
    @Inject
    private DirectoryDao directoryDao;

    @BeforeTransaction
    public void restoreDatabaseAndUpgradeSchema() throws Exception {
        logger.info("Restoring database");
        Assert.assertNotNull((String)"Data source must have been injected", (Object)this.dataSource);
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        ClassPathResource resource = new ClassPathResource(REFERENCE_DATABASE_SCRIPT);
        JdbcTestUtils.executeSqlScript((JdbcTemplate)template, (Resource)resource, (boolean)false);
        logger.info("Database restored");
        logger.info("Updating schema");
        this.schemaHelper.updateSchemaIfNeeded(true);
        logger.info("Schema updated");
    }

    @Test
    @Transactional
    public void existingDataIsPreservedBySchemaUpgradeAndNewDataCanBeInserted() throws Exception {
        this._testDirectoryDaoCanReadExistingData();
        this._testUserDaoCanReadExistingData();
        this._testGroupDaoCanReadExistingData();
        this._testMembershipDaoCanReadExistingData();
        this._testApplicationDaoCanReadExistingData();
        this._testAliasDaoCanReadExistingData();
        this._testTokenDaoCanReadExistingData();
        this._testPropertyDaoCanReadExistingData();
        this._testDirectoryDaoCanInsert();
        this._testUserDaoCanInsert();
        this._testGroupDaoCanInsert();
        this._testMembershipDaoCanInsert();
        this._testApplicationDaoCanInsert();
        this._testAliasDaoCanInsert();
        this._testTokenDaoCanInsert();
        this._testPropertyDaoCanInsert();
    }

    private void _testAliasDaoCanReadExistingData() throws Exception {
        Assert.assertThat((Object)this.aliasDao.findUsernameByAlias(this.applicationDao.findById(163841L), "pen"), (Matcher)Is.is((Object)EXISTING_USER_NAME));
    }

    private void _testDirectoryDaoCanReadExistingData() throws Exception {
        Assert.assertThat((Object)this.directoryDao.findAll(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)this.directoryDao.findById(2L).getName(), (Matcher)Is.is((Object)"Directory One"));
    }

    private void _testApplicationDaoCanReadExistingData() throws Exception {
        EntityQuery allApplicationsQuery = QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).returningAtMost(-1);
        Assert.assertThat((Object)this.applicationDao.search(allApplicationsQuery), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertNotNull((String)"There should exist a directory mapping for existing application", (Object)this.applicationDao.findById(163841L).getDirectoryMapping(1L));
        Assert.assertThat((Object)this.applicationDao.findById(163841L).getRemoteAddresses(), (Matcher)IsCollectionWithSize.hasSize((int)4));
    }

    private void _testTokenDaoCanReadExistingData() {
        EntityQuery allTokensQuery = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(-1);
        Assert.assertThat((Object)this.tokenDao.search(allTokensQuery), (Matcher)IsCollectionWithSize.hasSize((int)3));
    }

    private void _testUserDaoCanReadExistingData() throws Exception {
        EntityQuery allUsersQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        Assert.assertThat((Object)this.userDao.search(2L, allUsersQuery), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)this.userDao.findByNameWithAttributes(2L, "eeeep").getKeys(), (Matcher)IsCollectionWithSize.hasSize((int)4));
    }

    private void _testGroupDaoCanReadExistingData() throws Exception {
        EntityQuery allGroupsQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        Assert.assertThat((Object)this.groupDao.search(2L, allGroupsQuery), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)this.groupDao.findByName(2L, EXISTING_GROUP_NAME).isLocal(), (Matcher)Is.is((Object)false));
    }

    private void _testMembershipDaoCanReadExistingData() throws Exception {
        MembershipQuery allMembershipsQuery = QueryBuilder.createMembershipQuery((int)1000, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.user(), User.class, (EntityDescriptor)EntityDescriptor.group(), (String)EXISTING_GROUP_NAME);
        Assert.assertThat((Object)this.membershipDao.search(2L, allMembershipsQuery), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    private void _testPropertyDaoCanReadExistingData() throws Exception {
        Assert.assertThat((Object)this.getPropertyDao().findAll(), (Matcher)IsCollectionWithSize.hasSize((int)27));
        Assert.assertThat((Object)this.getPropertyDao().find("crowd", "build.number").getValue(), (Matcher)Is.is((Object)"431"));
    }

    @Override
    public TokenDAOHibernate getTokenDao() {
        return this.tokenDao;
    }

    @Override
    public ApplicationDAO getApplicationDao() {
        return this.applicationDao;
    }

    @Override
    public UserDao getUserDao() {
        return this.userDao;
    }

    @Override
    public GroupDao getGroupDao() {
        return this.groupDao;
    }

    @Override
    public MembershipDao getMembershipDao() {
        return this.membershipDao;
    }

    @Override
    public AliasDAO getAliasDao() {
        return this.aliasDao;
    }

    @Override
    public PropertyDAO getPropertyDao() {
        return this.propertyDao;
    }

    @Override
    public DirectoryDao getDirectoryDao() {
        return this.directoryDao;
    }
}

