/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.migration;

import com.atlassian.crowd.acceptance.tests.persistence.migration.AbstractDaoIntegrationTest;
import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.dao.token.TokenDAOHibernate;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.util.persistence.hibernate.SchemaHelper;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-schemahelper-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, TransactionalTestExecutionListener.class, DirtiesContextTestExecutionListener.class})
@TransactionConfiguration(defaultRollback=true)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class SchemaCreationIntegrationTest
extends AbstractDaoIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(SchemaCreationIntegrationTest.class);
    @Inject
    private SchemaHelper schemaHelper;
    @Inject
    private DataSource dataSource;
    @Inject
    private TokenDAOHibernate tokenDao;
    @Inject
    private ApplicationDAO applicationDao;
    @Inject
    private UserDao userDao;
    @Inject
    private GroupDao groupDao;
    @Inject
    private MembershipDao membershipDao;
    @Inject
    private DirectoryDao directoryDao;
    @Inject
    private AliasDAO aliasDao;
    @Inject
    private PropertyDAO propertyDao;

    @BeforeTransaction
    public void createSchema() throws Exception {
        logger.info("Initialising empty database");
        Assert.assertNotNull((String)"Data source must have been injected", (Object)this.dataSource);
        SimpleJdbcTemplate template = new SimpleJdbcTemplate(this.dataSource);
        template.update("DROP SCHEMA PUBLIC CASCADE", new Object[0]);
        logger.info("Database initialised");
        logger.info("Creating schema");
        this.schemaHelper.createSchema();
        logger.info("Schema created");
    }

    @Test
    @Transactional
    public void testDaosCanInsertNewDataAfterSchemaCreation() throws Exception {
        this._testDirectoryDaoCanInsert();
        this._testUserDaoCanInsert();
        this._testGroupDaoCanInsert();
        this._testMembershipDaoCanInsert();
        this._testApplicationDaoCanInsert();
        this._testAliasDaoCanInsert();
        this._testTokenDaoCanInsert();
        this._testPropertyDaoCanInsert();
    }

    @Override
    public TokenDAOHibernate getTokenDao() {
        return this.tokenDao;
    }

    @Override
    public ApplicationDAO getApplicationDao() {
        return this.applicationDao;
    }

    @Override
    public UserDao getUserDao() {
        return this.userDao;
    }

    @Override
    public GroupDao getGroupDao() {
        return this.groupDao;
    }

    @Override
    public MembershipDao getMembershipDao() {
        return this.membershipDao;
    }

    @Override
    public DirectoryDao getDirectoryDao() {
        return this.directoryDao;
    }

    @Override
    public AliasDAO getAliasDao() {
        return this.aliasDao;
    }

    @Override
    public PropertyDAO getPropertyDao() {
        return this.propertyDao;
    }
}

