/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.manager.directory;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.util.List;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-CrowdManagers.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-internaldirectoryloader-config.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class DirectoryManagerGenericNestedGroupsTest {
    private static final long DIRECTORY_ID = 1L;
    private static final String groupName0 = "group-0";
    private static final String groupName1 = "group-1";
    private static final String groupName2 = "group-2";
    private static final String groupName3 = "group-3";
    private static final String groupName4 = "group-4";
    private static final String groupName5 = "group-5";
    private static final String userNameA = "user-a";
    private static final String userNameB = "user-b";
    private static final String userNameC = "user-c";
    private static final String userNameD = "user-d";
    private static final String userNameE = "user-e";
    private static final String userNameF = "user-f";
    private static final String userNameG = "user-g";
    protected final String firstName = "First";
    protected final String surName = "Last";
    protected final String password = "secret-password";
    @Inject
    private DirectoryManager directoryManager;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void onSetUp() throws Exception {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
        this.addUser(userNameA);
        this.addUser(userNameB);
        this.addUser(userNameC);
        this.addUser(userNameD);
        this.addUser(userNameE);
        this.addUser(userNameF);
        this.addUser(userNameG);
        this.addGroup(groupName0);
        this.addGroup(groupName1);
        this.addGroup(groupName2);
        this.addGroup(groupName3);
        this.addGroup(groupName4);
        this.addGroup(groupName5);
        this.directoryManager.addUserToGroup(1L, userNameA, groupName1);
        this.directoryManager.addUserToGroup(1L, userNameB, groupName2);
        this.directoryManager.addUserToGroup(1L, userNameC, groupName3);
        this.directoryManager.addUserToGroup(1L, userNameD, groupName3);
        this.directoryManager.addUserToGroup(1L, userNameE, groupName4);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName1);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName2);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName3);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName5);
        this.directoryManager.addGroupToGroup(1L, groupName1, groupName0);
        this.directoryManager.addGroupToGroup(1L, groupName2, groupName1);
        this.directoryManager.addGroupToGroup(1L, groupName3, groupName2);
        this.directoryManager.addGroupToGroup(1L, groupName1, groupName3);
        this.directoryManager.addGroupToGroup(1L, groupName4, groupName3);
        this.directoryManager.addGroupToGroup(1L, groupName5, groupName4);
    }

    protected void addGroup(String name) throws Exception {
        GroupTemplate group = new GroupTemplate(name, 1L, GroupType.GROUP);
        this.directoryManager.addGroup(1L, group);
    }

    protected void addUser(String name) throws Exception {
        UserTemplate user = new UserTemplate(name, 1L);
        user.setFirstName("Bob");
        user.setLastName("Smith");
        user.setDisplayName("Bob Smith");
        user.setEmailAddress("bsmith@example.com");
        this.directoryManager.addUser(1L, user, new PasswordCredential("password"));
    }

    @Test
    public void testFindDirectoryById() throws Exception {
        Directory directory = this.directoryManager.findDirectoryById(1L);
        Assert.assertEquals((Object)"directory1", (Object)directory.getName());
        Assert.assertEquals((Object)DirectoryType.INTERNAL, (Object)directory.getType());
    }

    @Test
    public void testSearchDirectUserMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameA, userNameF}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameB, userNameF}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameC, userNameD, userNameF}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{userNameE}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{userNameF}));
    }

    @Test
    public void testSearchDirectGroupMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName1}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName2}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName3}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName1, groupName4}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName5}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
    }

    @Test
    public void testSearchDirectGroupMembershipsOfUser() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameA).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName1}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameB).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName2}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameC).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName3}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameD).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName3}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameE).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName4}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameF).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName1, groupName2, groupName3, groupName5}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameG).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
    }

    @Test
    public void testSearchDirectGroupMembershipsOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName3}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName1}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName2}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName3}));
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName4}));
    }

    @Test
    public void testSearchNestedGroupMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName1, groupName2, groupName3, groupName4, groupName5}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName2, groupName3, groupName4, groupName5}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName1, groupName3, groupName4, groupName5}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName1, groupName2, groupName4, groupName5}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{groupName5}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
    }

    @Test
    public void testSearchNestedUserMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameA, userNameB, userNameC, userNameD, userNameE, userNameF}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameA, userNameB, userNameC, userNameD, userNameE, userNameF}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameA, userNameB, userNameC, userNameD, userNameE, userNameF}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameA, userNameB, userNameC, userNameD, userNameE, userNameF}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{userNameE, userNameF}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{userNameF}));
    }

    @Test
    public void testSearchNestedGroupMembershipsOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName3, groupName2}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName3}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3, groupName4}));
    }

    @Test
    public void testSearchNestedGroupMembershipsOfUser() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameA).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameB).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameC).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameD).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameE).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3, groupName4}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameF).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groupName0, groupName1, groupName2, groupName3, groupName4, groupName5}));
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameG).returningAtMost(-1));
        Assert.assertThat((Object)names, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
    }

    @Test
    public void testIsUserDirectGroupMember() throws Exception {
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName4));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName5));
        Assert.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName5));
    }

    @Test
    public void testIsUserNestedGroupMember() throws Exception {
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName4));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName4));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName5));
        Assert.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName5));
    }

    @Test
    public void testIsGroupDirectGroupMember() throws Exception {
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName4));
        Assert.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName5));
    }

    @Test
    public void testIsGroupNestedGroupMember() throws Exception {
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName0));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName0));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName1));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName1));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName2));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName2));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName3));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName3));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName4));
        Assert.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName4));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName5));
        Assert.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName5));
    }

    @Test(expected=MembershipAlreadyExistsException.class)
    public void testAddGroupToGroupWhenMembershipAlreadyExists() throws Exception {
        this.directoryManager.addGroupToGroup(1L, groupName1, groupName0);
    }

    @Test(expected=InvalidMembershipException.class)
    public void testAddGroupToGroupCycleCreationFail() throws Exception {
        this.directoryManager.addGroupToGroup(1L, groupName0, groupName0);
    }

    @Test(expected=InvalidMembershipException.class)
    public void testRemoveGroupFromGroupCycleDeletionFail() throws Exception {
        this.directoryManager.removeGroupFromGroup(1L, groupName0, groupName0);
    }

    @Test
    public void testRemoveGroupFromGroup() throws Exception {
        Assert.assertEquals((long)2L, (long)this.directoryManager.searchDirectGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
        Assert.assertEquals((long)4L, (long)this.directoryManager.searchNestedGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
        this.directoryManager.removeGroupFromGroup(1L, groupName1, groupName3);
        Assert.assertEquals((long)1L, (long)this.directoryManager.searchDirectGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
        Assert.assertEquals((long)2L, (long)this.directoryManager.searchNestedGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setResetableHiLoGeneratorHelper(ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper) {
        this.resetableHiLoGeneratorHelper = resetableHiLoGeneratorHelper;
    }
}

