/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.importer;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterConfigurationException;
import com.atlassian.crowd.importer.factory.ImporterFactory;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.importers.JiraImporter;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.plugin.web.WebInterfaceManager;
import java.util.Set;
import org.mockito.Mockito;
import org.quartz.Scheduler;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class ImporterFactoryImplTest
extends AbstractDependencyInjectionSpringContextTests {
    private ImporterFactory importerFactory;
    private Configuration configuration;

    protected String[] getConfigLocations() {
        this.setAutowireMode(1);
        return new String[]{"classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-CrowdManagers.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-CrowdEncryption.xml", "classpath:/applicationContext-CrowdImporter.xml", "classpath:/applicationContext-CrowdLDAP.xml", "classpath:/applicationContext-CrowdServer.xml", "classpath:/applicationContext-CrowdClient.xml", "classpath:/applicationContext-config.xml"};
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        beanFactory.registerSingleton("scheduler", Mockito.mock(Scheduler.class));
        beanFactory.registerSingleton("bootstrapManager", Mockito.mock(CrowdBootstrapManager.class));
        beanFactory.registerSingleton("crowdUserDetailsService", Mockito.mock(CrowdUserDetailsService.class));
        beanFactory.registerSingleton("webInterfaceManager", Mockito.mock(WebInterfaceManager.class));
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        this.configuration = new Configuration(Long.valueOf(1L), "jira", Boolean.TRUE, Boolean.TRUE);
    }

    public void testGetImporterDAO() throws Exception {
        Importer importerDAO = this.importerFactory.getImporterDAO(this.configuration);
        ImporterFactoryImplTest.assertNotNull((Object)importerDAO);
        ImporterFactoryImplTest.assertTrue((boolean)(importerDAO instanceof JiraImporter));
    }

    public void testGetImporterDAOWithNullConfiguration() throws ImporterConfigurationException {
        try {
            this.importerFactory.getImporterDAO(null);
            ImporterFactoryImplTest.fail((String)"We should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetImporterDAOWithBadConfiguration() {
        try {
            this.configuration.setApplication(null);
            this.importerFactory.getImporterDAO(this.configuration);
            ImporterFactoryImplTest.fail((String)"We should have thrown an ImporterConfigurationException");
        }
        catch (ImporterConfigurationException importerConfigurationException) {
            // empty catch block
        }
    }

    public void testGetSupportedImporterApplications() throws Exception {
        Set importers = this.importerFactory.getSupportedImporterApplications();
        ImporterFactoryImplTest.assertNotNull((Object)importers);
        ImporterFactoryImplTest.assertFalse((boolean)importers.isEmpty());
    }

    public void testGetAtlassianSupportedImporterApplications() throws Exception {
        Set importers = this.importerFactory.getAtlassianSupportedImporterApplications();
        ImporterFactoryImplTest.assertNotNull((Object)importers);
        ImporterFactoryImplTest.assertFalse((boolean)importers.isEmpty());
    }

    public void testGetSupportedImporterApplicationsIsAnUnmodifiableSet() {
        Set importers = this.importerFactory.getSupportedImporterApplications();
        try {
            importers.add("randomimporter");
            ImporterFactoryImplTest.fail((String)"We should have thrown a UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testGetAtlassianSupportedImporterApplicationsIsAnUnmodifiableSet() {
        Set importers = this.importerFactory.getAtlassianSupportedImporterApplications();
        try {
            importers.add("randomimporter");
            ImporterFactoryImplTest.fail((String)"We should have thrown a UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void setImporterFactory(ImporterFactory importerFactory) {
        this.importerFactory = importerFactory;
    }
}

