/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.directory;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-CrowdUtils.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class InternalDirectoryIntegrationTest {
    @Inject
    private DirectoryDao directoryDao;
    @Inject
    private DirectoryInstanceLoader directoryInstanceLoader;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private InternalDirectory internalDirectory;
    private PasswordCredential passwordCredential;
    private static final long DIRECTORY_ID = 1L;
    private static final String DIRECTORY_NAME = "directory1";
    private static final String GROUP1_NAME = "administratorS";
    private static final String GROUP_DESCRIPTION = "The Administrator Group";
    private static final String USER_NAME = "admin";
    private static final String USER_DISPLAYNAME = "Super Man";
    private static final long INVALID_DIRECTORY_ID = 4L;
    private static final String NEW_GROUP_NAME = "brand-New-group";
    private static final String NEW_GROUP_DESCRIPTION = "New Test Group";
    private GroupTemplate newGroup;
    private static final String NEW_GROUP_NAME2 = "brand-new-group2";
    private static final String NEW_GROUP_DESCRIPTION2 = "New Test Group2";
    private GroupTemplate newGroup2;
    private static final String NEW_GROUP_NAME3 = "brand-new-group3";
    private static final String NEW_GROUP_DESCRIPTION3 = "New Test Group3";
    private GroupTemplate newGroup3;
    private static final String NEW_USER_NAME = "New-User";
    private static final String NEW_USER_DISPLAY_NAME = "New Person";
    private UserTemplate newUser;
    private static final String NEW_USER_NAME2 = "new-user2";
    private static final String NEW_USER_DISPLAY_NAME2 = "New Person2";
    private UserTemplate newUser2;
    private static final String NEW_USER_NAME3 = "new-user3";
    private static final String NEW_USER_DISPLAY_NAME3 = "New Person3";
    private UserTemplate newUser3;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Before
    public void onSetUp() throws Exception {
        this.internalDirectory = this.getInternalDirectory();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("password_regex", "");
        attributes.put("user_encryption_method", "");
        this.internalDirectory.setAttributes(attributes);
        this.newGroup = this.makeGroup(NEW_GROUP_NAME, 1L, NEW_GROUP_DESCRIPTION);
        this.newGroup2 = this.makeGroup(NEW_GROUP_NAME2, 1L, NEW_GROUP_DESCRIPTION2);
        this.newGroup3 = this.makeGroup(NEW_GROUP_NAME3, 1L, NEW_GROUP_DESCRIPTION3);
        this.newUser = this.makeUser(NEW_USER_NAME, 1L, NEW_USER_DISPLAY_NAME);
        this.newUser2 = this.makeUser(NEW_USER_NAME2, 1L, NEW_USER_DISPLAY_NAME2);
        this.newUser3 = this.makeUser(NEW_USER_NAME3, 1L, NEW_USER_DISPLAY_NAME3);
        this.passwordCredential = PasswordCredential.NONE;
    }

    private GroupTemplate makeGroup(String name, long directoryID, String description) {
        GroupTemplate group = new GroupTemplate(name, directoryID, GroupType.GROUP);
        group.setDescription(description);
        return group;
    }

    private UserTemplate makeUser(String name, long directoryID, String displayName) {
        UserTemplate user = new UserTemplate(name, directoryID);
        user.setDisplayName(displayName);
        user.setFirstName("first");
        user.setLastName("last");
        user.setEmailAddress(name + "@blah.com");
        return user;
    }

    public InternalDirectory getInternalDirectory() throws Exception {
        Directory directory = this.directoryDao.findByName(DIRECTORY_NAME);
        return (InternalDirectory)this.directoryInstanceLoader.getDirectory(directory);
    }

    @Test
    public void testAddUser() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, "New Guy");
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        Assert.assertEquals((Object)"new", (Object)foundUser.getName());
        Assert.assertEquals((Object)"New Guy", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"first", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"last", (Object)foundUser.getLastName());
        Assert.assertEquals((Object)"new@blah.com", (Object)foundUser.getEmailAddress());
        Assert.assertNotNull((String)"Should assign a unique, immutable identifier", (Object)foundUser.getExternalId());
    }

    @Test
    public void testAddUser_displayNameCalculated() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, null);
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        Assert.assertEquals((Object)"new", (Object)foundUser.getName());
        Assert.assertEquals((Object)"first last", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"first", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"last", (Object)foundUser.getLastName());
        Assert.assertEquals((Object)"new@blah.com", (Object)foundUser.getEmailAddress());
    }

    @Test
    public void testAddUser_firstNameLastNameCalculated() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, "new guy");
        user.setFirstName(null);
        user.setLastName(null);
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        Assert.assertEquals((Object)"new", (Object)foundUser.getName());
        Assert.assertEquals((Object)"new guy", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"new", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"guy", (Object)foundUser.getLastName());
        Assert.assertEquals((Object)"new@blah.com", (Object)foundUser.getEmailAddress());
    }

    @Test
    public void testAddUser_AllCalculated() throws Exception {
        UserTemplate user = this.makeUser("new", 1L, null);
        user.setFirstName(null);
        user.setLastName(null);
        this.internalDirectory.addUser(user, PasswordCredential.encrypted((String)"secret"));
        TimestampedUser foundUser = this.internalDirectory.findUserByName("new");
        Assert.assertEquals((Object)"new", (Object)foundUser.getName());
        Assert.assertEquals((Object)"new", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"new", (Object)foundUser.getLastName());
        Assert.assertEquals((Object)"new@blah.com", (Object)foundUser.getEmailAddress());
    }

    @Test
    public void testUpdateUser_ShouldPreserveExternalId() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setExternalId(null);
        User updatedUser = this.internalDirectory.updateUser(template);
        Assert.assertEquals((Object)"external-id-2", (Object)updatedUser.getExternalId());
        TimestampedUser foundUser = this.internalDirectory.findUserByName(USER_NAME);
        Assert.assertEquals((Object)USER_NAME, (Object)foundUser.getName());
        Assert.assertEquals((Object)"external-id-2", (Object)foundUser.getExternalId());
    }

    @Test
    public void testUpdateUser_ShouldFailOnAttemptToChangeExternalId() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setExternalId("new-external-id");
        try {
            this.internalDirectory.updateUser(template);
            Assert.fail((String)"InvalidUserException expected");
        }
        catch (InvalidUserException invalidUserException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateUser_DisplayNameCalculated() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setDisplayName("");
        template.setFirstName("first");
        template.setLastName("last");
        this.internalDirectory.updateUser(template);
        TimestampedUser foundUser = this.internalDirectory.findUserByName(USER_NAME);
        Assert.assertEquals((Object)USER_NAME, (Object)foundUser.getName());
        Assert.assertEquals((Object)"first last", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"first", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"last", (Object)foundUser.getLastName());
    }

    @Test
    public void testUpdateUser_firstNameLastNameCalculated() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setDisplayName("first last");
        template.setFirstName(null);
        template.setLastName(null);
        this.internalDirectory.updateUser(template);
        TimestampedUser foundUser = this.internalDirectory.findUserByName(USER_NAME);
        Assert.assertEquals((Object)USER_NAME, (Object)foundUser.getName());
        Assert.assertEquals((Object)"first last", (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"first", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)"last", (Object)foundUser.getLastName());
    }

    @Test
    public void testUpdateUser_AllCalculated() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        UserTemplate template = new UserTemplate((User)user);
        template.setDisplayName(null);
        template.setFirstName(null);
        template.setLastName(null);
        this.internalDirectory.updateUser(template);
        TimestampedUser foundUser = this.internalDirectory.findUserByName(USER_NAME);
        Assert.assertEquals((Object)USER_NAME, (Object)foundUser.getName());
        Assert.assertEquals((Object)USER_NAME, (Object)foundUser.getDisplayName());
        Assert.assertEquals((Object)"", (Object)foundUser.getFirstName());
        Assert.assertEquals((Object)USER_NAME, (Object)foundUser.getLastName());
    }

    @Test
    public void testUpdateCredentialMaintainsCrendentialHistory() throws Exception {
        this.internalDirectory.setAttributes((Map)ImmutableMap.of((Object)"password_history_count", (Object)"2", (Object)"user_encryption_method", (Object)"plaintext"));
        this.internalDirectory.updateUserCredential(USER_NAME, PasswordCredential.unencrypted((String)"password1"));
        this.internalDirectory.updateUserCredential(USER_NAME, PasswordCredential.unencrypted((String)"password2"));
        this.internalDirectory.updateUserCredential(USER_NAME, PasswordCredential.unencrypted((String)"password3"));
        try {
            this.internalDirectory.updateUserCredential(USER_NAME, PasswordCredential.unencrypted((String)"password2"));
            Assert.fail((String)"InvalidCredentialException expected");
        }
        catch (InvalidCredentialException invalidCredentialException) {
            // empty catch block
        }
        this.internalDirectory.updateUserCredential(USER_NAME, PasswordCredential.unencrypted((String)"password1"));
    }

    @Test
    public void testAddGroup() throws Exception {
        try {
            this.internalDirectory.findGroupByName(NEW_GROUP_NAME);
            Assert.fail((String)"GroupNotFoundException exepcted since Group should not exist");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        this.internalDirectory.addGroup(this.newGroup);
        InternalDirectoryGroup group = this.internalDirectory.findGroupByName(NEW_GROUP_NAME);
        Assert.assertEquals((Object)NEW_GROUP_DESCRIPTION, (Object)group.getDescription());
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME}));
    }

    @Test
    public void testAddGroupInvalidDirectoryId() throws Exception {
        GroupTemplate invalidGroup = new GroupTemplate(NEW_GROUP_NAME, 4L, GroupType.GROUP);
        try {
            this.internalDirectory.findGroupByName(NEW_GROUP_NAME);
            Assert.fail((String)"GroupNotFoundException exepcted since Group should not exist");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        try {
            this.internalDirectory.addGroup(invalidGroup);
            Assert.fail((String)"IllegalArgumentException expected - group has invalid directory id");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME}), (long)0L);
    }

    @Test
    public void testUpdateGroup() throws Exception {
        GroupTemplate groupDiffDescription = this.makeGroup(GROUP1_NAME, 1L, NEW_GROUP_DESCRIPTION);
        InternalDirectoryGroup group = this.internalDirectory.findGroupByName(GROUP1_NAME);
        Assert.assertEquals((Object)GROUP_DESCRIPTION, (Object)group.getDescription());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{GROUP1_NAME}));
        this.internalDirectory.updateGroup(groupDiffDescription);
        InternalDirectoryGroup updatedGroup = this.internalDirectory.findGroupByName(groupDiffDescription.getName());
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{groupDiffDescription.getName()}));
        Assert.assertEquals((long)group.getDirectoryId(), (long)updatedGroup.getDirectoryId());
        Assert.assertEquals((Object)group.getName(), (Object)updatedGroup.getName());
        Assert.assertEquals((Object)NEW_GROUP_DESCRIPTION, (Object)updatedGroup.getDescription());
    }

    @Test
    public void testRemoveGroup() throws Exception {
        InternalDirectoryGroup group = this.internalDirectory.findGroupByName(GROUP1_NAME);
        Assert.assertEquals((Object)GROUP_DESCRIPTION, (Object)group.getDescription());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertTrue((jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ?", new Object[]{GROUP1_NAME}) > 0 ? 1 : 0) != 0);
        this.internalDirectory.removeGroup(GROUP1_NAME);
        try {
            this.internalDirectory.findGroupByName(GROUP1_NAME);
            Assert.fail((String)"GroupNotFoundException exepcted since Group should have been deleted");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ?", new Object[]{GROUP1_NAME}));
    }

    @Test
    public void testRemoveUser() throws Exception {
        TimestampedUser user = this.internalDirectory.findUserByName(USER_NAME);
        Assert.assertEquals((Object)USER_DISPLAYNAME, (Object)user.getDisplayName());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, USER_NAME}));
        this.internalDirectory.removeUser(USER_NAME);
        try {
            this.internalDirectory.findUserByName(USER_NAME);
            Assert.fail((String)"UserNotFoundException exepcted since User should have been deleted");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, USER_NAME}));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where child_name = ?", new Object[]{USER_NAME}));
    }

    @Test
    public void testAddRemoveGroupToGroup() throws Exception {
        this.internalDirectory.addGroup(this.newGroup);
        Assert.assertFalse((boolean)this.internalDirectory.isGroupDirectGroupMember(this.newGroup.getName(), GROUP1_NAME));
        this.internalDirectory.addGroupToGroup(this.newGroup.getName(), GROUP1_NAME);
        Assert.assertTrue((boolean)this.internalDirectory.isGroupDirectGroupMember(this.newGroup.getName(), GROUP1_NAME));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newGroup.getName()}));
        this.internalDirectory.removeGroupFromGroup(this.newGroup.getName(), GROUP1_NAME);
        Assert.assertFalse((boolean)this.internalDirectory.isGroupDirectGroupMember(this.newGroup.getName(), GROUP1_NAME));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newGroup.getName()}));
    }

    @Test
    public void testRemoveGroupFromGroupNotMember() throws Exception {
        this.internalDirectory.addGroup(this.newGroup);
        try {
            this.internalDirectory.removeGroupFromGroup(this.newGroup.getName(), GROUP1_NAME);
            Assert.fail((String)"MembershipNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAddUserToGroup() throws Exception {
        this.internalDirectory.addUser(this.newUser, this.passwordCredential);
        Assert.assertFalse((boolean)this.internalDirectory.isUserDirectGroupMember(this.newUser.getName(), GROUP1_NAME));
        this.internalDirectory.addUserToGroup(this.newUser.getName(), GROUP1_NAME);
        Assert.assertTrue((boolean)this.internalDirectory.isUserDirectGroupMember(this.newUser.getName(), GROUP1_NAME));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newUser.getName()}));
        this.internalDirectory.removeUserFromGroup(this.newUser.getName(), GROUP1_NAME);
        Assert.assertFalse((boolean)this.internalDirectory.isUserDirectGroupMember(this.newUser.getName(), GROUP1_NAME));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ? and child_name = ?", new Object[]{GROUP1_NAME, this.newUser.getName()}));
    }

    @Test
    public void testRemoveUserFromGroup() throws Exception {
        this.internalDirectory.addUser(this.newUser, this.passwordCredential);
        try {
            this.internalDirectory.removeUserFromGroup(this.newUser.getName(), GROUP1_NAME);
            Assert.fail((String)"MembershipNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAllUsers() throws Exception {
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.newUser, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.newUser2, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.newUser3, this.passwordCredential));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{NEW_USER_NAME}));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{NEW_USER_NAME2}));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{NEW_USER_NAME3}));
        this.internalDirectory.addAllUsers(usersToAdd);
        TimestampedUser newUserFound1 = this.internalDirectory.findUserByName(this.newUser.getName());
        TimestampedUser newUserFound2 = this.internalDirectory.findUserByName(this.newUser2.getName());
        TimestampedUser newUserFound3 = this.internalDirectory.findUserByName(this.newUser3.getName());
        Assert.assertEquals((String)"Identifiers should be unique", (long)3L, (long)ImmutableSet.of((Object)newUserFound1.getExternalId(), (Object)newUserFound2.getExternalId(), (Object)newUserFound3.getExternalId()).size());
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{NEW_USER_NAME}));
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{NEW_USER_NAME2}));
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{NEW_USER_NAME3}));
    }

    @Test
    public void testAddAllUsers_displayNameCalculated() throws Exception {
        UserTemplate user1 = this.makeUser("user1", 1L, null);
        user1.setFirstName("first1");
        user1.setLastName("last1");
        UserTemplate user2 = this.makeUser("user2", 1L, null);
        user2.setFirstName("first2");
        user2.setLastName("last2");
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user1, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user2, this.passwordCredential));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{"user1"}));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{"user2"}));
        this.internalDirectory.addAllUsers(usersToAdd);
        TimestampedUser foundUser1 = this.internalDirectory.findUserByName(user1.getName());
        TimestampedUser foundUser2 = this.internalDirectory.findUserByName(user2.getName());
        Assert.assertEquals((Object)"user1", (Object)foundUser1.getName());
        Assert.assertEquals((Object)"first1 last1", (Object)foundUser1.getDisplayName());
        Assert.assertEquals((Object)"first1", (Object)foundUser1.getFirstName());
        Assert.assertEquals((Object)"last1", (Object)foundUser1.getLastName());
        Assert.assertEquals((Object)"user1@blah.com", (Object)foundUser1.getEmailAddress());
        Assert.assertEquals((Object)"user2", (Object)foundUser2.getName());
        Assert.assertEquals((Object)"first2 last2", (Object)foundUser2.getDisplayName());
        Assert.assertEquals((Object)"first2", (Object)foundUser2.getFirstName());
        Assert.assertEquals((Object)"last2", (Object)foundUser2.getLastName());
        Assert.assertEquals((Object)"user2@blah.com", (Object)foundUser2.getEmailAddress());
    }

    @Test
    public void testAddAllUsers_firstNameLastNameCalculated() throws Exception {
        UserTemplate user1 = this.makeUser("user1", 1L, "first1 last1");
        user1.setFirstName(null);
        user1.setLastName(null);
        UserTemplate user2 = this.makeUser("user2", 1L, "first2 last2");
        user2.setFirstName(null);
        user2.setLastName(null);
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user1, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user2, this.passwordCredential));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((Object)0, (Object)jdbcTemplate.queryForObject("select count(*) from cwd_user where user_name = ?", Integer.class, new Object[]{"user1"}));
        Assert.assertEquals((Object)0, (Object)jdbcTemplate.queryForObject("select count(*) from cwd_user where user_name = ?", Integer.class, new Object[]{"user2"}));
        this.internalDirectory.addAllUsers(usersToAdd);
        TimestampedUser foundUser1 = this.internalDirectory.findUserByName(user1.getName());
        TimestampedUser foundUser2 = this.internalDirectory.findUserByName(user2.getName());
        Assert.assertEquals((Object)"user1", (Object)foundUser1.getName());
        Assert.assertEquals((Object)"first1 last1", (Object)foundUser1.getDisplayName());
        Assert.assertEquals((Object)"first1", (Object)foundUser1.getFirstName());
        Assert.assertEquals((Object)"last1", (Object)foundUser1.getLastName());
        Assert.assertEquals((Object)"user1@blah.com", (Object)foundUser1.getEmailAddress());
        Assert.assertEquals((Object)"user2", (Object)foundUser2.getName());
        Assert.assertEquals((Object)"first2 last2", (Object)foundUser2.getDisplayName());
        Assert.assertEquals((Object)"first2", (Object)foundUser2.getFirstName());
        Assert.assertEquals((Object)"last2", (Object)foundUser2.getLastName());
        Assert.assertEquals((Object)"user2@blah.com", (Object)foundUser2.getEmailAddress());
    }

    @Test
    public void testAddAllUsers_AllCalculated() throws Exception {
        UserTemplate user1 = this.makeUser("user1", 1L, null);
        user1.setFirstName(null);
        user1.setLastName(null);
        UserTemplate user2 = this.makeUser("user2", 1L, null);
        user2.setFirstName(null);
        user2.setLastName(null);
        HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user1, this.passwordCredential));
        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)user2, this.passwordCredential));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{"user1"}));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_user where user_name = ?", new Object[]{"user2"}));
        this.internalDirectory.addAllUsers(usersToAdd);
        TimestampedUser foundUser1 = this.internalDirectory.findUserByName(user1.getName());
        TimestampedUser foundUser2 = this.internalDirectory.findUserByName(user2.getName());
        Assert.assertEquals((Object)"user1", (Object)foundUser1.getName());
        Assert.assertEquals((Object)"user1", (Object)foundUser1.getDisplayName());
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)foundUser1.getFirstName()));
        Assert.assertEquals((Object)"user1", (Object)foundUser1.getLastName());
        Assert.assertEquals((Object)"user1@blah.com", (Object)foundUser1.getEmailAddress());
        Assert.assertEquals((Object)"user2", (Object)foundUser2.getName());
        Assert.assertEquals((Object)"user2", (Object)foundUser2.getDisplayName());
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)foundUser2.getFirstName()));
        Assert.assertEquals((Object)"user2", (Object)foundUser2.getLastName());
        Assert.assertEquals((Object)"user2@blah.com", (Object)foundUser2.getEmailAddress());
    }

    @Test
    public void testAddAllUsersToGroup() throws Exception {
        ImmutableSet usersToAdd = ImmutableSet.of((Object)USER_NAME, (Object)"bob", (Object)"jane");
        BatchResult batchResult = this.internalDirectory.addAllUsersToGroup((Set)usersToAdd, GROUP1_NAME);
        Assert.assertThat((Object)batchResult.getFailedEntities(), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{USER_NAME}));
        Assert.assertThat((Object)batchResult.getSuccessfulEntities(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"bob", "jane"}));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertThat((Object)jdbcTemplate.queryForInt("select count(*) from cwd_membership where parent_name = ? ", new Object[]{GROUP1_NAME}), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
    }

    @Test
    public void testAddAllGroups() throws Exception {
        HashSet<GroupTemplate> groupsToAdd = new HashSet<GroupTemplate>();
        groupsToAdd.add(this.newGroup);
        groupsToAdd.add(this.newGroup2);
        groupsToAdd.add(this.newGroup3);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME2}));
        Assert.assertEquals((long)0L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME3}));
        this.internalDirectory.addAllGroups(groupsToAdd);
        this.internalDirectory.findGroupByName(this.newGroup.getName());
        this.internalDirectory.findGroupByName(this.newGroup2.getName());
        this.internalDirectory.findGroupByName(this.newGroup3.getName());
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME}));
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME2}));
        Assert.assertEquals((long)1L, (long)jdbcTemplate.queryForInt("select count(*) from cwd_group where group_name = ?", new Object[]{NEW_GROUP_NAME3}));
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    public void setDirectoryInstanceLoader(DirectoryInstanceLoader directoryInstanceLoader) {
        this.directoryInstanceLoader = directoryInstanceLoader;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setResetableHiLoGeneratorHelper(ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper) {
        this.resetableHiLoGeneratorHelper = resetableHiLoGeneratorHelper;
    }
}

