/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.user;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.Users;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import java.util.List;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class UserDaoSearchTest {
    @Inject
    private UserDao userDAO;
    @Inject
    private DataSource dataSource;
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_USER_1 = "admin";
    private static final String EXISTING_USER_2 = "bob";
    private static final String EXISTING_USER_3 = "jane";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Test
    public void testSearchAllUserNames() {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10);
        List users = this.userDAO.search(1L, query);
        Assert.assertThat((Object)users, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_2, EXISTING_USER_3}));
    }

    @Test
    public void testSearchUsernameStartsWith() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.USERNAME, MatchMode.STARTS_WITH, (Object)"a");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_1}));
    }

    @Test
    public void testSearchEmailContains() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)"@eXample");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_2}));
    }

    @Test
    public void testSearchFirstNameExact() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.FIRST_NAME, MatchMode.EXACTLY_MATCHES, (Object)"BOB");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_2}));
    }

    @Test
    public void testSearchLastNameStartsWith() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.LAST_NAME, MatchMode.STARTS_WITH, (Object)"s");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_2}));
    }

    @Test
    public void testSearchLastNameStartsWithUsingBuilder() throws Exception {
        PropertyRestriction userNameRestriction = Restriction.on((Property)UserTermKeys.LAST_NAME).startingWith((Object)"s");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_2}));
    }

    @Test
    public void testSearchForActiveUsersUsingBuilder() throws Exception {
        PropertyRestriction propertyRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)propertyRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_2}));
    }

    @Test
    public void testSearchForInactiveUsersUsingBuilder() throws Exception {
        PropertyRestriction propertyRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)false);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)propertyRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_3}));
    }

    @Test
    public void testSearchDisplayNameContains() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)"mI");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_2}));
    }

    @Test
    public void testSearchColorExact() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"black");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_1}));
    }

    @Test
    public void testSearchColorNoResults() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"crimson");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertEquals((long)0L, (long)users.size());
    }

    @Test
    public void testSearchNullCustomAttribute() {
        TermRestriction userAttributeRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userAttributeRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertEquals((long)2L, (long)users.size());
    }

    @Test
    public void testSearchPrimaryAttributeAndNullCustomAttribute() {
        TermRestriction userEmailRestriction = new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)"a");
        TermRestriction userAttributeRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{userEmailRestriction, userAttributeRestriction}), 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertEquals((long)1L, (long)users.size());
    }

    @Test
    public void testSearchMultipleNullValues() {
        TermRestriction r1 = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        TermRestriction r2 = new TermRestriction(PropertyUtils.ofTypeString((String)"something"), MatchMode.NULL, null);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{r1, r2}), 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertEquals((long)3L, (long)users.size());
    }

    @Test
    public void testSearchFirstClassDisjunction() throws Exception {
        TermRestriction userNameRestriction1 = new TermRestriction(UserTermKeys.LAST_NAME, MatchMode.STARTS_WITH, (Object)"s");
        TermRestriction userNameRestriction2 = new TermRestriction(UserTermKeys.LAST_NAME, MatchMode.STARTS_WITH, (Object)"m");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{userNameRestriction1, userNameRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_2}));
    }

    @Test
    public void testSearchFirstClassConjunction() throws Exception {
        TermRestriction userNameRestriction1 = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        TermRestriction userNameRestriction2 = new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)"@examplE");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{userNameRestriction1, userNameRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_2}));
    }

    @Test
    public void testSearchSecondClassDisjuction() throws Exception {
        TermRestriction colorRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction colorRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"yellow");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{colorRestriction1, colorRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_2}));
    }

    @Test
    public void testSearchSecondClassConjunction() throws Exception {
        TermRestriction colorRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction colorRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"black");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction1, colorRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_1}));
    }

    @Test
    public void testSearchMixedClassDisjunction() throws Exception {
        TermRestriction colorRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"black");
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{colorRestriction, displayNameRestriction});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_2}));
    }

    @Test
    public void testSearchMixedClassConjunction() throws Exception {
        TermRestriction colorRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        BooleanRestrictionImpl userNameConjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction, displayNameRestriction});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameConjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{EXISTING_USER_2}));
    }

    @Test
    public void testSearchNested() {
        TermRestriction colorRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        BooleanRestrictionImpl conjunction1 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction, displayNameRestriction});
        TermRestriction colorRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"violet");
        TermRestriction displayNameRestriction2 = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"j");
        BooleanRestrictionImpl conjunction2 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction2, displayNameRestriction2});
        BooleanRestrictionImpl nestedRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{conjunction1, conjunction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)nestedRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_2, EXISTING_USER_3}));
    }

    @Test
    public void testSearchNestedCustomNullAttributes() {
        TermRestriction openidRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"Jane");
        BooleanRestrictionImpl conjunction1 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{openidRestriction, displayNameRestriction});
        TermRestriction openidRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        TermRestriction displayNameRestriction2 = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"Bob");
        BooleanRestrictionImpl conjunction2 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{openidRestriction2, displayNameRestriction2});
        BooleanRestrictionImpl nestedRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{conjunction1, conjunction2, new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.CONTAINS, (Object)"/")});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)nestedRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_2, EXISTING_USER_3}));
    }

    @Test
    public void testSearchMixedCaseUsername() {
        List users = this.userDAO.search(2L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)"john")).returningAtMost(10));
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"JohnSmith"}));
        users = this.userDAO.search(2L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)"jOhNsMiTh")).returningAtMost(10));
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"JohnSmith"}));
    }

    @Test
    public void testSearchMixedCaseUsernameAttributeMatch() {
        List users = this.userDAO.search(2L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"color")).containing((Object)"violet")).returningAtMost(10));
        Assert.assertThat((Object)Users.namesOf((Iterable)users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_3, "JohnSmith"}));
    }
}

