/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.user;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.Users;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.test.matchers.CrowdMatchers;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.hibernate.proxy.HibernateProxy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class UserDAOHibernateTest {
    @Inject
    private UserDAOHibernate userDAO;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_USER_1 = "admin";
    private static final String EXISTING_USER_2 = "bob";
    private static final String EXISTING_USER_3 = "jane";
    private static final String NON_EXISTING_USER = "newguy";
    private static final String NON_EXISTING_USER_MIXED_CASE = "NewGuy";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testFindByNameReturnsUserWithLazyLoadedDirectory() throws Exception {
        InternalUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        Assert.assertTrue((boolean)((HibernateProxy)user.getDirectory()).getHibernateLazyInitializer().isUninitialized());
    }

    @Test
    public void testFindByMixedCaseNameExactMatch() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "JohnSmith");
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"JohnSmith"), (Object)user.getLowerName());
    }

    @Test
    public void testFindByMixedCaseNameCaseInsensitiveMatch() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "johnsmith");
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"JohnSmith"), (Object)user.getLowerName());
    }

    @Test
    public void testExternalIdIsSet() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "johnsmith");
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"JohnSmith"), (Object)user.getLowerName());
        Assert.assertThat((Object)user.getExternalId(), (Matcher)IsEqual.equalTo((Object)"external-id-1"));
    }

    @Test
    public void testFindByExternalId() throws Exception {
        InternalUser user = this.userDAO.findByExternalId(2L, "external-id-1");
        Assert.assertEquals((Object)"JohnSmith", (Object)user.getName());
        Assert.assertThat((Object)user.getExternalId(), (Matcher)IsEqual.equalTo((Object)"external-id-1"));
    }

    @Test
    public void testFindByExternalIdIsCaseSensitive() throws Exception {
        try {
            this.userDAO.findByExternalId(2L, "External-Id-1");
            Assert.fail((String)"UserNotFoundException should be thrown");
        }
        catch (UserNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)IsEqual.equalTo((Object)"User <externalId=External-Id-1> does not exist"));
        }
    }

    @Test
    public void testFindByExternalIdAcceptsNullExternalId() throws Exception {
        try {
            this.userDAO.findByExternalId(2L, null);
            Assert.fail((String)"NullPointerException should be thrown");
        }
        catch (NullPointerException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)IsEqual.equalTo((Object)"externalId"));
        }
    }

    @Test
    public void testPasswordCanBeChangedViaUpdate() throws Exception {
        InternalUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        user.updateCredentialTo(new PasswordCredential("password", true), 10);
        this.userDAO.update((User)user);
        Assert.assertTrue((user.getCredentialRecords().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRenamedUserHasLowercaseName() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "JohnSmith");
        this.userDAO.rename((User)user, "BobSmith");
        InternalUser renamedUser = this.userDAO.findByName(2L, "BobSmith");
        Assert.assertEquals((Object)"bobsmith", (Object)renamedUser.getLowerName());
    }

    @Test
    public void testRemoveAll() {
        this.userDAO.removeAll(1L);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertTrue((boolean)this.userDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10)).isEmpty());
        Assert.assertThat((Object)jdbcTemplate.queryForObject("SELECT COUNT(*) FROM cwd_membership WHERE membership_type = 'GROUP_USER' AND directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("SELECT COUNT(*) FROM cwd_user_credential_record", Integer.class), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testRemoveAllUsers() {
        this.userDAO.removeAllUsers(1L, (Set)ImmutableSet.of((Object)EXISTING_USER_1, (Object)EXISTING_USER_3));
        List users = this.userDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10));
        Assert.assertThat((Object)users, (Matcher)Matchers.contains((Matcher)CrowdMatchers.userNamed((String)EXISTING_USER_2)));
    }

    @Test
    public void testAddAllUsers() {
        this.userDAO.addAll((Set)ImmutableSet.of((Object)new UserTemplateWithCredentialAndAttributes("timothy", 1L, new PasswordCredential("", true)), (Object)new UserTemplateWithCredentialAndAttributes("obadiah", 1L, new PasswordCredential("", true))));
        List users = this.userDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10));
        Assert.assertThat((Object)users, (Matcher)Matchers.hasItem((Matcher)CrowdMatchers.userNamed((String)"timothy")));
        Assert.assertThat((Object)users, (Matcher)Matchers.hasItem((Matcher)CrowdMatchers.userNamed((String)"obadiah")));
    }

    @Test
    public void testStoreAttributesWithInsertForNewUser() throws Exception {
        User createdUser = this.createNewUser(NON_EXISTING_USER_MIXED_CASE);
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"Blue", "Green"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes(createdUser, attributes);
        InternalUserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, NON_EXISTING_USER_MIXED_CASE);
        Assert.assertEquals((Object)NON_EXISTING_USER_MIXED_CASE, (Object)returnedUser.getInternalUser().getName());
        Assert.assertEquals((Object)NON_EXISTING_USER, (Object)returnedUser.getInternalUser().getLowerName());
        Assert.assertEquals((long)2L, (long)returnedUser.getKeys().size());
        Assert.assertEquals((long)2L, (long)returnedUser.getValues("color").size());
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("Blue"));
        Assert.assertTrue((boolean)returnedUser.getValues("color").contains("Green"));
        Assert.assertEquals((long)1L, (long)returnedUser.getValues("phone").size());
        Assert.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        SqlRowSet sqlRowSet = jdbcTemplate.queryForRowSet("SELECT attribute_lower_value FROM cwd_user_attribute WHERE user_id = " + returnedUser.getInternalUser().getId());
        HashSet<String> lowerCaseAttributeValues = new HashSet<String>();
        while (sqlRowSet.next()) {
            lowerCaseAttributeValues.add(sqlRowSet.getString("attribute_lower_value"));
        }
        Assert.assertEquals((long)3L, (long)lowerCaseAttributeValues.size());
        Assert.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Blue")));
        Assert.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Green")));
        Assert.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"131111")));
    }

    private User createNewUser(String username) throws Exception {
        UserTemplate user = new UserTemplate(username, 1L);
        user.setActive(true);
        user.setFirstName("New");
        user.setLastName("Guy");
        user.setDisplayName("New Guy");
        user.setEmailAddress("nOOb@example.com");
        return this.userDAO.add((User)user, PasswordCredential.encrypted((String)"secret"));
    }

    @Test
    public void testFindByNames() {
        ArrayList users = new ArrayList(this.userDAO.findByNames(1L, (Collection)ImmutableSet.of((Object)EXISTING_USER_1, (Object)"bogus", (Object)EXISTING_USER_3)));
        Assert.assertThat((Object)Users.namesOf(users), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_USER_1, EXISTING_USER_3}));
    }
}

