/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.token;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.acceptance.tests.persistence.dao.token.TokenDAOTester;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.dao.token.TokenDAOHibernate;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class TokenDAOHibernateTest
extends TokenDAOTester {
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    @Inject
    private TokenDAOHibernate tokenDAO;

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testFindByID() throws Exception {
        Token token = this.tokenDAO.findByID(TOKEN_ID.longValue());
        Assert.assertNotNull((Object)token);
        Assert.assertEquals((Object)TOKEN_ID, (Object)token.getId());
    }

    @Test
    public void testTokenRemovalWhereTokenDoesNotExist() throws Exception {
        Token tokenToRemove = this.tokenDAO.findByRandomHash("oFpXcZ2lfvtc0YQBgE1EeA00");
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.update("DELETE FROM cwd_token WHERE random_hash = ?", new Object[]{"oFpXcZ2lfvtc0YQBgE1EeA00"});
        this.tokenDAO.remove(tokenToRemove);
        this.expectedException.expect(ObjectNotFoundException.class);
        tokenToRemove = this.tokenDAO.findByRandomHash("oFpXcZ2lfvtc0YQBgE1EeA00");
    }

    @Test
    public void testCallingTokenRemovalTwiceDoesNotThrowAnException() throws Exception {
        Token tokenToRemove = this.tokenDAO.findByRandomHash("oFpXcZ2lfvtc0YQBgE1EeA00");
        this.tokenDAO.remove(tokenToRemove);
        this.tokenDAO.remove(tokenToRemove);
    }

    @Override
    protected TokenDAO getTokenDAO() {
        return this.tokenDAO;
    }
}

