/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.membership;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.Groups;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.Users;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.List;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class MembershipDaoSearchTest {
    private static final long DIRECTORY_ID = 1L;
    @Inject
    private MembershipDao membershipDAO;
    @Inject
    private DataSource dataSource;
    private static final String ADMINISTRATORS_GROUP_MIXED = "Administrators";
    private static final String ADMINISTRATORS_GROUP_ACTUAL = "administratorS";
    private static final String USERS_ROLE = "users";
    private static final String DEVELOPERS_GROUP = "developers";
    private static final String ADMIN_USER = "aDmin";
    private static final String PRODUCT_MANAGERS_ROLE = "Product Managers";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Test
    public void testSearchForUserMembersOfGroup() {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)Users.namesOf((Iterable)results), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{IdentifierUtils.toLowerCase((String)ADMIN_USER)}));
    }

    @Test
    public void testSearchForUserMembersOfGroupAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{IdentifierUtils.toLowerCase((String)ADMIN_USER)}));
    }

    @Test
    public void testSearchForGroupMembershipsOfUser() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)Groups.namesOf((Iterable)results), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ADMINISTRATORS_GROUP_ACTUAL, DEVELOPERS_GROUP}));
    }

    @Test
    public void testSearchForGroupMembershipsOfUserAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{ADMINISTRATORS_GROUP_ACTUAL, DEVELOPERS_GROUP}));
    }

    @Test
    public void testSearchForGroupMembershipsOfGroup() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.role()).withName(PRODUCT_MANAGERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)Groups.namesOf((Iterable)results), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{USERS_ROLE}));
    }

    @Test
    public void testSearchForGroupMembershipsOfGroupAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.role()).withName(PRODUCT_MANAGERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{USERS_ROLE}));
    }

    @Test
    public void testSearchForGroupMembersOfGroup() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)Groups.namesOf((Iterable)results), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{PRODUCT_MANAGERS_ROLE}));
    }

    @Test
    public void testSearchForGroupMembersOfGroupAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{PRODUCT_MANAGERS_ROLE}));
    }

    @Test
    public void testSearchForUserMembersOfGroupOfTypeRole() {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsEmptyCollection.emptyCollectionOf(InternalUser.class));
    }

    @Test
    public void testSearchForUserMembersOfGroupOfTypeRoleAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
    }

    @Test
    public void testSearchForGroupMembershipsOfUserOfTypeRole() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)Groups.namesOf((Iterable)results), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{USERS_ROLE}));
    }

    @Test
    public void testSearchForGroupMembershipsOfUserOfTypeRoleAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{USERS_ROLE}));
    }

    @Test
    public void testSearchForGroupMembershipsOfGroupOfTypeRole() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(DEVELOPERS_GROUP).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsEmptyCollection.emptyCollectionOf(InternalGroup.class));
    }

    @Test
    public void testSearchForGroupMembershipsOfGroupOfTypeRoleAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(DEVELOPERS_GROUP).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        Assert.assertThat((Object)results, (Matcher)IsEmptyCollection.emptyCollectionOf(InternalGroup.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSearchForGroupMembersfGroupOfMismatchingTypesAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(USERS_ROLE).startingAt(0).returningAtMost(10);
        this.membershipDAO.search(1L, query);
    }
}

