/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.membership;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class MembershipDaoCRUDTest {
    private static final long DIRECTORY_ID = 1L;
    private static final String NON_EXISTING_GROUP = "fakers";
    @Inject
    private MembershipDao membershipDAO;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final String ADMINISTRATORS_GROUP_MIXED = "Administrators";
    private static final String ADMINISTRATORS_GROUP_ACTUAL = "administratorS";
    private static final String USERS_ROLE = "users";
    private static final String DEVELOPERS_GROUP = "developers";
    private static final String ADMIN_USER = "aDmin";
    private static final String PRODUCT_MANAGERS_ROLE = "Product Managers";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testIsUserDirectMemberTrueMixedCase() {
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(2L, "JohnSmith", "Testers"));
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(2L, "JohnSmith".toUpperCase(), "Testers"));
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(2L, "JohnSmith", "Testers".toUpperCase()));
    }

    @Test
    public void testIsUserDirectMemberTrue() {
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", DEVELOPERS_GROUP));
    }

    @Test
    public void testIsUserDirectMemberFalse() {
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", USERS_ROLE));
    }

    @Test
    public void testIsGroupDirectMemberTrue() {
        Assert.assertTrue((boolean)this.membershipDAO.isGroupDirectMember(1L, PRODUCT_MANAGERS_ROLE, USERS_ROLE));
    }

    @Test
    public void testIsGroupDirectMemberFalse() {
        Assert.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, ADMINISTRATORS_GROUP_ACTUAL));
    }

    @Test
    public void testAddUserToGroup() throws Exception {
        this.membershipDAO.addUserToGroup(1L, "jane", USERS_ROLE);
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "jane", USERS_ROLE));
    }

    @Test(expected=MembershipAlreadyExistsException.class)
    public void testAddUserToGroupWhereMembershipExists() throws Exception {
        this.membershipDAO.addUserToGroup(2L, "johnSmith", "testers");
    }

    @Test
    public void testAddUserToGroupWhereGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.addUserToGroup(1L, "jane", NON_EXISTING_GROUP);
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, MembershipDaoCRUDTest.groupsOfUser("jane")).size());
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "jane", NON_EXISTING_GROUP));
    }

    @Test
    public void testAddUserToGroupWhereUserDoesNotExist() throws Exception {
        try {
            this.membershipDAO.addUserToGroup(1L, "billy", USERS_ROLE);
            Assert.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).returningAtMost(10)).size());
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "billy", USERS_ROLE));
    }

    @Test
    public void testAddUserToGroupWhereUserDoesNotExistPreservesCase() throws Exception {
        try {
            this.membershipDAO.addUserToGroup(1L, "Billy", USERS_ROLE);
            Assert.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).returningAtMost(10)).size());
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "Billy", USERS_ROLE));
    }

    @Test
    public void testAddAllUsersToGroup() throws Exception {
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
        BatchResult result = this.membershipDAO.addAllUsersToGroup(1L, (Collection)ImmutableList.of((Object)"bob"), ADMINISTRATORS_GROUP_ACTUAL);
        Assert.assertFalse((String)"There should not be failures", (boolean)result.hasFailures());
        Assert.assertThat((Object)result.getSuccessfulEntities(), (Matcher)IsCollectionContaining.hasItem((Object)"bob"));
        Assert.assertEquals((long)2L, (long)this.membershipDAO.search(1L, MembershipDaoCRUDTest.usersOfGroup(ADMINISTRATORS_GROUP_ACTUAL)).size());
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
    }

    @Test
    public void testAddAllUsersToGroupIsCaseInsensitive() throws Exception {
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
        BatchResult result = this.membershipDAO.addAllUsersToGroup(1L, (Collection)ImmutableList.of((Object)"Bob"), ADMINISTRATORS_GROUP_ACTUAL);
        Assert.assertFalse((String)"There should not be failures", (boolean)result.hasFailures());
        Assert.assertThat((Object)result.getSuccessfulEntities(), (Matcher)IsCollectionContaining.hasItem((Object)"bob"));
        Assert.assertEquals((long)2L, (long)this.membershipDAO.search(1L, MembershipDaoCRUDTest.usersOfGroup(ADMINISTRATORS_GROUP_ACTUAL)).size());
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
    }

    @Test(expected=GroupNotFoundException.class)
    public void testAddAllUsersToGroupWhenGroupDoesNotExist() throws Exception {
        this.membershipDAO.addAllUsersToGroup(1L, (Collection)ImmutableList.of((Object)"jane"), NON_EXISTING_GROUP);
    }

    @Test
    public void testAddAllUsersToGroupWhenSomeUsersDoNotExist() throws Exception {
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
        BatchResult result = this.membershipDAO.addAllUsersToGroup(1L, (Collection)ImmutableList.of((Object)"not a user", (Object)"bob"), ADMINISTRATORS_GROUP_ACTUAL);
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
        Assert.assertThat((Object)result.getSuccessfulEntities(), (Matcher)IsCollectionContaining.hasItem((Object)"bob"));
        Assert.assertTrue((String)"Some entities should have failed", (boolean)result.hasFailures());
        Assert.assertThat((Object)result.getFailedEntities(), (Matcher)IsCollectionContaining.hasItem((Object)"not a user"));
    }

    @Test
    public void testAddAllUsersToGroupWhenSomeMembershipsAlreadyExist() throws Exception {
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "admin", ADMINISTRATORS_GROUP_ACTUAL));
        BatchResult result = this.membershipDAO.addAllUsersToGroup(1L, (Collection)ImmutableList.of((Object)"admin", (Object)"bob"), ADMINISTRATORS_GROUP_ACTUAL);
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", ADMINISTRATORS_GROUP_ACTUAL));
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "admin", ADMINISTRATORS_GROUP_ACTUAL));
        Assert.assertThat((Object)result.getSuccessfulEntities(), (Matcher)IsCollectionContaining.hasItem((Object)"bob"));
        Assert.assertTrue((String)"Some entities should have failed", (boolean)result.hasFailures());
        Assert.assertThat((Object)result.getFailedEntities(), (Matcher)IsCollectionContaining.hasItem((Object)"admin"));
    }

    @Test
    public void testAddAllUsersToGroupWhenMembershipAlreadyExistIsCaseInsensitive() throws Exception {
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "admin", ADMINISTRATORS_GROUP_ACTUAL));
        BatchResult result = this.membershipDAO.addAllUsersToGroup(1L, (Collection)ImmutableList.of((Object)"Admin"), ADMINISTRATORS_GROUP_ACTUAL);
        Assert.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "admin", ADMINISTRATORS_GROUP_ACTUAL));
        Assert.assertThat((Object)result.getSuccessfulEntities(), (Matcher)Matchers.emptyCollectionOf(String.class));
        Assert.assertTrue((String)"Some entities should have failed", (boolean)result.hasFailures());
        Assert.assertThat((Object)result.getFailedEntities(), (Matcher)IsCollectionContaining.hasItem((Object)"admin"));
    }

    @Test
    public void testAddGroupToGroup() throws Exception {
        this.membershipDAO.addGroupToGroup(1L, ADMINISTRATORS_GROUP_MIXED, DEVELOPERS_GROUP);
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, MembershipDaoCRUDTest.parentGroupsOfGroup(ADMINISTRATORS_GROUP_MIXED)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, this.childGroupsOfGroup(DEVELOPERS_GROUP)).size());
        Assert.assertTrue((boolean)this.membershipDAO.isGroupDirectMember(1L, ADMINISTRATORS_GROUP_MIXED, DEVELOPERS_GROUP));
    }

    @Test
    public void testAddGroupToGroupWhereMembershipExists() throws Exception {
        this.membershipDAO.addGroupToGroup(1L, ADMINISTRATORS_GROUP_MIXED, DEVELOPERS_GROUP);
        try {
            this.membershipDAO.addGroupToGroup(1L, ADMINISTRATORS_GROUP_MIXED, DEVELOPERS_GROUP);
            Assert.fail((String)"MembershipAlreadyExistsException expected");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testAddGroupToGroupWhereChildGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.addGroupToGroup(1L, NON_EXISTING_GROUP, DEVELOPERS_GROUP);
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, NON_EXISTING_GROUP, DEVELOPERS_GROUP));
    }

    @Test
    public void testAddGroupToGroupWhereParentGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.addGroupToGroup(1L, DEVELOPERS_GROUP, NON_EXISTING_GROUP);
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, NON_EXISTING_GROUP));
    }

    @Test
    public void testRemoveUserFromGroup() throws Exception {
        this.membershipDAO.removeUserFromGroup(1L, ADMIN_USER, ADMINISTRATORS_GROUP_MIXED);
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, MembershipDaoCRUDTest.groupsOfUser(ADMIN_USER)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, MembershipDaoCRUDTest.usersOfGroup(ADMINISTRATORS_GROUP_MIXED)).size());
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, ADMIN_USER, ADMINISTRATORS_GROUP_MIXED));
    }

    @Test
    public void testRemoveUserFromGroupWhereGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.removeUserFromGroup(1L, ADMIN_USER, "faker");
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException e) {
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, ADMIN_USER, "faker"));
    }

    @Test
    public void testRemoveUserFromGroupWhereUserDoesNotExist() throws Exception {
        try {
            this.membershipDAO.removeUserFromGroup(1L, "billy", ADMINISTRATORS_GROUP_MIXED);
            Assert.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException e) {
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "billy", ADMINISTRATORS_GROUP_MIXED));
    }

    @Test
    public void testRemoveGroupFromGroup() throws Exception {
        this.membershipDAO.removeGroupFromGroup(1L, PRODUCT_MANAGERS_ROLE, USERS_ROLE);
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, MembershipDaoCRUDTest.parentGroupsOfGroup(DEVELOPERS_GROUP)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, this.childGroupsOfGroup(USERS_ROLE)).size());
        Assert.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, USERS_ROLE));
    }

    @Test
    public void testRemoveGroupFromGroupWhereParentGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.removeGroupFromGroup(1L, DEVELOPERS_GROUP, "faker");
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, "faker"));
    }

    @Test
    public void testRemoveGroupFromGroupWhereChildGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.removeGroupFromGroup(1L, "faker", DEVELOPERS_GROUP);
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, "faker", DEVELOPERS_GROUP));
    }

    private static MembershipQuery<Group> groupsOfUser(String username) {
        return QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(10);
    }

    private static MembershipQuery<User> usersOfGroup(String groupName) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(10);
    }

    private MembershipQuery<Group> childGroupsOfGroup(String parentGroup) {
        return QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(parentGroup).returningAtMost(10);
    }

    private static MembershipQuery<Group> parentGroupsOfGroup(String childGroup) {
        return QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(childGroup).returningAtMost(10);
    }
}

