/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.membership;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Query;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class MembershipDAOHibernateTest {
    private static final long DIRECTORY_ID = 1L;
    @Inject
    private MembershipDAOHibernate membershipDAO;
    @Inject
    private UserDAOHibernate userDAO;
    @Inject
    private GroupDAOHibernate groupDAO;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final String USERS_ROLE = "users";
    private static final String DEVELOPERS_GROUP = "developers";
    private static final String ADMIN_USER = "aDmin";
    private static final String PRODUCT_MANAGERS_ROLE = "Product Managers";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testRemoveGroupMembers() {
        this.membershipDAO.removeGroupMembers(1L, USERS_ROLE);
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
    }

    @Test
    public void testRemoveGroupMemberships() {
        this.membershipDAO.removeGroupMemberships(1L, DEVELOPERS_GROUP);
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(DEVELOPERS_GROUP).returningAtMost(10)).size());
    }

    @Test
    public void testRemoveUserMemberships() {
        this.membershipDAO.removeUserMemberships(1L, ADMIN_USER);
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
    }

    @Test
    public void testRemoveAllRelationships() {
        this.membershipDAO.removeAllRelationships(1L);
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(DEVELOPERS_GROUP).returningAtMost(10)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_membership where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testRemoveUserRelationships() {
        this.membershipDAO.removeAllUserRelationships(1L);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_membership where membership_type = 'GROUP_USER' and directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testRenameUserRelationships() {
        this.membershipDAO.renameUserRelationships(1L, ADMIN_USER, "badmin");
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
        Assert.assertEquals((long)2L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("badmin").returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.user()).withName("badmin").returningAtMost(10)).size());
    }

    @Test
    public void testRenameGroupRelationships() {
        this.membershipDAO.renameGroupRelationships(1L, USERS_ROLE, "lusers");
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).returningAtMost(10)).size());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("lusers").returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName("lusers").returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.role()).withName(PRODUCT_MANAGERS_ROLE).returningAtMost(10)).size());
    }

    @Test
    public void testAddAll() throws Exception {
        int i;
        HashSet<UserTemplateWithCredentialAndAttributes> users = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (i = 0; i < 15; ++i) {
            UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes("user" + i, 1L, new PasswordCredential("secret", true));
            user.setEmailAddress("blah@example.com");
            user.setFirstName("Clone");
            user.setLastName("Drone");
            user.setDisplayName("Clone Drone");
            users.add(user);
        }
        this.userDAO.addAll(users);
        for (i = 0; i < 3; ++i) {
            GroupTemplate group = new GroupTemplate("group" + i, 1L, GroupType.LEGACY_ROLE);
            group.setDescription("description");
            this.groupDAO.add((Group)group);
        }
        List internalUsers = this.userDAO.search(1L, QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).startingWith((Object)"user")).returningAtMost(100));
        List internalGroups = this.groupDAO.search(1L, QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.role()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"group")).returningAtMost(100));
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        for (InternalUser user : internalUsers) {
            for (InternalGroup group : internalGroups) {
                memberships.add(new InternalMembership(group, user));
            }
        }
        BatchResult result = this.membershipDAO.addAll(memberships);
        Assert.assertEquals((long)45L, (long)result.getTotalAttempted());
        Assert.assertEquals((long)45L, (long)result.getTotalSuccessful());
        Assert.assertEquals((long)15L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("group0").returningAtMost(100)).size());
        Assert.assertEquals((long)15L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("group1").returningAtMost(100)).size());
        Assert.assertEquals((long)15L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("group2").returningAtMost(100)).size());
    }

    @Test
    public void testAddAllWithDuplicates() throws Exception {
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        InternalUser admin = this.userDAO.findByName(1L, "admin");
        InternalUser jane = this.userDAO.findByName(1L, "jane");
        InternalGroup administrators = this.groupDAO.findByName(1L, "administrators");
        memberships.add(new InternalMembership(administrators, jane));
        InternalMembership duplicate = new InternalMembership(administrators, admin);
        memberships.add(duplicate);
        BatchResult result = this.membershipDAO.addAll(memberships);
        Assert.assertEquals((long)2L, (long)result.getTotalAttempted());
        Assert.assertEquals((long)1L, (long)result.getTotalSuccessful());
        Assert.assertTrue((boolean)result.getFailedEntities().contains(duplicate));
    }

    @Test
    public void testSearchCallsCreateHibernateSearchQuery() {
        final Query query = (Query)Mockito.mock(Query.class);
        MembershipDAOHibernate dao = new MembershipDAOHibernate(){

            protected Query createHibernateSearchQuery(long directoryId, MembershipQuery<?> crowdQuery) {
                return query;
            }
        };
        Mockito.when((Object)query.list()).thenReturn((Object)Lists.newArrayList());
        dao.search(1L, null);
        ((Query)Mockito.verify((Object)query)).list();
    }
}

