/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.group;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.Groups;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class GroupDaoCRUDTest {
    @Inject
    private GroupDao groupDAO;
    @Inject
    private MembershipDao membershipDAO;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    @Inject
    private DataSource dataSource;
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_GROUP_1 = "administratorS";
    private static final String EXISTING_GROUP_1_DESC = "The Administrator Group";
    private static final String EXISTING_GROUP_2 = "users";
    private static final String NON_EXISTING_GROUP = "NewGroup";
    private static final String COUNTRY_ATTRIBUTE = "country";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String NON_EXISTING_GROUP_DESC = "New Group";
    private static final String UPDATED_DESCRIPTION = "Updated Description";
    private static final String COUNTRY_VALUE_NZ = "New Zealand";
    private static final String COUNTRY_VALUE_AU = "Australia";
    private static final String LANGUAGE_ATTRIBUTE_VALUE = "Sheepish";

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        PersistenceTestHelper.fixHiLo(this.resetableHiLoGeneratorHelper);
    }

    @Test
    public void testFindByName() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        Assert.assertEquals((Object)EXISTING_GROUP_1, (Object)group.getName());
        Assert.assertEquals((Object)EXISTING_GROUP_1_DESC, (Object)group.getDescription());
        Assert.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
        Assert.assertTrue((boolean)group.isActive());
        Assert.assertTrue((boolean)group.getCreatedDate().before(new Date()));
        Assert.assertTrue((boolean)group.getUpdatedDate().before(new Date()));
        Assert.assertEquals((long)1L, (long)group.getDirectoryId());
    }

    @Test
    public void testFindByNameMixedCase() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(2L, "teSterS");
        Assert.assertEquals((Object)"Testers", (Object)group.getName());
        Assert.assertEquals((Object)"The Crowd Tester Crew", (Object)group.getDescription());
        Assert.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
        Assert.assertTrue((boolean)group.isActive());
        Assert.assertTrue((boolean)group.getCreatedDate().before(new Date()));
        Assert.assertTrue((boolean)group.getUpdatedDate().before(new Date()));
        Assert.assertEquals((long)2L, (long)group.getDirectoryId());
    }

    @Test(expected=GroupNotFoundException.class)
    public void testFindByNameDoesNotExist() throws Exception {
        this.groupDAO.findByName(1L, NON_EXISTING_GROUP);
    }

    @Test
    public void testFindByNameWithAttributes() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        Assert.assertEquals((Object)EXISTING_GROUP_1, (Object)group.getName());
        Assert.assertTrue((boolean)group.isActive());
        Assert.assertEquals((Object)EXISTING_GROUP_1_DESC, (Object)group.getDescription());
        Assert.assertEquals((long)1L, (long)group.getDirectoryId());
        Assert.assertEquals((long)2L, (long)group.getKeys().size());
        Assert.assertTrue((boolean)group.getKeys().contains(COUNTRY_ATTRIBUTE));
        Assert.assertTrue((boolean)group.getKeys().contains(LANGUAGE_ATTRIBUTE));
        Assert.assertEquals((long)2L, (long)group.getValues(COUNTRY_ATTRIBUTE).size());
        Assert.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_NZ));
        Assert.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_AU));
        Assert.assertEquals((long)1L, (long)group.getValues(LANGUAGE_ATTRIBUTE).size());
        Assert.assertEquals((Object)LANGUAGE_ATTRIBUTE_VALUE, (Object)group.getValue(LANGUAGE_ATTRIBUTE));
    }

    @Test
    public void testFindByMixedCaseNameWithAttributes() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(2L, "TestErs");
        Assert.assertEquals((Object)"Testers", (Object)group.getName());
        Assert.assertTrue((boolean)group.isActive());
        Assert.assertEquals((Object)"The Crowd Tester Crew", (Object)group.getDescription());
        Assert.assertEquals((long)2L, (long)group.getDirectoryId());
        Assert.assertEquals((long)1L, (long)group.getKeys().size());
        Assert.assertTrue((boolean)group.getKeys().contains("city"));
        Assert.assertEquals((long)1L, (long)group.getValues("city").size());
        Assert.assertTrue((boolean)group.getValues("city").contains("Perth"));
    }

    @Test(expected=GroupNotFoundException.class)
    public void testFindByNameWithAttributesWhenGroupsDoesNotExist() throws Exception {
        this.groupDAO.findByNameWithAttributes(1L, NON_EXISTING_GROUP);
    }

    @Test
    public void testAdd() throws Exception {
        Group createdGroup = this.createNewGroup(NON_EXISTING_GROUP);
        Assert.assertNotNull((Object)createdGroup);
        InternalDirectoryGroup foundGroup = this.groupDAO.findByName(1L, NON_EXISTING_GROUP.toUpperCase());
        Assert.assertEquals((Object)NON_EXISTING_GROUP, (Object)foundGroup.getName());
        Assert.assertEquals((Object)true, (Object)foundGroup.isActive());
        Assert.assertEquals((Object)NON_EXISTING_GROUP_DESC, (Object)foundGroup.getDescription());
        Assert.assertEquals((Object)GroupType.GROUP, (Object)foundGroup.getType());
    }

    @Test(expected=InvalidGroupException.class)
    public void testAddWhenGroupAlreadyExists() throws Exception {
        this.createNewGroup(EXISTING_GROUP_1);
    }

    @Test(expected=InvalidGroupException.class)
    public void testAddWhenGroupAlreadyExistsWithMixedCase() throws Exception {
        this.createNewGroup("AdministratorS");
    }

    @Test
    public void testAddLocal() throws Exception {
        Group createdGroup = this.createNewLocalGroup(NON_EXISTING_GROUP);
        Assert.assertNotNull((Object)createdGroup);
        InternalDirectoryGroup foundGroup = this.groupDAO.findByName(1L, NON_EXISTING_GROUP.toUpperCase());
        Assert.assertEquals((Object)NON_EXISTING_GROUP, (Object)foundGroup.getName());
        Assert.assertEquals((Object)true, (Object)foundGroup.isActive());
        Assert.assertEquals((Object)NON_EXISTING_GROUP_DESC, (Object)foundGroup.getDescription());
        Assert.assertEquals((Object)GroupType.GROUP, (Object)foundGroup.getType());
    }

    @Test(expected=InvalidGroupException.class)
    public void testAddLocalWhenGroupAlreadyExists() throws Exception {
        this.createNewLocalGroup(EXISTING_GROUP_1);
    }

    @Test(expected=InvalidGroupException.class)
    public void testAddLocalWhenGroupAlreadyExistsWithMixedCase() throws Exception {
        this.createNewLocalGroup("AdministratorS");
    }

    @Test
    public void testUpdate() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        GroupTemplate groupTemplate = new GroupTemplate((Group)group);
        groupTemplate.setActive(false);
        groupTemplate.setDescription(UPDATED_DESCRIPTION);
        this.groupDAO.update((Group)groupTemplate);
        InternalDirectoryGroup foundGroup = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        Assert.assertEquals((Object)EXISTING_GROUP_1, (Object)foundGroup.getName());
        Assert.assertEquals((Object)false, (Object)foundGroup.isActive());
        Assert.assertEquals((Object)UPDATED_DESCRIPTION, (Object)foundGroup.getDescription());
        Assert.assertEquals((Object)GroupType.GROUP, (Object)foundGroup.getType());
    }

    @Test
    public void testUpdateTypeChangeFail() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        GroupTemplate groupTemplate = new GroupTemplate((Group)group);
        groupTemplate.setActive(false);
        groupTemplate.setDescription(UPDATED_DESCRIPTION);
        groupTemplate.setType(GroupType.LEGACY_ROLE);
        try {
            this.groupDAO.update((Group)groupTemplate);
            Assert.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateWhenGroupDoesNotExist() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        this.groupDAO.remove((Group)group);
        try {
            this.groupDAO.update((Group)group);
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRename() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        this.groupDAO.rename((Group)group, NON_EXISTING_GROUP);
        try {
            this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        InternalDirectoryGroup renamedGroup = this.groupDAO.findByName(1L, NON_EXISTING_GROUP);
        Assert.assertEquals((Object)NON_EXISTING_GROUP, (Object)renamedGroup.getName());
        Assert.assertEquals((long)0L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(EXISTING_GROUP_1).returningAtMost(10)).size());
        Assert.assertEquals((long)1L, (long)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(NON_EXISTING_GROUP.toUpperCase()).returningAtMost(10)).size());
        List groups = this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("admin").returningAtMost(10));
        Assert.assertThat((Object)Groups.namesOf((Iterable)groups), (Matcher)Matchers.hasItem((Object)NON_EXISTING_GROUP));
        List groupNames = this.membershipDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("admin").returningAtMost(10));
        Assert.assertThat((Object)groupNames, (Matcher)Matchers.hasItem((Object)NON_EXISTING_GROUP));
    }

    @Test
    public void testRenameWhenGroupDoesNotExist() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        this.groupDAO.remove((Group)group);
        try {
            this.groupDAO.rename((Group)group, "new name");
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRenameWhenThereIsANameClash() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_1);
        try {
            this.groupDAO.rename((Group)group, EXISTING_GROUP_2);
            Assert.fail((String)"InvalidGroupException expected");
        }
        catch (InvalidGroupException invalidGroupException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() throws Exception {
        InternalDirectoryGroup group = this.groupDAO.findByName(1L, EXISTING_GROUP_2);
        this.groupDAO.remove((Group)group);
        try {
            this.groupDAO.findByName(1L, EXISTING_GROUP_2);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(EXISTING_GROUP_2).returningAtMost(10)).isEmpty());
        Assert.assertTrue((boolean)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(EXISTING_GROUP_2).returningAtMost(10)).isEmpty());
        Assert.assertTrue((boolean)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(EXISTING_GROUP_2).returningAtMost(10)).isEmpty());
    }

    @Test
    public void testRemoveWhenGroupDoesNotExist() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        this.groupDAO.remove((Group)group);
        try {
            this.groupDAO.remove((Group)group);
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testStoreAttributesWithUpdateAndInsertForExistingGroup() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        Assert.assertEquals((long)2L, (long)group.getKeys().size());
        Assert.assertTrue((boolean)group.getKeys().contains(COUNTRY_ATTRIBUTE));
        Assert.assertTrue((boolean)group.getKeys().contains(LANGUAGE_ATTRIBUTE));
        Assert.assertEquals((long)2L, (long)group.getValues(COUNTRY_ATTRIBUTE).size());
        Assert.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_NZ));
        Assert.assertTrue((boolean)group.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_AU));
        Assert.assertEquals((long)1L, (long)group.getValues(LANGUAGE_ATTRIBUTE).size());
        Assert.assertEquals((Object)LANGUAGE_ATTRIBUTE_VALUE, (Object)group.getValue(LANGUAGE_ATTRIBUTE));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put(COUNTRY_ATTRIBUTE, Sets.newHashSet((Object[])new String[]{COUNTRY_VALUE_NZ, "UK", "U.S.A"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.groupDAO.storeAttributes((Group)group, attributes);
        GroupWithAttributes returnedGroup = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1.toUpperCase());
        Assert.assertEquals((long)3L, (long)returnedGroup.getKeys().size());
        Assert.assertEquals((long)3L, (long)returnedGroup.getValues(COUNTRY_ATTRIBUTE).size());
        Assert.assertTrue((boolean)returnedGroup.getValues(COUNTRY_ATTRIBUTE).contains(COUNTRY_VALUE_NZ));
        Assert.assertTrue((boolean)returnedGroup.getValues(COUNTRY_ATTRIBUTE).contains("UK"));
        Assert.assertTrue((boolean)returnedGroup.getValues(COUNTRY_ATTRIBUTE).contains("U.S.A"));
        Assert.assertEquals((long)1L, (long)returnedGroup.getValues("phone").size());
        Assert.assertTrue((boolean)returnedGroup.getValues("phone").contains("131111"));
        Assert.assertEquals((long)1L, (long)group.getValues(LANGUAGE_ATTRIBUTE).size());
        Assert.assertEquals((Object)LANGUAGE_ATTRIBUTE_VALUE, (Object)group.getValue(LANGUAGE_ATTRIBUTE));
    }

    @Test
    public void testStoreAttributesWhenGroupDoesNotExist() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        this.groupDAO.remove((Group)group);
        try {
            this.groupDAO.storeAttributes((Group)group, (Map)ImmutableMap.of());
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAttribute() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        Assert.assertEquals((long)2L, (long)group.getKeys().size());
        this.groupDAO.removeAttribute((Group)group, COUNTRY_ATTRIBUTE);
        GroupWithAttributes updatedGroup = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1.toUpperCase());
        Assert.assertEquals((long)1L, (long)updatedGroup.getKeys().size());
        Assert.assertEquals((long)1L, (long)updatedGroup.getValues(LANGUAGE_ATTRIBUTE).size());
        Assert.assertEquals((Object)LANGUAGE_ATTRIBUTE_VALUE, (Object)updatedGroup.getValue(LANGUAGE_ATTRIBUTE));
    }

    @Test
    public void testRemoveAttributeWhenGroupDoesNotExist() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        this.groupDAO.remove((Group)group);
        try {
            this.groupDAO.removeAttribute((Group)group, "attribute name");
            Assert.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoteAttributeWhenAttributeDoesNotExist() throws Exception {
        GroupWithAttributes group = this.groupDAO.findByNameWithAttributes(1L, EXISTING_GROUP_1);
        this.groupDAO.removeAttribute((Group)group, "this attribute name does not exist");
    }

    @Test
    public void testAddAll() throws Exception {
        HashSet<GroupTemplate> groups = new HashSet<GroupTemplate>();
        for (int i = 0; i < 50; ++i) {
            GroupTemplate group = new GroupTemplate("Group" + i, 1L, GroupType.LEGACY_ROLE);
            group.setDescription("description");
            groups.add(group);
        }
        BatchResult result = this.groupDAO.addAll(groups);
        Assert.assertEquals((long)50L, (long)result.getTotalSuccessful());
        Assert.assertEquals((long)50L, (long)result.getTotalAttempted());
        Assert.assertTrue((boolean)result.getFailedEntities().isEmpty());
        Assert.assertEquals((long)50L, (long)this.groupDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.role()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"group")).returningAtMost(100)).size());
    }

    @Test
    public void testAddAllWithErrorsAndDuplicates() throws Exception {
        int groupCount = this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).returningAtMost(100)).size();
        HashSet<GroupTemplate> groups = new HashSet<GroupTemplate>();
        GroupTemplate group = new GroupTemplate("group", 1L, GroupType.LEGACY_ROLE);
        group.setDescription("description");
        groups.add(group);
        GroupTemplate existinggroup = new GroupTemplate((Group)this.groupDAO.findByName(1L, EXISTING_GROUP_1));
        group.setDescription("something different");
        groups.add(existinggroup);
        GroupTemplate differentDirectoryGroup = new GroupTemplate("group3", 2L, GroupType.LEGACY_ROLE);
        group.setDescription("description");
        groups.add(differentDirectoryGroup);
        BatchResult result = this.groupDAO.addAll(groups);
        Assert.assertEquals((long)2L, (long)result.getTotalSuccessful());
        Assert.assertEquals((long)groups.size(), (long)result.getTotalAttempted());
        Assert.assertThat((Object)Groups.namesOf((Iterable)result.getFailedEntities()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{EXISTING_GROUP_1}));
        Assert.assertEquals((long)(groupCount + 1), (long)this.groupDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).returningAtMost(100)).size());
    }

    private Group createNewGroup(String groupName) throws DirectoryNotFoundException, GroupNotFoundException, InvalidGroupException {
        GroupTemplate group = new GroupTemplate(groupName, 1L, GroupType.GROUP);
        group.setActive(true);
        group.setDescription(NON_EXISTING_GROUP_DESC);
        return this.groupDAO.add((Group)group);
    }

    private Group createNewLocalGroup(String groupName) throws DirectoryNotFoundException, GroupNotFoundException, InvalidGroupException {
        GroupTemplate group = new GroupTemplate(groupName, 1L, GroupType.GROUP);
        group.setActive(true);
        group.setDescription(NON_EXISTING_GROUP_DESC);
        return this.groupDAO.addLocal((Group)group);
    }
}

