/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.directory;

import com.atlassian.crowd.acceptance.tests.persistence.PersistenceTestHelper;
import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directories;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hibernate.SessionFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.test.jdbc.JdbcTestUtils;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml"})
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
@Transactional
public class DirectoryDAOHibernateTest {
    @Inject
    private DirectoryDAOHibernate directoryDAO;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private DataSource dataSource;
    @Inject
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private static final long DIRECTORY_ID = 1L;
    private static final String DIRECTORY_NAME_1 = "directory1";
    private static final String DIRECTORY_NAME_2 = "Directory Too";
    private static final String DIRECTORY_NAME_3 = "Third One";
    private static final String[] TABLES_TO_DELETE = new String[]{"cwd_app_dir_group_mapping", "cwd_app_dir_operation", "cwd_app_dir_mapping"};

    @BeforeTransaction
    public void loadTestData() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        PersistenceTestHelper.populateDatabase("sample-data.xml", jdbcTemplate);
    }

    @Before
    public void fixHiLo() {
        ArrayList errors = new ArrayList();
        this.resetableHiLoGeneratorHelper.setNextHiValue(errors);
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testAddDirectory() {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(true);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClass");
        directory.setType(DirectoryType.INTERNAL);
        directory.setAttribute("key", "value");
        DirectoryImpl returnedDirectory = this.directoryDAO.add((Directory)directory);
        Assert.assertNotNull((Object)returnedDirectory);
        Assert.assertNotNull((Object)returnedDirectory.getId());
        Assert.assertTrue((boolean)returnedDirectory.isActive());
        Assert.assertEquals((Object)DirectoryType.INTERNAL, (Object)returnedDirectory.getType());
        Assert.assertEquals((Object)"New Directory", (Object)returnedDirectory.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"New Directory"), (Object)returnedDirectory.getLowerName());
        Assert.assertNotNull((Object)returnedDirectory.getCreatedDate());
        Assert.assertNotNull((Object)returnedDirectory.getUpdatedDate());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClass", (Object)returnedDirectory.getImplementationClass());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClass".toLowerCase(Locale.ENGLISH), (Object)returnedDirectory.getLowerImplementationClass());
        Assert.assertNull((Object)returnedDirectory.getDescription());
        Assert.assertFalse((boolean)returnedDirectory.getAttributes().isEmpty());
        Assert.assertTrue((boolean)returnedDirectory.getAllowedOperations().isEmpty());
        Assert.assertEquals((Object)"value", (Object)returnedDirectory.getValue("key"));
    }

    @Test(expected=ConstraintViolationException.class)
    public void testAddDirectoryDuplicate() {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(false);
        directory.setName(DIRECTORY_NAME_1);
        directory.setImplementationClass("com.atlassian.crowd.TestClassic");
        directory.setType(DirectoryType.CONNECTOR);
        this.directoryDAO.add((Directory)directory);
        this.sessionFactory.getCurrentSession().flush();
    }

    @Test(expected=NullPointerException.class)
    public void testAddDirectoryIncomplete() {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(true);
        directory.setName("New Directory");
        this.directoryDAO.add((Directory)directory);
    }

    @Test
    public void testFindById() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        Assert.assertNotNull((Object)directory.getId());
        Assert.assertEquals((Object)DIRECTORY_NAME_1, (Object)directory.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)DIRECTORY_NAME_1), (Object)directory.getLowerName());
        Assert.assertEquals((Object)"Simple Directory", (Object)directory.getDescription());
        Assert.assertEquals((Object)"com.atlassian.crowd.directory.InternalDirectory", (Object)directory.getImplementationClass());
        Assert.assertEquals((Object)"com.atlassian.crowd.directory.InternalDirectory".toLowerCase(Locale.ENGLISH), (Object)directory.getLowerImplementationClass());
        Assert.assertEquals((Object)DirectoryType.INTERNAL, (Object)directory.getType());
        Assert.assertTrue((boolean)directory.isActive());
        Assert.assertEquals((Object)"Ten", (Object)directory.getValue("Number"));
        Assert.assertEquals((Object)"Red", (Object)directory.getValue("color"));
        Assert.assertEquals((long)4L, (long)directory.getKeys().size());
        Assert.assertEquals((long)6L, (long)directory.getAllowedOperations().size());
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_GROUP));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_USER));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_USER));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.DELETE_GROUP));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.DELETE_USER));
    }

    @Test(expected=DirectoryNotFoundException.class)
    public void testFindByIdNotFound() throws Exception {
        this.directoryDAO.findById(-1L);
    }

    @Test
    public void testFindByName() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findByName(DIRECTORY_NAME_2.toUpperCase());
        Assert.assertNotNull((Object)directory.getId());
        Assert.assertEquals((Object)DIRECTORY_NAME_2, (Object)directory.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)DIRECTORY_NAME_2), (Object)directory.getLowerName());
        Assert.assertEquals((Object)"Another Simple Directory", (Object)directory.getDescription());
        Assert.assertEquals((Object)"com.atlassian.crowd.directory.MyDirectory", (Object)directory.getImplementationClass());
        Assert.assertEquals((Object)"com.atlassian.crowd.directory.MyDirectory".toLowerCase(Locale.ENGLISH), (Object)directory.getLowerImplementationClass());
        Assert.assertEquals((Object)DirectoryType.CUSTOM, (Object)directory.getType());
        Assert.assertFalse((boolean)directory.isActive());
    }

    @Test(expected=DirectoryNotFoundException.class)
    public void testFindByNameNotFound() throws Exception {
        this.directoryDAO.findByName("bogus");
    }

    @Test
    public void testUpdateDirectory() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        directory.setActive(false);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClassic");
        directory.setType(DirectoryType.CUSTOM);
        directory.setDescription(null);
        this.directoryDAO.update((Directory)directory);
        DirectoryImpl updatedDirectory = this.directoryDAO.findById(1L);
        Assert.assertEquals((Object)"New Directory", (Object)updatedDirectory.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"New Directory"), (Object)updatedDirectory.getLowerName());
        Assert.assertNull((Object)updatedDirectory.getDescription());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClassic", (Object)updatedDirectory.getImplementationClass());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClassic".toLowerCase(Locale.ENGLISH), (Object)directory.getLowerImplementationClass());
        Assert.assertEquals((Object)DirectoryType.CUSTOM, (Object)updatedDirectory.getType());
        Assert.assertFalse((boolean)updatedDirectory.isActive());
        Assert.assertEquals((Object)"Ten", (Object)directory.getValue("Number"));
        Assert.assertEquals((Object)"Red", (Object)directory.getValue("color"));
        Assert.assertEquals((long)4L, (long)directory.getKeys().size());
        Assert.assertEquals((long)6L, (long)directory.getAllowedOperations().size());
    }

    @Test
    public void testAddDirectoryWithBellsAndWhistles() throws Exception {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(true);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClass");
        directory.setType(DirectoryType.INTERNAL);
        directory.setAttribute("One", "Two");
        directory.setAttribute("Three", "Four");
        HashSet<OperationType> ops = new HashSet<OperationType>(Arrays.asList(OperationType.CREATE_GROUP, OperationType.CREATE_USER));
        directory.setAllowedOperations(ops);
        this.directoryDAO.add((Directory)directory);
        DirectoryImpl addedDirectory = this.directoryDAO.findByName(directory.getName().toUpperCase());
        Assert.assertTrue((boolean)directory.isActive());
        Assert.assertEquals((Object)"New Directory", (Object)addedDirectory.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"New Directory"), (Object)addedDirectory.getLowerName());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClass", (Object)addedDirectory.getImplementationClass());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClass".toLowerCase(Locale.ENGLISH), (Object)addedDirectory.getLowerImplementationClass());
        Assert.assertEquals((Object)DirectoryType.INTERNAL, (Object)addedDirectory.getType());
        Assert.assertEquals((Object)"Two", (Object)directory.getValue("One"));
        Assert.assertEquals((Object)"Four", (Object)directory.getValue("Three"));
        Assert.assertEquals((long)2L, (long)directory.getKeys().size());
        Assert.assertEquals(ops, (Object)directory.getAllowedOperations());
    }

    @Test
    public void testUpdateDirectoryWithBellsAndWhistles() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        directory.setActive(false);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClassic");
        directory.setType(DirectoryType.CUSTOM);
        directory.setDescription(null);
        directory.setAttribute("Number", "one");
        directory.getAllowedOperations().remove(OperationType.DELETE_GROUP);
        directory.getAllowedOperations().remove(OperationType.DELETE_USER);
        this.directoryDAO.update((Directory)directory);
        DirectoryImpl updatedDirectory = this.directoryDAO.findById(1L);
        Assert.assertEquals((Object)"New Directory", (Object)updatedDirectory.getName());
        Assert.assertEquals((Object)IdentifierUtils.toLowerCase((String)"New Directory"), (Object)updatedDirectory.getLowerName());
        Assert.assertNull((Object)updatedDirectory.getDescription());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClassic", (Object)updatedDirectory.getImplementationClass());
        Assert.assertEquals((Object)"com.atlassian.crowd.TestClassic".toLowerCase(Locale.ENGLISH), (Object)updatedDirectory.getLowerImplementationClass());
        Assert.assertEquals((Object)DirectoryType.CUSTOM, (Object)updatedDirectory.getType());
        Assert.assertFalse((boolean)updatedDirectory.isActive());
        Assert.assertEquals((Object)"one", (Object)directory.getValue("Number"));
        Assert.assertEquals((Object)"Red", (Object)directory.getValue("color"));
        Assert.assertEquals((long)4L, (long)directory.getKeys().size());
        Assert.assertEquals((long)4L, (long)directory.getAllowedOperations().size());
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_GROUP));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_USER));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP));
        Assert.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_USER));
    }

    @Test
    public void testRemove() throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        JdbcTestUtils.deleteFromTables((JdbcTemplate)jdbcTemplate, (String[])TABLES_TO_DELETE);
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        this.directoryDAO.remove((Directory)directory);
        try {
            this.directoryDAO.findById(1L);
            Assert.fail((String)"DirectoryNotFoundException expected");
        }
        catch (DirectoryNotFoundException directoryNotFoundException) {
            // empty catch block
        }
        this.sessionFactory.getCurrentSession().flush();
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_directory_attribute where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_directory_operation where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_user where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_user_attribute where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_user_credential_record", Integer.class), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_group where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_group_attribute where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)jdbcTemplate.queryForObject("select count(*) from cwd_membership where directory_id = ?", Integer.class, new Object[]{1L}), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testSearchAll() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(10));
        Assert.assertThat((Object)Directories.namesOf((Iterable)directories), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{DIRECTORY_NAME_1, DIRECTORY_NAME_2, DIRECTORY_NAME_3}));
    }

    @Test
    public void testSearchByNameStartingWith() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.NAME).startingWith((Object)"directory")).returningAtMost(10));
        Assert.assertThat((Object)Directories.namesOf((Iterable)directories), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{DIRECTORY_NAME_1, DIRECTORY_NAME_2}));
    }

    @Test
    public void testSearchByNameContaining() {
        List direcotries = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.NAME).containing((Object)"oo")).returningAtMost(10));
        Assert.assertThat((Object)Directories.namesOf((Iterable)direcotries), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{DIRECTORY_NAME_2}));
    }

    @Test
    public void testSearchByActive() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.ACTIVE).exactlyMatching((Object)true)).returningAtMost(10));
        Assert.assertThat((Object)Directories.namesOf((Iterable)directories), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{DIRECTORY_NAME_1}));
    }

    @Test
    public void testSearchByType() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.INTERNAL)).returningAtMost(10));
        Assert.assertThat((Object)Directories.namesOf((Iterable)directories), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{DIRECTORY_NAME_1}));
    }

    @Test
    public void testSearchByImplementationClass() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.IMPLEMENTATION_CLASS).containing((Object)"InternalDirectory")).returningAtMost(10));
        Assert.assertThat((Object)Directories.namesOf((Iterable)directories), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{DIRECTORY_NAME_1}));
    }

    @Test
    public void testSearchNestedQuery() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.NAME).startingWith((Object)"dir"), Restriction.on((Property)DirectoryTermKeys.ACTIVE).exactlyMatching((Object)true)}), Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.IMPLEMENTATION_CLASS).containing((Object)"my"), Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CUSTOM)})})).returningAtMost(10));
        Assert.assertThat((Object)Directories.namesOf((Iterable)directories), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{DIRECTORY_NAME_1, DIRECTORY_NAME_2}));
    }
}

