/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class PersistenceTestHelper {
    public static final String TEST_DATA_XML = "sample-data.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateDatabase(String dataFileName, JdbcTemplate jdbcTemplate) throws DatabaseUnitException, IOException, SQLException {
        DataSource ds = jdbcTemplate.getDataSource();
        Connection con = DataSourceUtils.getConnection((DataSource)ds);
        DatabaseConnection dbUnitCon = new DatabaseConnection(con);
        DatabaseConfig config = dbUnitCon.getConfig();
        config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new HsqldbDataTypeFactory());
        InputStream datasetStream = ClassLoaderUtils.getResourceAsStream((String)dataFileName, PersistenceTestHelper.class);
        FlatXmlDataSet dataSet = new FlatXmlDataSetBuilder().build(datasetStream);
        try {
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)dbUnitCon, (IDataSet)dataSet);
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
        }
    }

    public static void fixHiLo(ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper) {
        ArrayList errors = new ArrayList();
        resetableHiLoGeneratorHelper.setNextHiValue(errors);
        Assert.assertThat(errors, (Matcher)IsEmptyCollection.emptyCollectionOf(String.class));
    }
}

