/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory.suite;

import com.atlassian.crowd.acceptance.tests.directory.BasicTest;
import com.atlassian.crowd.acceptance.tests.directory.DnRangeTest;
import com.atlassian.crowd.acceptance.tests.directory.EnabledDisabledUserTest;
import com.atlassian.crowd.acceptance.tests.directory.NestedGroupsTest;
import com.atlassian.crowd.acceptance.tests.directory.PageAndRangeTest;
import com.atlassian.crowd.acceptance.tests.directory.PrimaryGroupTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import java.util.Properties;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={AD2K3BasicTest.class, AD2K3NestedGroupsTest.class, AD2K3PrimaryGroupTest.class, AD2K3EnabledDisabledUserTest.class, AD2K3ForwardslashTest.class, AD2K3BackslashTest.class, AD2K3DnRangeTestCacheEnabled.class, AD2K3DnRangeTestCacheDisabled.class, AD2K3PageAndRangeTest.class})
public class ActiveDirectory2K3Test {

    public static class AD2K3DnRangeTestCacheDisabled
    extends DnRangeTest {
        public AD2K3DnRangeTestCacheDisabled() {
            super(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        @Override
        protected DirectoryImpl configureDirectory(Properties directorySettings) {
            DirectoryImpl directory = super.configureDirectory(directorySettings);
            directory.setAttribute("ldap.roles.disabled", Boolean.TRUE.toString());
            directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.FALSE.toString());
            return directory;
        }
    }

    public static class AD2K3DnRangeTestCacheEnabled
    extends DnRangeTest {
        public AD2K3DnRangeTestCacheEnabled() {
            super(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        @Override
        protected DirectoryImpl configureDirectory(Properties directorySettings) {
            DirectoryImpl directory = super.configureDirectory(directorySettings);
            directory.setAttribute("ldap.roles.disabled", Boolean.TRUE.toString());
            directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
            return directory;
        }
    }

    public static class AD2K3PageAndRangeTest
    extends PageAndRangeTest {
        public AD2K3PageAndRangeTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }
    }

    public static class AD2K3ForwardslashTest
    extends BasicTest {
        public AD2K3ForwardslashTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        @Override
        public String getAutoTestFirstName() {
            return "user/name";
        }

        @Override
        public String getAutoTestGroupName() {
            return "My / Group //Name auto-t";
        }
    }

    public static class AD2K3BackslashTest
    extends BasicTest {
        public AD2K3BackslashTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        @Override
        public String getAutoTestFirstName() {
            return "First\\ Name";
        }

        @Override
        public String getAutoTestGroupName() {
            return "My \\ Group\\Name auto-t";
        }
    }

    public static class AD2K3EnabledDisabledUserTest
    extends EnabledDisabledUserTest {
        public AD2K3EnabledDisabledUserTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }
    }

    public static class AD2K3PrimaryGroupTest
    extends PrimaryGroupTest {
        public AD2K3PrimaryGroupTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }

        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.activedirectory.use_primary_groups", "true");
        }
    }

    public static class AD2K3NestedGroupsTest
    extends NestedGroupsTest {
        public AD2K3NestedGroupsTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }
    }

    public static class AD2K3BasicTest
    extends BasicTest {
        public AD2K3BasicTest() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getAD2K3ConfigFileName());
        }
    }
}

