/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class PrimaryGroupTest
extends BaseTest {
    protected final String userNameA = "user-A";
    protected final String password = "secret-password";
    private static final String PRIMARY_GROUP_NAME = "Domain Users";

    @Override
    protected void loadTestData() throws Exception {
        DirectoryTestHelper.addUser("user-A", this.directory.getId(), "secret-password", this.getRemoteDirectory());
    }

    @Override
    protected void removeTestData() throws DirectoryInstantiationException {
        DirectoryTestHelper.silentlyRemoveUser("user-A", this.getRemoteDirectory());
    }

    public void testCannotRemovePrimaryGroup() throws Exception {
        try {
            this.directoryManager.removeGroup(this.directory.getId(), PRIMARY_GROUP_NAME);
            PrimaryGroupTest.fail((String)"OperationFailedException expected");
        }
        catch (OperationFailedException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot remove group 'Domain Users' because it is the primary group of some user(s)"));
        }
    }

    public void testNewUserHasPrimaryGroupAttributeAndObjectSid() throws Exception {
        UserWithAttributes user = this.directoryManager.findUserWithAttributesByName(this.directory.getId(), "user-A");
        PrimaryGroupTest.assertNotNull((Object)user.getValue("primaryGroupId"));
        PrimaryGroupTest.assertNotNull((Object)user.getValue("objectSid"));
    }

    public void testFindPrimaryGroupByName() throws Exception {
        Group group = this.directoryManager.findGroupByName(this.directory.getId(), PRIMARY_GROUP_NAME);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)Matchers.is((Object)PRIMARY_GROUP_NAME));
        MatcherAssert.assertThat((Object)group.getDescription(), (Matcher)Matchers.is((Object)"All domain users"));
    }

    public void testFindPrimaryGroupHasObjectSidAttribute() throws Exception {
        GroupWithAttributes group = this.directoryManager.findGroupWithAttributesByName(this.directory.getId(), PRIMARY_GROUP_NAME);
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)Matchers.is((Object)PRIMARY_GROUP_NAME));
        MatcherAssert.assertThat((Object)group.getDescription(), (Matcher)Matchers.is((Object)"All domain users"));
        PrimaryGroupTest.assertNotNull((Object)group.getValue("objectSid"));
    }

    public void testSearchAllGroupsReturnsPrimaryGroup() throws Exception {
        List groups = this.directoryManager.searchGroups(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1));
        MatcherAssert.assertThat(groups, (Matcher)Matchers.hasItem((Object)PRIMARY_GROUP_NAME));
    }

    public void testNewUserIsDirectMemberOfPrimaryGroup() throws Exception {
        PrimaryGroupTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(this.directory.getId(), "user-A", PRIMARY_GROUP_NAME));
    }

    public void testPrimaryGroupMembersContainsNewUser() throws Exception {
        List members = this.directoryManager.searchDirectGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(PRIMARY_GROUP_NAME).returningAtMost(-1));
        MatcherAssert.assertThat(members, (Matcher)Matchers.hasItem((Object)"user-A"));
    }

    public void testNewUserGroupsContainsPrimaryGroup() throws Exception {
        List groups = this.directoryManager.searchDirectGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("user-A").returningAtMost(-1));
        MatcherAssert.assertThat(groups, (Matcher)Matchers.hasItem((Object)PRIMARY_GROUP_NAME));
    }

    public void testCannotAddUserToPrimaryGroup() throws Exception {
        try {
            this.directoryManager.addUserToGroup(this.directory.getId(), "user-A", PRIMARY_GROUP_NAME);
            PrimaryGroupTest.fail((String)"MembershipAlreadyExists expected");
        }
        catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            // empty catch block
        }
    }

    public void testCannotRemoveUserFromPrimaryGroup() throws Exception {
        try {
            this.directoryManager.removeUserFromGroup(this.directory.getId(), "user-A", PRIMARY_GROUP_NAME);
            PrimaryGroupTest.fail((String)"OperationFailedException expected");
        }
        catch (OperationFailedException e) {
            PrimaryGroupTest.assertEquals((String)"Cannot remove user 'user-A' from group 'Domain Users' because it is the primary group of the user", (String)e.getMessage());
        }
    }

    public void testGetMemberships() throws Exception {
        Iterable allMemberships = this.getRemoteDirectory().getMemberships();
        Iterable membershipsOfPrimaryGroup = Iterables.filter((Iterable)allMemberships, (Predicate)new Predicate<Membership>(){

            public boolean apply(@Nullable Membership input) {
                return input.getGroupName().equals(PrimaryGroupTest.PRIMARY_GROUP_NAME);
            }
        });
        MatcherAssert.assertThat((Object)((Membership)Iterables.getOnlyElement((Iterable)membershipsOfPrimaryGroup)).getUserNames(), (Matcher)Matchers.hasItem((Object)"user-A"));
    }
}

