/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.EscapedDnTest;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class LdapDirectoryWithEscapedDnsTest
extends BaseTest {
    public LdapDirectoryWithEscapedDnsTest() {
        this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
    }

    @Override
    protected void loadTestData() throws Exception {
        InputStream in = EscapedDnTest.class.getResourceAsStream("EscapedDnTest-entries.ldif");
        LdapDirectoryWithEscapedDnsTest.assertNotNull((Object)in);
        new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).setLdif(in);
    }

    @Override
    protected void removeTestData() {
    }

    RemoteDirectory getReconfiguredDirectory(String baseDn) throws DirectoryInstantiationException {
        this.directory.setAttribute("ldap.basedn", baseDn);
        return this.getRemoteDirectory();
    }

    public void testCreateNewUserWithoutSlashInDn() throws Exception {
        String username = "new-user";
        RemoteDirectory rd = this.getReconfiguredDirectory("ou=escaping,dc=example,dc=com");
        UserTemplate user = new UserTemplate(username);
        User added = rd.addUser(user, PasswordCredential.NONE);
        LdapDirectoryWithEscapedDnsTest.assertEquals((String)username, (String)added.getName());
        rd.removeUser(username);
    }

    public void testCreateNewUserWithSlashInDn() throws Exception {
        String usernameWithSlashes = "New/User/with/Slashes";
        RemoteDirectory rd = this.getReconfiguredDirectory("ou=escaping,dc=example,dc=com");
        UserTemplate user = new UserTemplate(usernameWithSlashes);
        User added = rd.addUser(user, PasswordCredential.NONE);
        LdapDirectoryWithEscapedDnsTest.assertEquals((String)usernameWithSlashes, (String)added.getName());
        rd.removeUser(usernameWithSlashes);
    }

    public void testSearchUsersWithoutSlashInBaseDn() throws Exception {
        RemoteDirectory rd = this.getReconfiguredDirectory("ou=escaping,dc=example,dc=com");
        List users = rd.searchUsers((EntityQuery)new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1));
        Assert.assertThat((Object)users, (Matcher)CoreMatchers.not((Matcher)Matchers.empty()));
    }

    public void testSearchUsersWhenSlashInBaseDn() throws Exception {
        RemoteDirectory rd = this.getReconfiguredDirectory("cn=group/with/slashes,ou=escaping,dc=example,dc=com");
        List users = rd.searchUsers((EntityQuery)new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1));
        LdapDirectoryWithEscapedDnsTest.assertEquals(Collections.emptyList(), (Object)users);
    }

    public void testGetMembershipsReturnsAllMembershipsCorrectlyUnescaped() throws OperationFailedException {
        RemoteDirectory rd = this.getReconfiguredDirectory("ou=escaping,dc=example,dc=com");
        ImmutableList memberships = ImmutableList.copyOf((Iterable)rd.getMemberships());
        Assert.assertThat((Object)memberships, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((Membership)memberships.get(0)).getUserNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"User \"with\" Quotes", "User with Spaces", "User/with/Slashes", "User,with,Commas", "User\\with\\Backslashes"}));
        Assert.assertThat((Object)((Membership)memberships.get(0)).getChildGroupNames(), (Matcher)Matchers.empty());
    }
}

