/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.BasicTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class EnabledDisabledUserTest
extends BaseTest {
    private final String userNameA = "user-A";
    private final String userNameB = "user-B";
    private final String firstName = "First";
    private final String surName = "Last";
    private final String displayName = "Display Name";
    private final String email = "user@example.test";
    private final String password = "secret-password";

    @Override
    protected void removeTestData() throws DirectoryInstantiationException {
        DirectoryTestHelper.silentlyRemoveUser("user-A", this.getRemoteDirectory());
        DirectoryTestHelper.silentlyRemoveUser("user-B", this.getRemoteDirectory());
    }

    @Override
    protected void loadTestData() throws Exception {
        UserTemplate enabledUserTemplate = new UserTemplate("user-A", "First", "Last", "Display Name");
        enabledUserTemplate.setActive(true);
        enabledUserTemplate.setEmailAddress("user@example.test");
        this.getRemoteDirectory().addUser(enabledUserTemplate, PasswordCredential.unencrypted((String)"secret-password"));
        UserTemplate disabledUserTemplate = new UserTemplate("user-B", "First", "Last", "Display Name");
        disabledUserTemplate.setActive(false);
        enabledUserTemplate.setEmailAddress("user@example.test");
        this.getRemoteDirectory().addUser(disabledUserTemplate, PasswordCredential.unencrypted((String)"secret-password"));
    }

    public void testEnabledUserIsEnabled() throws Exception {
        User user = BasicTest.getImplementation((Directory)this.directory).findUserByName("user-A");
        EnabledDisabledUserTest.assertTrue((String)"User should be enabled", (boolean)user.isActive());
    }

    public void testDisabledUserIsDisabled() throws Exception {
        User user = BasicTest.getImplementation((Directory)this.directory).findUserByName("user-B");
        EnabledDisabledUserTest.assertFalse((String)"User should be disabled", (boolean)user.isActive());
    }

    public void testUserCanBeDisabledAndEnabledAgain() throws Exception {
        User user = BasicTest.getImplementation((Directory)this.directory).findUserByName("user-A");
        EnabledDisabledUserTest.assertTrue((String)"User should be enabled", (boolean)user.isActive());
        UserTemplate disabledUserTemplate = new UserTemplate(user);
        disabledUserTemplate.setActive(false);
        BasicTest.getImplementation((Directory)this.directory).updateUser(disabledUserTemplate);
        user = BasicTest.getImplementation((Directory)this.directory).findUserByName("user-A");
        EnabledDisabledUserTest.assertFalse((String)"User should be disabled", (boolean)user.isActive());
        UserTemplate enabledUserTemplate = new UserTemplate(user);
        enabledUserTemplate.setActive(true);
        BasicTest.getImplementation((Directory)this.directory).updateUser(enabledUserTemplate);
        user = BasicTest.getImplementation((Directory)this.directory).findUserByName("user-A");
        EnabledDisabledUserTest.assertTrue((String)"User should be enabled", (boolean)user.isActive());
    }

    public void testQueryEnabledUsers() throws Exception {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true), (int)0, (int)-1);
        List users = BasicTest.getImplementation((Directory)this.directory).searchUsers(query);
        Assert.assertThat((Object)users, (Matcher)Matchers.hasItem((Object)"user-A"));
        Assert.assertThat((Object)users, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"user-B")));
    }

    public void testQueryDisabledUsers() throws Exception {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)false), (int)0, (int)-1);
        List users = BasicTest.getImplementation((Directory)this.directory).searchUsers(query);
        Assert.assertThat((Object)users, (Matcher)Matchers.hasItem((Object)"user-B"));
        Assert.assertThat((Object)users, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"user-A")));
    }

    public void testEnabledAndDisabledUsersShouldBeReturnedWhenQueryingAllUsers() throws Exception {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)NullRestrictionImpl.INSTANCE, (int)0, (int)-1);
        List users = BasicTest.getImplementation((Directory)this.directory).searchUsers(query);
        Assert.assertThat((Object)users, (Matcher)Matchers.hasItem((Object)"user-A"));
        Assert.assertThat((Object)users, (Matcher)Matchers.hasItem((Object)"user-B"));
    }
}

